/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.chart;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.chart.AxisColumn;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.chart.ChartSeries;
import org.squashtest.tm.domain.chart.ChartType;
import org.squashtest.tm.domain.chart.Filter;
import org.squashtest.tm.domain.chart.MeasureColumn;
import org.squashtest.tm.domain.chart.ScopeType;
import org.squashtest.tm.domain.query.ColumnType;
import org.squashtest.tm.domain.query.DataType;
import org.squashtest.tm.domain.query.Operation;
import org.squashtest.tm.domain.query.QueryColumnPrototype;
import org.squashtest.tm.domain.query.SpecializedEntityType;

public class JsonChartInstance {
    private String name;
    private ChartType type;
    private String createdBy;
    private String lastModifiedBy;
    private Date createdOn;
    private Date lastModifiedOn;
    private List<JsonMeasureColumn> measures = new ArrayList<JsonMeasureColumn>();
    private List<JsonAxisColumn> axes = new ArrayList<JsonAxisColumn>();
    private List<JsonFilter> filters = new ArrayList<JsonFilter>();
    private List<Object[]> abscissa = new ArrayList<Object[]>();
    private Map<String, List<Object>> series = new HashMap<String, List<Object>>();
    private List<String> projectScope = new ArrayList<String>();
    private List<String> colours = new ArrayList<String>();
    private List<JsonEntityReference> scope = new ArrayList<JsonEntityReference>();
    private ScopeType scopeType;
    private Long projectId;

    public JsonChartInstance() {
    }

    public JsonChartInstance(ChartInstance instance) {
        ChartDefinition def = instance.getDefinition();
        this.name = def.getName();
        this.type = def.getType();
        this.projectId = def.getProject().getId();
        this.doAuditableAttributes(def);
        for (AxisColumn ax : def.getAxis()) {
            this.axes.add(new JsonAxisColumn(ax));
        }
        for (MeasureColumn me : def.getMeasures()) {
            this.measures.add(new JsonMeasureColumn(me));
        }
        for (Filter filter : def.getFilters()) {
            this.filters.add(new JsonFilter(filter));
        }
        for (EntityReference ref : def.getScope()) {
            this.scope.add(new JsonEntityReference(ref));
        }
        this.scopeType = def.getScopeType();
        this.projectScope = instance.getDefinition().getProjectScope();
        ChartSeries chartSeries = instance.getSeries();
        this.abscissa = chartSeries.getAbscissa();
        this.colours = chartSeries.getColours();
        this.series = chartSeries.getSeries();
    }

    private void doAuditableAttributes(ChartDefinition def) {
        ChartDefinition audit = def;
        this.createdBy = audit.getCreatedBy();
        this.lastModifiedBy = audit.getLastModifiedBy();
        this.createdOn = audit.getCreatedOn();
        this.lastModifiedOn = audit.getLastModifiedOn();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Long getProjectId() {
        return this.projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(String createdBy) {
        this.createdBy = createdBy;
    }

    public String getLastModifiedBy() {
        return this.lastModifiedBy;
    }

    public void setLastModifiedBy(String lastModifiedBy) {
        this.lastModifiedBy = lastModifiedBy;
    }

    public Date getCreatedOn() {
        return this.createdOn;
    }

    public void setCreatedOn(Date createdOn) {
        this.createdOn = createdOn;
    }

    public Date getLastModifiedOn() {
        return this.lastModifiedOn;
    }

    public void setLastModifiedOn(Date lastModifiedOn) {
        this.lastModifiedOn = lastModifiedOn;
    }

    public ChartType getType() {
        return this.type;
    }

    public void setType(ChartType type) {
        this.type = type;
    }

    public ScopeType getScopeType() {
        return this.scopeType;
    }

    public void setScopeType(ScopeType scopeType) {
        this.scopeType = scopeType;
    }

    public List<JsonMeasureColumn> getMeasures() {
        return this.measures;
    }

    public void setMeasures(List<JsonMeasureColumn> measures) {
        this.measures = measures;
    }

    public List<JsonAxisColumn> getAxes() {
        return this.axes;
    }

    public void setAxes(List<JsonAxisColumn> axes) {
        this.axes = axes;
    }

    public List<Object[]> getAbscissa() {
        return this.abscissa;
    }

    public void setAbscissa(List<Object[]> abscissa) {
        this.abscissa = abscissa;
    }

    public Map<String, List<Object>> getSeries() {
        return this.series;
    }

    public void setSeries(Map<String, List<Object>> series) {
        this.series = series;
    }

    public List<JsonFilter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<JsonFilter> filters) {
        this.filters = filters;
    }

    public List<JsonEntityReference> getScope() {
        return this.scope;
    }

    public void setScope(List<JsonEntityReference> scope) {
        this.scope = scope;
    }

    public List<String> getProjectScope() {
        return this.projectScope;
    }

    public void setProjectScope(List<String> projectScope) {
        this.projectScope = projectScope;
    }

    public List<String> getColours() {
        return this.colours;
    }

    public void setColours(List<String> colours) {
        this.colours = colours;
    }

    public static final class JsonAxisColumn {
        private Long cufId;
        private String label;
        private JsonColumnPrototype columnPrototype;
        private JsonOperation operation;

        public JsonAxisColumn() {
        }

        public JsonAxisColumn(AxisColumn axis) {
            this.label = axis.getLabel();
            this.setColumnPrototype(new JsonColumnPrototype(axis.getColumn()));
            this.setOperation(new JsonOperation(axis.getOperation()));
            this.cufId = axis.getCufId();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public JsonColumnPrototype getColumnPrototype() {
            return this.columnPrototype;
        }

        public void setColumnPrototype(JsonColumnPrototype columnPrototype) {
            this.columnPrototype = columnPrototype;
        }

        public JsonOperation getOperation() {
            return this.operation;
        }

        public void setOperation(JsonOperation operation) {
            this.operation = operation;
        }

        public Long getCufId() {
            return this.cufId;
        }

        public void setCufId(Long cufId) {
            this.cufId = cufId;
        }
    }

    public static final class JsonColumnPrototype {
        private ColumnType columnType;
        private String label;
        private JsonSpecializedEntityType specializedEntityType;
        private DataType dataType;

        public JsonColumnPrototype(QueryColumnPrototype column) {
            this.label = column.getLabel();
            this.specializedEntityType = new JsonSpecializedEntityType(column.getSpecializedType());
            this.dataType = column.getDataType();
            this.columnType = column.getColumnType();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public JsonSpecializedEntityType getSpecializedEntityType() {
            return this.specializedEntityType;
        }

        public void setSpecializedEntityType(JsonSpecializedEntityType specializedEntityType) {
            this.specializedEntityType = specializedEntityType;
        }

        public DataType getDataType() {
            return this.dataType;
        }

        public void setDataType(DataType dataType) {
            this.dataType = dataType;
        }

        public ColumnType getColumnType() {
            return this.columnType;
        }
    }

    public static final class JsonEntityReference {
        private EntityType entityType;
        private long id;
        private String name;

        public JsonEntityReference(EntityReference entityReference) {
            this.entityType = entityReference.getType();
            this.id = entityReference.getId();
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public void setEntityType(EntityType entityType) {
            this.entityType = entityType;
        }

        public long getId() {
            return this.id;
        }

        public void setId(long id) {
            this.id = id;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static final class JsonFilter {
        private Long cufId;
        private List<String> values;
        private JsonColumnPrototype columnPrototype;
        private JsonOperation operation;
        private Long id;

        public JsonFilter(Filter filter) {
            this.columnPrototype = new JsonColumnPrototype(filter.getColumn());
            this.operation = new JsonOperation(filter.getOperation());
            this.values = filter.getValues();
            this.cufId = filter.getCufId();
            this.id = filter.getId();
        }

        public List<String> getValues() {
            return this.values;
        }

        public void setValues(List<String> values) {
            this.values = values;
        }

        public JsonColumnPrototype getColumnPrototype() {
            return this.columnPrototype;
        }

        public void setColumnPrototype(JsonColumnPrototype columnPrototype) {
            this.columnPrototype = columnPrototype;
        }

        public JsonOperation getOperation() {
            return this.operation;
        }

        public void setOperation(JsonOperation operation) {
            this.operation = operation;
        }

        public Long getCufId() {
            return this.cufId;
        }

        public void setCufId(Long cufId) {
            this.cufId = cufId;
        }

        public Long getId() {
            return this.id;
        }

        public void setId(Long id) {
            this.id = id;
        }
    }

    public static final class JsonMeasureColumn {
        private Long cufId;
        private String label;
        private JsonColumnPrototype columnPrototype;
        private JsonOperation operation;

        public JsonMeasureColumn() {
        }

        public JsonMeasureColumn(MeasureColumn measure) {
            this.label = measure.getLabel();
            this.columnPrototype = new JsonColumnPrototype(measure.getColumn());
            this.operation = new JsonOperation(measure.getOperation());
            this.cufId = measure.getCufId();
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public JsonColumnPrototype getColumnPrototype() {
            return this.columnPrototype;
        }

        public void setColumnPrototype(JsonColumnPrototype columnPrototype) {
            this.columnPrototype = columnPrototype;
        }

        public JsonOperation getOperation() {
            return this.operation;
        }

        public void setOperation(JsonOperation operation) {
            this.operation = operation;
        }

        public Long getCufId() {
            return this.cufId;
        }

        public void setCufId(Long cufId) {
            this.cufId = cufId;
        }
    }

    public static final class JsonOperation {
        private String name;

        public JsonOperation(Operation operation) {
            this.name = operation.name();
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    public static final class JsonSpecializedEntityType {
        private EntityType entityType;
        private SpecializedEntityType.EntityRole entityRole;

        public JsonSpecializedEntityType(SpecializedEntityType specializedEntityType) {
            this.entityRole = specializedEntityType.getEntityRole();
            this.entityType = specializedEntityType.getEntityType();
        }

        public EntityType getEntityType() {
            return this.entityType;
        }

        public void setEntityType(EntityType entityType) {
            this.entityType = entityType;
        }

        public SpecializedEntityType.EntityRole getEntityRole() {
            return this.entityRole;
        }

        public void setEntityRole(SpecializedEntityType.EntityRole entityRole) {
            this.entityRole = entityRole;
        }
    }
}

