/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.chart;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.validation.Valid;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.chart.ChartInstance;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.customreport.CustomReportTreeEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementCriticality;
import org.squashtest.tm.domain.requirement.RequirementStatus;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.testcase.TestCaseStatus;
import org.squashtest.tm.service.chart.ChartModificationService;
import org.squashtest.tm.service.customfield.CustomFieldBindingModificationService;
import org.squashtest.tm.service.customreport.CustomReportLibraryNodeService;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.chart.JsonChartInstance;
import org.squashtest.tm.web.internal.helper.I18nLevelEnumInfolistHelper;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.model.builder.JsonProjectBuilder;
import org.squashtest.tm.web.internal.model.json.JsonChartWizardData;

@Controller
@RequestMapping(value={"charts"})
public class ChartController {
    @Inject
    private UserAccountService userService;
    @Inject
    private ChartModificationService chartService;
    @Inject
    private CustomReportLibraryNodeService reportNodeService;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private InfoListFinderService infoListFinder;
    @Inject
    private I18nLevelEnumInfolistHelper i18nLevelEnumInfolistHelper;
    @Inject
    private CustomFieldBindingModificationService cufBindingService;
    @Inject
    private JsonProjectBuilder jsonProjectBuilder;

    @RequestMapping(method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonChartWizardData getWizardData() {
        List readableProjects = this.projectFinder.findAllReadable();
        return new JsonChartWizardData(this.chartService.getColumnPrototypes(), readableProjects, this.infoListFinder, this.cufBindingService);
    }

    @RequestMapping(value={"/wizard/{parentId}"}, method={RequestMethod.GET})
    public ModelAndView getWizard(@PathVariable Long parentId, Locale locale) {
        ModelAndView mav = new ModelAndView("charts/wizard/wizard.html");
        CustomReportLibraryNode crln = this.reportNodeService.findCustomReportLibraryNodeById(parentId);
        if (crln.getEntityType().getTypeName().equals("CHART")) {
            ChartDefinition def = (ChartDefinition)crln.getEntity();
            mav.addObject("chartDef", (Object)JsonHelper.serialize(def));
        }
        Project project = this.reportNodeService.findCustomReportLibraryNodeById(parentId).getCustomReportLibrary().getProject();
        mav.addObject("parentId", (Object)parentId);
        mav.addObject("defaultProject", (Object)project.getId());
        mav.addObject("defaultInfoLists", (Object)this.i18nLevelEnumInfolistHelper.getInternationalizedDefaultList(locale));
        mav.addObject("testCaseImportance", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseImportance.class, locale));
        mav.addObject("testCaseStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(TestCaseStatus.class, locale));
        mav.addObject("requirementStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementStatus.class, locale));
        mav.addObject("requirementCriticality", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(RequirementCriticality.class, locale));
        mav.addObject("executionStatus", (Object)this.i18nLevelEnumInfolistHelper.getI18nLevelEnum(ExecutionStatus.class, locale));
        mav.addObject("projectsMeta", this.jsonProjectBuilder.getExtendedReadableProjects());
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/{definitionId}/instance"}, method={RequestMethod.GET})
    public JsonChartInstance generate(@PathVariable(value="definitionId") Long definitionId) {
        ChartInstance instance = this.chartService.generateChart(definitionId.longValue(), null, null);
        return new JsonChartInstance(instance);
    }

    @ResponseBody
    @RequestMapping(value={"/instance"}, method={RequestMethod.POST})
    public JsonChartInstance generate(@RequestBody @Valid ChartDefinition definition) {
        ChartInstance instance = this.chartService.generateChart(definition, null, null);
        return new JsonChartInstance(instance);
    }

    @ResponseBody
    @RequestMapping(value={"/instance/{projectId}"}, method={RequestMethod.POST})
    public JsonChartInstance generateWithoutProject(@PathVariable(value="projectId") Long projectId, @RequestBody @Valid ChartDefinition definition) {
        ChartInstance instance = this.chartService.generateChart(definition, projectId);
        return new JsonChartInstance(instance);
    }

    @ResponseBody
    @RequestMapping(value={"/update/{id}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String updateChartDefinition(@RequestBody @Valid ChartDefinition definition, @PathVariable(value="id") long id) {
        this.chartService.updateDefinition(definition, Long.valueOf(id));
        return String.valueOf(id);
    }

    @ResponseBody
    @RequestMapping(value={"/new/{id}"}, method={RequestMethod.POST}, consumes={"application/json"})
    public String createNewChartDefinition(@RequestBody @Valid ChartDefinition definition, @PathVariable(value="id") long id) {
        definition.setOwner(this.userService.findCurrentUser());
        CustomReportLibraryNode node = this.reportNodeService.createNewNode(Long.valueOf(id), (CustomReportTreeEntity)definition);
        return node.getId().toString();
    }
}

