/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.MultiSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.campaign.TestSuiteModificationService;
import org.squashtest.tm.service.campaign.TestSuiteTestPlanManagerService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.campaign.TestPlanTableModelHelper;
import org.squashtest.tm.web.internal.controller.campaign.TestSuiteModificationController;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JeditableComboHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableMultiSorting;
import org.squashtest.tm.web.internal.model.jquery.TestPlanAssignableUser;
import org.squashtest.tm.web.internal.model.json.JsonIterationTestPlanItem;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class TestSuiteTestPlanManagerController {
    private static final String UNBOUND_SUITE_IDS = "unboundSuiteIds[]";
    private static final String BOUND_SUITE_IDS = "boundSuiteIds[]";
    private static final String BIND_TEST_PLAN_ITEMS_TO_TEST_SUITES = "bind test plan items to test suites";
    private static final String TESTCASES_IDS_REQUEST_PARAM = "testCasesIds[]";
    private static final String TEST_SUITE = "testSuite";
    private static final String TEST_SUITE_ID = "suiteId";
    private static final String NAME = "name";
    private static final String REFERENCE = "reference";
    private static final String IMPORTANCE = "importance";
    private static final String ITEM_IDS = "itemIds[]";
    private static final String STATUS = "status";
    private static final String ITEM_ID = "itemId";
    private static final String TESTPLAN_IDS = "testPlanIds";
    private static final String TEST_PLAN_IDS_URL_MAPPING = "/test-suites/{suiteId}/test-plan/{testPlanIds}";
    @Inject
    private TestSuiteModificationService service;
    @Inject
    private TestSuiteTestPlanManagerService testSuiteTestPlanManagerService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private IterationFinder iterationFinder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    private UserAccountService userAccountService;
    @Inject
    private MilestoneModelService milestoneModelService;
    @Inject
    private PermissionEvaluationService permSerice;
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuiteModificationController.class);
    private final DatatableMapper<String> testPlanMapper = new NameBasedMapper().map("entity-index", "index(IterationTestPlanItem)").mapAttribute("project-name", "name", Project.class).mapAttribute("reference", "reference", TestCase.class).mapAttribute("tc-name", "name", TestCase.class).mapAttribute("importance", "importance", TestCase.class).mapAttribute("dataset.selected.name", "name", Dataset.class).mapAttribute("status", "executionStatus", IterationTestPlanItem.class).mapAttribute("assignee-login", "login", User.class).mapAttribute("last-exec-on", "lastExecutedOn", IterationTestPlanItem.class).mapAttribute("exec-mode", "automatedTest", TestCase.class).map("milestone-dates", "endDate");
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;

    @RequestMapping(value={"/test-suites/{suiteId}/test-plan-manager"}, method={RequestMethod.GET})
    public ModelAndView showManager(@PathVariable(value="suiteId") long suiteId, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("show test suite test plan manager for test suite #{}", (Object)suiteId);
        }
        TestSuite testSuite = this.testSuiteTestPlanManagerService.findTestSuite(suiteId);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testSuite);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.iterationTestPlanManagerService.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.testCaseWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-test-suite-test-plan-manager");
        mav.addObject(TEST_SUITE, (Object)testSuite);
        mav.addObject("baseURL", (Object)("/test-suites/" + suiteId));
        mav.addObject("linkableLibrariesModel", (Object)linkableLibrariesModel);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan"}, params={"sEcho"})
    public DataTableModel getTestPlanModel(@PathVariable(value="suiteId") long suiteId, DataTableDrawParameters params, Locale locale) {
        DataTableMultiSorting paging = new DataTableMultiSorting(params, this.testPlanMapper);
        DataTableColumnFiltering filter = new DataTableColumnFiltering(params);
        PagedCollectionHolder holder = this.testSuiteTestPlanManagerService.findAssignedTestPlan(suiteId, (PagingAndMultiSorting)paging, (ColumnFiltering)filter);
        return new TestPlanTableModelHelper(this.messageSource, locale, this.permSerice).buildDataModel(holder, params.getsEcho());
    }

    @RequestMapping(value={"/test-suites/{suiteId}/assignable-users"}, method={RequestMethod.GET})
    @ResponseBody
    public List<TestPlanAssignableUser> getAssignUserForTestSuite(@PathVariable(value="suiteId") long suiteId, Locale locale) {
        TestSuite testSuite = (TestSuite)this.service.findById(suiteId);
        List usersList = this.iterationTestPlanManagerService.findAssignableUserForTestPlan(testSuite.getIteration().getId().longValue());
        String unassignedLabel = this.formatUnassigned(locale);
        LinkedList<TestPlanAssignableUser> jsonUsers = new LinkedList<TestPlanAssignableUser>();
        jsonUsers.add(new TestPlanAssignableUser(User.NO_USER_ID.toString(), unassignedLabel));
        for (User user : usersList) {
            jsonUsers.add(new TestPlanAssignableUser(user));
        }
        return jsonUsers;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"assignee"})
    public long assignUserToCampaignTestPlanItem(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @PathVariable(value="suiteId") long suiteId, @RequestParam(value="assignee") long assignee) {
        this.iterationTestPlanManagerService.assignUserToTestPlanItems(testPlanIds, assignee);
        return assignee;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanId}"}, method={RequestMethod.POST}, params={"dataset"})
    public Long setDataset(@PathVariable(value="testPlanId") long testPlanId, @RequestParam(value="dataset") Long datasetId) {
        this.iterationTestPlanManagerService.changeDataset(testPlanId, JeditableComboHelper.coerceIntoEntityId(datasetId));
        return datasetId;
    }

    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanIds}/position/{newIndex}"}, method={RequestMethod.POST})
    @ResponseBody
    public void changeTestPlanIndex(@PathVariable(value="suiteId") long suiteId, @PathVariable(value="newIndex") int newIndex, @PathVariable(value="testPlanIds") List<Long> itemIds) {
        this.testSuiteTestPlanManagerService.changeTestPlanPosition(suiteId, newIndex, itemIds);
    }

    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/order"}, method={RequestMethod.POST})
    @ResponseBody
    public void reorderTestPlan(@PathVariable(value="suiteId") long suiteId, DataTableDrawParameters parameters) {
        DataTableMultiSorting sorting = new DataTableMultiSorting(parameters, this.testPlanMapper);
        this.testSuiteTestPlanManagerService.reorderTestPlan(suiteId, (MultiSorting)sorting);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan"}, method={RequestMethod.POST}, params={"testCasesIds[]"})
    public void addTestCasesToIteration(@RequestParam(value="testCasesIds[]") List<Long> testCasesIds, @PathVariable(value="suiteId") long suiteId) {
        this.testSuiteTestPlanManagerService.addTestCasesToIterationAndTestSuite(testCasesIds, suiteId);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanIds}"}, method={RequestMethod.DELETE})
    public Boolean removeTestCaseFromTestSuiteAndIteration(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @PathVariable(value="suiteId") long suiteId) {
        return this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuiteAndRemoveFromIteration(testPlanIds, suiteId);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanIds}"}, method={RequestMethod.DELETE}, params={"detach=true"})
    public Boolean detachTestCaseFromTestSuite(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @PathVariable(value="suiteId") long suiteId) {
        this.testSuiteTestPlanManagerService.detachTestPlanFromTestSuite(testPlanIds, suiteId);
        return Boolean.FALSE;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteIds}/test-plan"}, method={RequestMethod.POST}, params={"itemIds[]"})
    public Map<String, List<Long>> bindTestPlan(@RequestParam(value="itemIds[]") List<Long> itpIds, @PathVariable(value="suiteIds") List<Long> suitesIds) {
        LOGGER.debug(BIND_TEST_PLAN_ITEMS_TO_TEST_SUITES);
        this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(suitesIds, itpIds);
        HashMap<String, List<Long>> result = new HashMap<String, List<Long>>();
        result.put("ids", suitesIds);
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/test-plan"}, method={RequestMethod.POST}, params={"itemIds[]", "boundSuiteIds[]", "unboundSuiteIds[]"})
    public void changeboundTestPlan(@RequestParam(value="itemIds[]") List<Long> itpIds, @RequestParam(value="boundSuiteIds[]") List<Long> boundTestSuitesIds, @RequestParam(value="unboundSuiteIds[]") List<Long> unboundTestSuiteIds) {
        LOGGER.debug(BIND_TEST_PLAN_ITEMS_TO_TEST_SUITES);
        this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(boundTestSuitesIds, itpIds);
        this.testSuiteTestPlanManagerService.unbindTestPlanToMultipleSuites(unboundTestSuiteIds, itpIds);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/test-plan"}, method={RequestMethod.POST}, params={"itemIds[]", "unboundSuiteIds[]"})
    public void unbindTestPlans(@RequestParam(value="itemIds[]") List<Long> itpIds, @RequestParam(value="unboundSuiteIds[]") List<Long> unboundTestSuiteIds) {
        LOGGER.debug(BIND_TEST_PLAN_ITEMS_TO_TEST_SUITES);
        this.testSuiteTestPlanManagerService.unbindTestPlanToMultipleSuites(unboundTestSuiteIds, itpIds);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/test-plan"}, method={RequestMethod.POST}, params={"itemIds[]", "boundSuiteIds[]"})
    public void bindTestPlans(@RequestParam(value="itemIds[]") List<Long> itpIds, @RequestParam(value="boundSuiteIds[]") List<Long> boundTestSuitesIds) {
        LOGGER.debug(BIND_TEST_PLAN_ITEMS_TO_TEST_SUITES);
        this.testSuiteTestPlanManagerService.bindTestPlanToMultipleSuites(boundTestSuitesIds, itpIds);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"status"})
    public JsonIterationTestPlanItem setTestPlanItemStatus(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @RequestParam(value="status") String status) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("change status test plan items to {}", (Object)status);
        }
        List itpis = this.iterationTestPlanManagerService.forceExecutionStatus(testPlanIds, status);
        return this.createJsonITPI((IterationTestPlanItem)itpis.get(0));
    }

    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{itemId}/executions"}, method={RequestMethod.GET})
    public ModelAndView getExecutionsForTestPlan(@PathVariable(value="suiteId") long suiteId, @PathVariable(value="itemId") long itemId) {
        LOGGER.debug("find model and view for executions of test plan item  #{}", (Object)itemId);
        TestSuite testSuite = (TestSuite)this.service.findById(suiteId);
        Long iterationId = testSuite.getIteration().getId();
        List executionList = this.iterationFinder.findExecutionsByTestPlan(iterationId.longValue(), itemId);
        IterationTestPlanItem iterationTestPlanItem = this.iterationTestPlanManagerService.findTestPlanItem(itemId);
        ModelAndView mav = new ModelAndView("fragment/test-suites/test-suite-test-plan-row");
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testSuite);
        mav.addObject("testPlanItem", (Object)iterationTestPlanItem);
        mav.addObject("iterationId", (Object)iterationId);
        mav.addObject("executions", (Object)executionList);
        mav.addObject(TEST_SUITE, (Object)testSuite);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteId}/test-plan/{itemId}/executions/new"}, method={RequestMethod.POST}, params={"mode=manual"})
    public String addManualExecution(@PathVariable(value="suiteId") long suiteId, @PathVariable(value="itemId") long itemId) {
        LOGGER.debug("add manual execution to item #{}", (Object)itemId);
        Execution newExecution = this.service.addExecution(itemId, (MessageSource)this.messageSource);
        return newExecution.getId().toString();
    }

    @RequestMapping(value={"/test-suites/{tsId}/test-plan/{testPlanId}/last-execution"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String goToLastExecution(@PathVariable(value="testPlanId") Long testPlanId) {
        IterationTestPlanItem item = this.iterationTestPlanManagerService.findTestPlanItem(testPlanId.longValue());
        Execution exec = item.getLatestExecution();
        return "redirect:/executions/" + exec.getId();
    }

    private String formatUnassigned(Locale locale) {
        return this.messageSource.internationalize("label.Unassigned", locale);
    }

    private JsonIterationTestPlanItem createJsonITPI(IterationTestPlanItem item) {
        String name = item.isTestCaseDeleted() ? null : item.getReferencedTestCase().getName();
        return new JsonIterationTestPlanItem((long)item.getId(), item.getExecutionStatus(), HtmlUtils.htmlEscape((String)name), item.getLastExecutedOn(), HtmlUtils.htmlEscape((String)item.getLastExecutedBy()), item.getUser(), item.isTestCaseDeleted(), item.isAutomated());
    }
}

