/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IterationTestPlanFinder;
import org.squashtest.tm.service.campaign.TestSuiteModificationService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.internal.repository.TestSuiteDao;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseImportanceJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseModeJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.executions.ExecutionStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/test-suites/{suiteId}"})
public class TestSuiteModificationController {
    private static final String TEST_SUITE = "testSuite";
    private static final Logger LOGGER = LoggerFactory.getLogger(TestSuiteModificationController.class);
    private static final String NAME = "name";
    private static final String SUITE_ID = "suiteId";
    @Inject
    private TestSuiteModificationService service;
    @Inject
    private TestSuiteDao testSuiteDao;
    @Inject
    private IterationTestPlanFinder iterationTestPlanFinder;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private Provider<TestCaseImportanceJeditableComboDataBuilder> importanceComboBuilderProvider;
    @Inject
    private Provider<TestCaseModeJeditableComboDataBuilder> modeComboBuilderProvider;
    @Inject
    private Provider<ExecutionStatusJeditableComboDataBuilder> executionStatusComboBuilderProvider;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;

    @RequestMapping(method={RequestMethod.GET})
    public String showTestSuite(Model model, @PathVariable(value="suiteId") long suiteId) {
        this.populateTestSuiteModel(model, suiteId);
        return "fragment/test-suites/test-suite";
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String showTestSuiteInfo(Model model, @PathVariable(value="suiteId") long suiteId) {
        this.populateTestSuiteModel(model, suiteId);
        return "page/campaign-workspace/show-test-suite";
    }

    private void populateTestSuiteModel(Model model, long testSuiteId) {
        TestSuite testSuite = (TestSuite)this.service.findById(testSuiteId);
        TestPlanStatistics testSuiteStats = this.service.findTestSuiteStatistics(testSuiteId);
        boolean hasCUF = this.cufValueService.hasCustomFields((BoundEntity)testSuite);
        DataTableModel attachmentsModel = this.attachmentsHelper.findPagedAttachments((AttachmentHolder)testSuite);
        Map<String, String> assignableUsers = this.getAssignableUsers(testSuiteId);
        Map<String, String> weights = this.getWeights();
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(testSuite);
        model.addAttribute(TEST_SUITE, (Object)testSuite);
        model.addAttribute("statistics", (Object)testSuiteStats);
        model.addAttribute("hasCUF", (Object)hasCUF);
        model.addAttribute("attachmentsModel", (Object)attachmentsModel);
        model.addAttribute("assignableUsers", assignableUsers);
        model.addAttribute("allowsSettled", (Object)testSuite.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addAttribute("allowsUntestable", (Object)testSuite.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
        model.addAttribute("weights", weights);
        model.addAttribute("modes", this.getModes());
        model.addAttribute("statuses", this.getStatuses(testSuite.getProject().getId()));
        model.addAttribute("milestoneConf", (Object)milestoneConf);
    }

    private Map<String, String> getStatuses(long projectId) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((ExecutionStatusJeditableComboDataBuilder)((ExecutionStatusJeditableComboDataBuilder)this.executionStatusComboBuilderProvider.get()).useContext(projectId).useLocale(locale)).buildMap();
    }

    private Map<String, String> getModes() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseModeJeditableComboDataBuilder)((TestCaseModeJeditableComboDataBuilder)this.modeComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private Map<String, String> getWeights() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseImportanceJeditableComboDataBuilder)((TestCaseImportanceJeditableComboDataBuilder)this.importanceComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private Map<String, String> getAssignableUsers(long testSuiteId) {
        Locale locale = LocaleContextHolder.getLocale();
        TestSuite ts = (TestSuite)this.service.findById(testSuiteId);
        List usersList = this.iterationTestPlanFinder.findAssignableUserForTestPlan(ts.getIteration().getId().longValue());
        Collections.sort(usersList, new UserLoginComparator());
        String unassignedLabel = this.messageSource.internationalize("label.Unassigned", locale);
        LinkedHashMap<String, String> jsonUsers = new LinkedHashMap<String, String>(usersList.size());
        jsonUsers.put(User.NO_USER_ID.toString(), unassignedLabel);
        for (User user : usersList) {
            String identity = String.valueOf(user.getFirstName()) + " " + user.getLastName() + " (" + user.getLogin() + ")";
            jsonUsers.put(user.getId().toString(), HtmlUtils.htmlEscape((String)identity));
        }
        return jsonUsers;
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable(value="suiteId") long suiteId) {
        TestSuite testSuite = (TestSuite)this.service.findById(suiteId);
        return new JsonGeneralInfo((AuditableMixin)testSuite);
    }

    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public ModelAndView refreshStats(@PathVariable(value="suiteId") long suiteId) {
        TestPlanStatistics testSuiteStats = this.service.findTestSuiteStatistics(suiteId);
        TestSuite testSuite = (TestSuite)this.service.findById(suiteId);
        ModelAndView mav = new ModelAndView("fragment/generics/statistics-fragment");
        mav.addObject("statisticsEntity", (Object)testSuiteStats);
        mav.addObject("allowsSettled", (Object)testSuite.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        mav.addObject("allowsUntestable", (Object)testSuite.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
        return mav;
    }

    @RequestMapping(value={"/exec-button"}, method={RequestMethod.GET})
    public ModelAndView refreshExecButton(@PathVariable(value="suiteId") long suiteId) {
        TestPlanStatistics testSuiteStats = this.service.findTestSuiteStatistics(suiteId);
        ModelAndView mav = new ModelAndView("fragment/test-suites/test-suite-execution-button");
        mav.addObject("testSuiteId", (Object)suiteId);
        mav.addObject("statisticsEntity", (Object)testSuiteStats);
        return mav;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-suite-description", "value"})
    @ResponseBody
    public String updateDescription(@RequestParam(value="value") String newDescription, @PathVariable(value="suiteId") long suiteId) {
        this.service.changeDescription(suiteId, newDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Test-suite " + suiteId + ": updated description to " + newDescription);
        }
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=test-suite-execution-status", "value"})
    @ResponseBody
    public void updateExecutionStatus(@RequestParam(value="value") String value, @PathVariable long suiteId) {
        ExecutionStatus executionStatus = ExecutionStatus.valueOf((String)value);
        this.service.changeExecutionStatus(suiteId, executionStatus);
        LOGGER.trace("Test-suite " + suiteId + ": updated status to " + value);
    }

    @RequestMapping(value={"/getExecutionStatus"}, method={RequestMethod.GET})
    @ResponseBody
    public String getExecutionStatus(@PathVariable long suiteId) {
        return ((TestSuite)this.testSuiteDao.getOne((Object)suiteId)).getExecutionStatus().toString();
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object rename(@RequestParam(value="newName") String newName, @PathVariable(value="suiteId") long suiteId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("TestSuiteModificationController : renaming " + suiteId + " as " + newName);
        }
        this.service.rename(suiteId, newName);
        return new RenameModel(HTMLCleanupUtils.cleanAndUnescapeHTML(newName));
    }

    @ResponseBody
    @RequestMapping(value={"/rename"}, method={RequestMethod.POST}, params={"name"})
    public Map<String, String> renameTestSuite(@PathVariable(value="suiteId") Long suiteId, @RequestParam(value="name") String name) {
        this.service.rename(suiteId.longValue(), name);
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("id", suiteId.toString());
        result.put(NAME, HtmlUtils.htmlEscape((String)name));
        return result;
    }

    private static final class UserLoginComparator
    implements Comparator<User> {
        private UserLoginComparator() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getLogin().compareTo(u2.getLogin());
        }
    }
}

