/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.squashtest.tm.domain.campaign.TestSuite;

public final class TestSuiteHelper {
    private TestSuiteHelper() {
    }

    public static String buildSuiteNameList(List<TestSuite> unsortedSuites) {
        return TestSuiteHelper.buildNameList(unsortedSuites).toString();
    }

    public static String buildEllipsedSuiteNameList(List<TestSuite> unsortedSuites, int maxLength) {
        StringBuilder testSuiteNames = TestSuiteHelper.buildNameList(unsortedSuites);
        return TestSuiteHelper.ellipseString(testSuiteNames, maxLength);
    }

    private static StringBuilder buildNameList(List<TestSuite> unsortedSuites) {
        ArrayList<TestSuite> sortedSuites = new ArrayList<TestSuite>(unsortedSuites);
        Collections.sort(sortedSuites, new Comparator<TestSuite>(){

            @Override
            public int compare(TestSuite o1, TestSuite o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        if (sortedSuites.isEmpty()) {
            return new StringBuilder("");
        }
        StringBuilder testSuiteNames = new StringBuilder();
        if (!sortedSuites.isEmpty()) {
            int i = 0;
            while (i < sortedSuites.size() - 1) {
                testSuiteNames.append(((TestSuite)sortedSuites.get(i)).getName()).append(", ");
                ++i;
            }
            testSuiteNames.append(((TestSuite)sortedSuites.get(i)).getName());
        }
        return testSuiteNames;
    }

    private static String ellipseString(StringBuilder builder, int maxLength) {
        String res = builder.length() > maxLength ? String.valueOf(builder.substring(0, maxLength - 4)) + "..." : builder.toString();
        return res;
    }
}

