/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Abbreviated;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.IdentifiedUtil;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IndexedIterationTestPlanItem;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.campaign.TestSuiteHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JeditableComboHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.json.JsonDataset;

class TestPlanTableModelHelper
extends DataTableModelBuilder<IndexedIterationTestPlanItem> {
    private InternationalizationHelper messageSource;
    private Locale locale;
    private PermissionEvaluationService permService;
    private static final String NONE = "";

    TestPlanTableModelHelper(InternationalizationHelper messageSource, Locale locale, PermissionEvaluationService permService) {
        this.messageSource = messageSource;
        this.locale = locale;
        this.permService = permService;
    }

    public Map<String, Object> buildItemData(IndexedIterationTestPlanItem indexedItem) {
        List testSuiteIdsList;
        String testSuiteNameListTot;
        String testSuiteNameList;
        String reference;
        String importance;
        Long tcId;
        String testCaseName;
        String projectName;
        Integer index = indexedItem.getIndex() + 1;
        IterationTestPlanItem item = indexedItem.getItem();
        HashMap<String, Object> res = new HashMap<String, Object>();
        String automationMode = item.isAutomated() ? "A" : "M";
        String assigneeLogin = this.formatString(null, this.locale);
        Long assigneeId = User.NO_USER_ID;
        User assignee = item.getUser();
        if (assignee != null) {
            assigneeId = assignee.getId();
            assigneeLogin = String.valueOf(assignee.getFirstName()) + " " + assignee.getLastName() + " (" + assignee.getLogin() + ")";
        }
        String milestoneDates = "-";
        String milestoneLabels = "-";
        if (item.isTestCaseDeleted()) {
            projectName = NONE;
            testCaseName = this.formatDeleted(this.locale);
            tcId = null;
            importance = this.formatNoData(this.locale);
            reference = NONE;
        } else {
            projectName = item.getReferencedTestCase().getProject().getName();
            testCaseName = item.getReferencedTestCase().getName();
            tcId = item.getReferencedTestCase().getId();
            reference = item.getReferencedTestCase().getReference().isEmpty() ? this.formatNoData(this.locale) : item.getReferencedTestCase().getReference();
            importance = this.messageSource.internationalizeAbbreviation((Abbreviated)item.getReferencedTestCase().getImportance(), this.locale);
            milestoneDates = MilestoneModelUtils.timeIntervalToString(item.getReferencedTestCase().getMilestones(), this.messageSource, this.locale);
            milestoneLabels = MilestoneModelUtils.milestoneLabelsOrderByDate(item.getReferencedTestCase().getMilestones());
        }
        DatasetInfos dsIndos = this.makeDatasetInfo(item);
        if (item.getTestSuites().isEmpty()) {
            testSuiteNameList = this.formatNoData(this.locale);
            testSuiteNameListTot = this.formatNoData(this.locale);
            testSuiteIdsList = Collections.emptyList();
        } else {
            testSuiteNameList = TestSuiteHelper.buildEllipsedSuiteNameList(item.getTestSuites(), 20);
            testSuiteNameListTot = TestSuiteHelper.buildSuiteNameList(item.getTestSuites());
            testSuiteIdsList = IdentifiedUtil.extractIds((Collection)item.getTestSuites());
        }
        int succesPercent = 0;
        Execution lastExec = item.getLatestExecution();
        if (lastExec != null) {
            if (lastExec.isAutomated()) {
                succesPercent = lastExec.getExecutionStatus() == ExecutionStatus.SUCCESS ? 100 : 0;
            } else {
                List steps = item.getLatestExecution().getSteps();
                int succes = this.countSucces(steps);
                int totalSteps = steps.size();
                succesPercent = totalSteps > 0 ? succes * 100 / totalSteps : 0;
            }
        }
        res.put("entity-id", item.getId());
        res.put("entity-index", index);
        res.put("project-name", HtmlUtils.htmlEscape((String)projectName));
        res.put("reference", HtmlUtils.htmlEscape((String)reference));
        res.put("tc-id", tcId);
        res.put("tc-name", HtmlUtils.htmlEscape((String)testCaseName));
        res.put("importance", importance);
        res.put("suite", HtmlUtils.htmlEscape((String)testSuiteNameList));
        res.put("suitesTot", HtmlUtils.htmlEscape((String)testSuiteNameListTot));
        res.put("suiteIds", testSuiteIdsList);
        res.put("status", item.getExecutionStatus().getCanonicalStatus());
        res.put("assignee-id", assigneeId);
        res.put("assignee-login", HtmlUtils.htmlEscape((String)assigneeLogin));
        res.put("last-exec-on", DateUtils.formatIso8601DateTime((Date)item.getLastExecutedOn()));
        res.put("exec-exists", lastExec != null);
        res.put("is-tc-deleted", item.isTestCaseDeleted());
        res.put("succesPercent", String.valueOf(succesPercent) + " %");
        res.put("empty-execute-holder", " ");
        res.put("empty-delete-holder", " ");
        res.put("exec-mode", automationMode);
        res.put("milestone-dates", milestoneDates);
        res.put("dataset", dsIndos);
        res.put("milestone-labels", HtmlUtils.htmlEscape((String)milestoneLabels));
        res.put("readable", this.permService.canRead((Object)item.getReferencedTestCase()));
        return res;
    }

    private int countSucces(List<ExecutionStep> steps) {
        int succes = 0;
        for (ExecutionStep step : steps) {
            if (step.getExecutionStatus() != ExecutionStatus.SUCCESS) continue;
            ++succes;
        }
        return succes;
    }

    private DatasetInfos makeDatasetInfo(IterationTestPlanItem item) {
        if (item.isTestCaseDeleted() || item.getReferencedTestCase().getDatasets().isEmpty()) {
            return DatasetInfos.EMPTY_INFOS;
        }
        Dataset selected = item.getReferencedDataset();
        Set available = item.getReferencedTestCase().getDatasets();
        JsonDataset jsonSelected = this.convert(selected);
        ArrayList<JsonDataset> jsonAvailable = new ArrayList<JsonDataset>(available.size() + 1);
        jsonAvailable.add(this.convert(null));
        for (Dataset ds : available) {
            jsonAvailable.add(this.convert(ds));
        }
        return new DatasetInfos(jsonSelected, jsonAvailable);
    }

    private JsonDataset convert(Dataset ds) {
        JsonDataset jsds = new JsonDataset();
        if (ds == null) {
            jsds.setName(this.messageSource.internationalize("label.noneDSEscaped", this.locale));
            jsds.setId(JeditableComboHelper.coerceIntoComboId(null));
        } else {
            jsds.setName(HtmlUtils.htmlEscape((String)ds.getName()));
            jsds.setId(JeditableComboHelper.coerceIntoComboId(ds.getId()));
        }
        return jsds;
    }

    private String formatString(String arg, Locale locale) {
        return this.messageSource.messageOrNoData(arg, locale);
    }

    private String formatNoData(Locale locale) {
        return this.messageSource.noData(locale);
    }

    private String formatDeleted(Locale locale) {
        return this.messageSource.itemDeleted(locale);
    }

    public static final class DatasetInfos {
        public static final DatasetInfos EMPTY_INFOS;
        private JsonDataset selected;
        private Collection<JsonDataset> available;

        static {
            JsonDataset emptyDs = new JsonDataset();
            emptyDs.setId(JeditableComboHelper.coerceIntoComboId(null));
            emptyDs.setName("-");
            EMPTY_INFOS = new DatasetInfos(emptyDs, Collections.emptyList());
        }

        DatasetInfos(JsonDataset selected, Collection<JsonDataset> available) {
            this.selected = selected;
            this.available = available;
        }

        public JsonDataset getSelected() {
            return this.selected;
        }

        public Collection<JsonDataset> getAvailable() {
            return this.available;
        }
    }
}

