/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.MultiSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.milestone.MilestoneModelService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.campaign.TestPlanTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JeditableComboHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableMultiSorting;
import org.squashtest.tm.web.internal.model.jquery.TestPlanAssignableUser;
import org.squashtest.tm.web.internal.model.json.JsonIterationTestPlanItem;
import org.squashtest.tm.web.internal.model.json.JsonTestCase;
import org.squashtest.tm.web.internal.model.json.JsonTestCaseBuilder;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class IterationTestPlanManagerController {
    private static final String TESTCASES_IDS_REQUEST_PARAM = "testCasesIds[]";
    private static final String ITPI_IDS_REQUEST_PARAM = "itpiIds[]";
    private static final String STATUS = "status";
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;
    @Inject
    private IterationFinder iterationFinder;
    @Inject
    private Provider<JsonTestCaseBuilder> jsonTestCaseBuilder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    protected UserAccountService userAccountService;
    @Inject
    protected MilestoneModelService milestoneModelService;
    @Inject
    private PermissionEvaluationService permService;
    private final DatatableMapper<String> testPlanMapper = new NameBasedMapper().map("entity-index", "index(IterationTestPlanItem)").mapAttribute("project-name", "name", Project.class).mapAttribute("reference", "reference", TestCase.class).mapAttribute("tc-name", "name", TestCase.class).mapAttribute("importance", "importance", TestCase.class).mapAttribute("dataset.selected.name", "name", Dataset.class).mapAttribute("status", "executionStatus", IterationTestPlanItem.class).mapAttribute("assignee-login", "login", User.class).mapAttribute("last-exec-on", "lastExecutedOn", IterationTestPlanItem.class).mapAttribute("exec-mode", "automatedTest", TestCase.class).map("suite", "suitenames").map("milestone-dates", "endDate");

    @RequestMapping(value={"/iterations/{iterationId}/test-plan-manager"}, method={RequestMethod.GET})
    public ModelAndView showManager(@PathVariable long iterationId, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        Iteration iteration = (Iteration)this.iterationFinder.findById(iterationId);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(iteration);
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-iteration-test-plan-manager");
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.iterationTestPlanManagerService.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.testCaseWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        mav.addObject("iteration", (Object)iteration);
        mav.addObject("baseURL", (Object)("/iterations/" + iterationId));
        mav.addObject("linkableLibrariesModel", (Object)linkableLibrariesModel);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan"}, params={"sEcho"})
    public DataTableModel getTestPlanModel(@PathVariable long iterationId, DataTableDrawParameters params, Locale locale) {
        DataTableMultiSorting paging = new DataTableMultiSorting(params, this.testPlanMapper);
        DataTableColumnFiltering filter = new DataTableColumnFiltering(params);
        PagedCollectionHolder holder = this.iterationTestPlanManagerService.findAssignedTestPlan(iterationId, (PagingAndMultiSorting)paging, (ColumnFiltering)filter);
        return new TestPlanTableModelHelper(this.messageSource, locale, this.permService).buildDataModel(holder, params.getsEcho());
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan"}, method={RequestMethod.POST}, params={"itpiIds[]"})
    public void addIterationTestPlanItemToIteration(@RequestParam(value="itpiIds[]") List<Long> iterationTestPlanIds, @PathVariable long iterationId) {
        this.iterationTestPlanManagerService.copyTestPlanItems(iterationTestPlanIds, iterationId);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan"}, method={RequestMethod.POST}, params={"testCasesIds[]"})
    public void addTestCasesToIteration(@RequestParam(value="testCasesIds[]") List<Long> testCasesIds, @PathVariable long iterationId) {
        this.iterationTestPlanManagerService.addTestCasesToIteration(testCasesIds, iterationId);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-cases"}, method={RequestMethod.GET}, headers={"Accept=application/json, text/javascript"})
    public List<JsonTestCase> getJsonTestCases(@PathVariable long iterationId, Locale locale) {
        List testCases = this.iterationFinder.findPlannedTestCases(iterationId);
        return ((JsonTestCaseBuilder)this.jsonTestCaseBuilder.get()).locale(locale).entities(testCases).toJson();
    }

    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{itemIds}/position/{newIndex}"}, method={RequestMethod.POST})
    @ResponseBody
    public void moveTestPlanItems(@PathVariable(value="iterationId") long iterationId, @PathVariable(value="newIndex") int newIndex, @PathVariable(value="itemIds") List<Long> itemIds) {
        this.iterationTestPlanManagerService.changeTestPlanPosition(iterationId, newIndex, itemIds);
    }

    @RequestMapping(value={"/iterations/{iterationId}/test-plan/order"}, method={RequestMethod.POST})
    @ResponseBody
    public void reorderTestPlan(@PathVariable(value="iterationId") long iterationId, DataTableDrawParameters parameters) {
        DataTableMultiSorting sorting = new DataTableMultiSorting(parameters, this.testPlanMapper);
        this.iterationTestPlanManagerService.reorderTestPlan(iterationId, (MultiSorting)sorting);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{testPlanItemsIds}"}, method={RequestMethod.DELETE})
    public Boolean removeTestPlanItemsFromIteration(@PathVariable(value="testPlanItemsIds") List<Long> testPlanItemsIds, @PathVariable long iterationId) {
        return this.iterationTestPlanManagerService.removeTestPlansFromIteration(testPlanItemsIds, iterationId);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/assignable-users"}, method={RequestMethod.GET})
    public List<TestPlanAssignableUser> getAssignUserForIterationTestPlanItem(@PathVariable long iterationId, Locale locale) {
        List usersList = this.iterationTestPlanManagerService.findAssignableUserForTestPlan(iterationId);
        String unassignedLabel = this.formatUnassigned(locale);
        LinkedList<TestPlanAssignableUser> jsonUsers = new LinkedList<TestPlanAssignableUser>();
        jsonUsers.add(new TestPlanAssignableUser(User.NO_USER_ID.toString(), unassignedLabel));
        for (User user : usersList) {
            jsonUsers.add(new TestPlanAssignableUser(user));
        }
        return jsonUsers;
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"assignee"})
    public Long assignUserToIterationTestPlanItem(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @RequestParam(value="assignee") long assignee) {
        this.iterationTestPlanManagerService.assignUserToTestPlanItems(testPlanIds, assignee);
        return assignee;
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"status"})
    public JsonIterationTestPlanItem editStatusOfIterationTestPlanItems(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @RequestParam(value="status") String status) {
        List itpis = this.iterationTestPlanManagerService.forceExecutionStatus(testPlanIds, status);
        return this.createJsonITPI((IterationTestPlanItem)itpis.get(0));
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"status"})
    public void editIterationTestPlanItemsStatus(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @RequestParam(value="status") String status) {
        this.iterationTestPlanManagerService.forceExecutionStatus(testPlanIds, status);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{testPlanId}"}, method={RequestMethod.POST}, params={"dataset"})
    public Long setDataset(@PathVariable(value="testPlanId") long testPlanId, @RequestParam(value="dataset") Long datasetId) {
        this.iterationTestPlanManagerService.changeDataset(testPlanId, JeditableComboHelper.coerceIntoEntityId(datasetId));
        return datasetId;
    }

    @RequestMapping(value={"/iterations/{iterationId}/test-plan/{testPlanId}/last-execution"}, method={RequestMethod.GET})
    @ResponseStatus(value=HttpStatus.MOVED_PERMANENTLY)
    public String goToLastExecution(@PathVariable(value="testPlanId") Long testPlanId) {
        IterationTestPlanItem item = this.iterationTestPlanManagerService.findTestPlanItem(testPlanId.longValue());
        Execution exec = item.getLatestExecution();
        return "redirect:/executions/" + exec.getId();
    }

    private String formatUnassigned(Locale locale) {
        return this.messageSource.internationalize("label.Unassigned", locale);
    }

    private JsonIterationTestPlanItem createJsonITPI(IterationTestPlanItem item) {
        String name = item.isTestCaseDeleted() ? null : item.getReferencedTestCase().getName();
        return new JsonIterationTestPlanItem((long)item.getId(), item.getExecutionStatus(), name, item.getLastExecutedOn(), item.getLastExecutedBy(), item.getUser(), item.isTestCaseDeleted(), item.isAutomated());
    }
}

