/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.IterationStatus;
import org.squashtest.tm.domain.campaign.IterationTestPlanItem;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.campaign.IterationTestPlanFinder;
import org.squashtest.tm.service.campaign.IterationTestPlanManagerService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.statistics.iteration.IterationStatisticsBundle;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.internal.controller.campaign.IterationStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseImportanceJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseModeJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.executions.ExecutionStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.jquery.TestSuiteModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/iterations/{iterationId}"})
public class IterationModificationController {
    private static final String NAME = "name";
    private static final Logger LOGGER = LoggerFactory.getLogger(IterationModificationController.class);
    private static final String ITERATION_KEY = "iteration";
    private static final String ITERATION_ID_KEY = "iterationId";
    private static final String PLANNING_URL = "/planning";
    @Inject
    private IterationModificationService iterationModService;
    @Inject
    private IterationTestPlanManagerService iterationTestPlanManagerService;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private IterationTestPlanFinder testPlanFinder;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private Provider<TestCaseImportanceJeditableComboDataBuilder> importanceComboBuilderProvider;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private Provider<TestCaseModeJeditableComboDataBuilder> modeComboBuilderProvider;
    @Inject
    private Provider<ExecutionStatusJeditableComboDataBuilder> executionStatusComboBuilderProvider;
    @Inject
    private Provider<LevelLabelFormatter> levelLabelFormatterProvider;
    @Inject
    private Provider<IterationStatusJeditableComboDataBuilder> statusComboBuilderProvider;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private CustomReportDashboardService customReportDashboardService;
    @Inject
    private PartyPreferenceService partyPreferenceService;

    @RequestMapping(method={RequestMethod.GET})
    public String showIteration(Model model, @PathVariable long iterationId) {
        this.populateIterationModel(model, iterationId);
        return "fragment/iterations/iteration";
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String showIterationInfo(Model model, @PathVariable long iterationId) {
        this.populateIterationModel(model, iterationId);
        return "page/campaign-workspace/show-iteration";
    }

    private void populateIterationModel(Model model, long iterationId) {
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        boolean hasCUF = this.cufValueService.hasCustomFields((BoundEntity)iteration);
        DataTableModel attachmentsModel = this.attachmentHelper.findPagedAttachments((AttachmentHolder)iteration);
        Map<String, String> assignableUsers = this.getAssignableUsers(iterationId);
        Map<String, String> weights = this.getWeights();
        Map userPrefs = this.partyPreferenceService.findPreferencesForCurrentUser();
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(iteration);
        TestPlanStatistics testSuiteStats = this.iterationModService.findIterationStatistics(iterationId);
        model.addAttribute(ITERATION_KEY, (Object)iteration);
        model.addAttribute("statistics", (Object)testSuiteStats);
        model.addAttribute("hasCUF", (Object)hasCUF);
        model.addAttribute("attachmentsModel", (Object)attachmentsModel);
        model.addAttribute("assignableUsers", assignableUsers);
        model.addAttribute("weights", weights);
        model.addAttribute("modes", this.getModes());
        model.addAttribute("statuses", this.getStatuses(iteration.getProject().getId()));
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        model.addAttribute("iterationStatusComboJson", (Object)this.buildStatusComboData());
        model.addAttribute("iterationStatusLabel", (Object)this.formatStatus(iteration.getStatus()));
        model.addAttribute("userPrefs", (Object)userPrefs);
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        this.populateOptionalExecutionStatuses(iteration, model);
    }

    private void populateOptionalExecutionStatuses(Iteration iteration, Model model) {
        model.addAttribute("allowsSettled", (Object)iteration.getCampaign().getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addAttribute("allowsUntestable", (Object)iteration.getCampaign().getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
    }

    private Map<String, String> getStatuses(long projectId) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((ExecutionStatusJeditableComboDataBuilder)((ExecutionStatusJeditableComboDataBuilder)this.executionStatusComboBuilderProvider.get()).useContext(projectId).useLocale(locale)).buildMap();
    }

    private Map<String, String> getModes() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseModeJeditableComboDataBuilder)((TestCaseModeJeditableComboDataBuilder)this.modeComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private String formatStatus(IterationStatus status) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)status);
    }

    @RequestMapping(value={"/status-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    private String buildStatusComboData() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((IterationStatusJeditableComboDataBuilder)((IterationStatusJeditableComboDataBuilder)this.statusComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    private Map<String, String> getWeights() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseImportanceJeditableComboDataBuilder)((TestCaseImportanceJeditableComboDataBuilder)this.importanceComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private Map<String, String> getAssignableUsers(@PathVariable long iterationId) {
        Locale locale = LocaleContextHolder.getLocale();
        List usersList = this.iterationTestPlanManagerService.findAssignableUserForTestPlan(iterationId);
        Collections.sort(usersList, new UserLoginComparator());
        String unassignedLabel = this.messageSource.internationalize("label.Unassigned", locale);
        LinkedHashMap<String, String> jsonUsers = new LinkedHashMap<String, String>(usersList.size());
        jsonUsers.put(User.NO_USER_ID.toString(), unassignedLabel);
        for (User user : usersList) {
            String identity = String.valueOf(user.getFirstName()) + " " + user.getLastName() + " (" + user.getLogin() + ")";
            jsonUsers.put(user.getId().toString(), HtmlUtils.htmlEscape((String)identity));
        }
        return jsonUsers;
    }

    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public ModelAndView refreshStats(@PathVariable long iterationId) {
        ModelAndView mav = new ModelAndView("fragment/generics/statistics-fragment");
        TestPlanStatistics iterationStatistics = this.iterationModService.findIterationStatistics(iterationId);
        mav.addObject("statisticsEntity", (Object)iterationStatistics);
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        mav.addObject("allowsSettled", (Object)iteration.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        mav.addObject("allowsUntestable", (Object)iteration.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/dashboard-statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public IterationStatisticsBundle getStatisticsAsJson(@PathVariable(value="iterationId") long iterationId) {
        return this.iterationModService.gatherIterationStatisticsBundle(iterationId);
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getDashboard(Model model, @PathVariable(value="iterationId") long iterationId) {
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        IterationStatisticsBundle bundle = this.iterationModService.gatherIterationStatisticsBundle(iterationId);
        ModelAndView mav = new ModelAndView("fragment/iterations/iteration-dashboard");
        mav.addObject(ITERATION_KEY, (Object)iteration);
        mav.addObject("dashboardModel", (Object)bundle);
        this.populateOptionalExecutionStatuses(iteration, model);
        return mav;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=iteration-description", "value"})
    @ResponseBody
    public String updateDescription(@RequestParam(value="value") String newDescription, @PathVariable long iterationId) {
        this.iterationModService.changeDescription(iterationId, newDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Iteration " + iterationId + ": updated description to " + newDescription);
        }
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=iteration-reference", "value"})
    @ResponseBody
    public String updateReference(@RequestParam(value="value") String newReference, @PathVariable long iterationId) {
        this.iterationModService.changeReference(iterationId, newReference);
        LOGGER.trace("Iteration " + iterationId + ": updated reference to " + newReference);
        return HtmlUtils.htmlEscape((String)newReference);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=iteration-status", "value"})
    public String changeStatus(@PathVariable long iterationId, @RequestParam(value="value") IterationStatus status) {
        this.iterationModService.changeStatus(iterationId, status);
        return this.formatStatus(status);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object rename(@RequestParam(value="newName") String newName, @PathVariable long iterationId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("IterationModificationController : renaming {} as {}", (Object)iterationId, (Object)newName);
        }
        this.iterationModService.rename(iterationId, newName);
        return new RenameModel(newName);
    }

    @ResponseBody
    @RequestMapping(value={"/duplicateTestSuite/{testSuiteId}"}, method={RequestMethod.POST})
    public Long duplicateTestSuite(@PathVariable(value="iterationId") Long iterationId, @PathVariable(value="testSuiteId") Long testSuiteId) {
        TestSuite duplicate = this.iterationModService.copyPasteTestSuiteToIteration(testSuiteId.longValue(), iterationId.longValue());
        return duplicate.getId();
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable long iterationId) {
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        return new JsonGeneralInfo((AuditableMixin)iteration);
    }

    @RequestMapping(value={"/exec-button"}, method={RequestMethod.GET})
    public ModelAndView refreshExecButton(@PathVariable(value="iterationId") long iterationId) {
        TestPlanStatistics iterationStats = this.iterationModService.findIterationStatistics(iterationId);
        ModelAndView mav = new ModelAndView("fragment/iterations/iteration-execution-button");
        mav.addObject(ITERATION_ID_KEY, (Object)iterationId);
        mav.addObject("statisticsEntity", (Object)iterationStats);
        return mav;
    }

    private Date strToDate(String strDate) {
        return DateUtils.millisecondsToDate((String)strDate);
    }

    private String dateToStr(Date date) {
        return DateUtils.dateToMillisecondsAsString((Date)date);
    }

    @ResponseBody
    @RequestMapping(value={"/planning"}, params={"scheduledStart"})
    public String setScheduledStart(@PathVariable long iterationId, @RequestParam(value="scheduledStart") String strDate) {
        Date newScheduledStart = this.strToDate(strDate);
        String toReturn = this.dateToStr(newScheduledStart);
        LOGGER.info("IterationModificationController : setting scheduled start date for iteration {}, new date : {}", (Object)iterationId, (Object)newScheduledStart);
        this.iterationModService.changeScheduledStartDate(iterationId, newScheduledStart);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"scheduledEnd"})
    @ResponseBody
    public String setScheduledEnd(@PathVariable long iterationId, @RequestParam(value="scheduledEnd") String strDate) {
        Date newScheduledEnd = this.strToDate(strDate);
        String toReturn = this.dateToStr(newScheduledEnd);
        LOGGER.info("IterationModificationController : setting scheduled end date for iteration {}, new date : {}", (Object)iterationId, (Object)newScheduledEnd);
        this.iterationModService.changeScheduledEndDate(iterationId, newScheduledEnd);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"actualStart"})
    @ResponseBody
    public String setActualStart(@PathVariable long iterationId, @RequestParam(value="actualStart") String strDate) {
        Date newActualStart = this.strToDate(strDate);
        String toReturn = this.dateToStr(newActualStart);
        LOGGER.info("IterationModificationController : setting actual start date for iteration {}, new date : {}", (Object)iterationId, (Object)newActualStart);
        this.iterationModService.changeActualStartDate(iterationId, newActualStart);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"actualEnd"})
    @ResponseBody
    public String setActualEnd(@PathVariable long iterationId, @RequestParam(value="actualEnd") String strDate) {
        Date newActualEnd = this.strToDate(strDate);
        String toReturn = this.dateToStr(newActualEnd);
        LOGGER.info("IterationModificationController : setting actual end date for iteration {}, new date : {}", (Object)iterationId, (Object)newActualEnd);
        this.iterationModService.changeActualEndDate(iterationId, newActualEnd);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"setActualStartAuto"})
    @ResponseBody
    public String setActualStartAuto(@PathVariable long iterationId, @RequestParam(value="setActualStartAuto") boolean auto) {
        LOGGER.info("IterationModificationController : autosetting actual start date for iteration {}, new value {}", (Object)iterationId, (Object)auto);
        this.iterationModService.changeActualStartAuto(iterationId, auto);
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        return this.dateToStr(iteration.getActualStartDate());
    }

    @RequestMapping(value={"/planning"}, params={"setActualEndAuto"})
    @ResponseBody
    public String setActualEndAuto(@PathVariable long iterationId, @RequestParam(value="setActualEndAuto") boolean auto) {
        LOGGER.info("IterationModificationController : autosetting actual end date for campaign {}, new value {}", (Object)iterationId, (Object)auto);
        this.iterationModService.changeActualEndAuto(iterationId, auto);
        Iteration iteration = (Iteration)this.iterationModService.findById(iterationId);
        return this.dateToStr(iteration.getActualEndDate());
    }

    @ResponseBody
    @RequestMapping(value={"/test-plan/{testPlanItemId}/executions/new"}, method={RequestMethod.POST}, params={"mode=manual"})
    public String addManualExecution(@PathVariable long testPlanItemId, @PathVariable long iterationId) {
        LOGGER.trace("Add manual execution : creating execution");
        Execution newExecution = this.iterationModService.addExecution(testPlanItemId, (MessageSource)this.messageSource);
        LOGGER.trace("Add manual execution : completed in");
        return newExecution.getId().toString();
    }

    @RequestMapping(value={"/test-plan/{itemId}/executions"}, method={RequestMethod.GET})
    public ModelAndView getExecutionsForTestPlan(@PathVariable(value="iterationId") long iterationId, @PathVariable(value="itemId") long itemId) {
        List executionList = this.iterationModService.findExecutionsByTestPlan(iterationId, itemId);
        Iteration iter = (Iteration)this.iterationModService.findById(iterationId);
        IterationTestPlanItem testPlanItem = this.testPlanFinder.findTestPlanItem(itemId);
        ModelAndView mav = new ModelAndView("fragment/iterations/iteration-test-plan-row");
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(iter);
        mav.addObject("testPlanItem", (Object)testPlanItem);
        mav.addObject(ITERATION_ID_KEY, (Object)iterationId);
        mav.addObject(ITERATION_KEY, (Object)iter);
        mav.addObject("executions", (Object)executionList);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/new"}, params={"name"}, method={RequestMethod.POST})
    public Map<String, String> addTestSuite(@PathVariable long iterationId, @Valid @ModelAttribute(value="new-test-suite") TestSuite suite) {
        this.iterationModService.addTestSuite(iterationId, suite);
        HashMap<String, String> res = new HashMap<String, String>();
        res.put("id", suite.getId().toString());
        res.put(NAME, HtmlUtils.htmlEscape((String)suite.getName()));
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites"}, method={RequestMethod.GET})
    public List<TestSuiteModel> getTestSuites(@PathVariable long iterationId) {
        List testSuites = this.iterationModService.findAllTestSuites(iterationId);
        ArrayList<TestSuiteModel> result = new ArrayList<TestSuiteModel>();
        for (TestSuite testSuite : testSuites) {
            TestSuiteModel model = new TestSuiteModel(testSuite.getId(), testSuite.getName());
            result.add(model);
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/delete"}, method={RequestMethod.POST}, params={"ids[]"})
    public OperationReport removeTestSuites(@RequestParam(value="ids[]") List<Long> ids) {
        OperationReport report = this.iterationModService.removeTestSuites(ids);
        LOGGER.debug("removal of {} Test Suites", (Object)report.getRemoved().size());
        return report;
    }

    private static final class UserLoginComparator
    implements Comparator<User>,
    Serializable {
        private UserLoginComparator() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getLogin().compareTo(u2.getLogin());
        }
    }
}

