/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.service.testautomation.AutomatedSuiteManagerService;
import org.squashtest.tm.web.internal.controller.campaign.AutomatedSuiteTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableMultiSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/iterations/{iterationId}/automated-suite"})
public class IterationAutomatedSuiteManagerController {
    private static final String AUTOMATED_SUITE_ID = "automatedSuiteId";
    private static final Logger LOGGER = LoggerFactory.getLogger(IterationAutomatedSuiteManagerController.class);
    @Inject
    private AutomatedSuiteManagerService automatedSuiteManagerService;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    private final DatatableMapper<String> automatedSuitesMapper = new NameBasedMapper().map("entity-index", "index(AutomatedSuite)").map("uuid", "id");

    @ResponseBody
    @GetMapping(params={"sEcho"})
    public DataTableModel getAutomatedSuiteListModel(@PathVariable long iterationId, DataTableDrawParameters params, Locale locale) {
        DataTableMultiSorting paging = new DataTableMultiSorting(params, this.automatedSuitesMapper);
        DataTableColumnFiltering filter = new DataTableColumnFiltering(params);
        PagedCollectionHolder holder = this.automatedSuiteManagerService.getAutomatedSuitesByIterationID(Long.valueOf(iterationId), (PagingAndMultiSorting)paging, (ColumnFiltering)filter);
        return new AutomatedSuiteTableModelHelper(locale, this.internationalizationHelper).buildDataModel(holder, params.getsEcho());
    }

    @GetMapping(value={"/{automatedSuiteId}/executions"})
    public ModelAndView getExecutionsForTestPlan(@PathVariable(value="automatedSuiteId") String automatedSuiteId) {
        LOGGER.debug("find model and view for executions of automated suite  #{}", (Object)automatedSuiteId);
        List executionList = this.automatedSuiteManagerService.findExecutionsByAutomatedTestSuiteId(automatedSuiteId);
        ModelAndView mav = new ModelAndView("fragment/iterations/iteration-automated-suites-row");
        mav.addObject("executions", (Object)executionList);
        return mav;
    }
}

