/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.api.workspace.WorkspaceType;
import org.squashtest.tm.domain.EntityReference;
import org.squashtest.tm.domain.EntityType;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.library.WorkspaceService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.generic.WorkspaceController;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;

@Controller
@RequestMapping(value={"/campaign-workspace"})
public class CampaignWorkspaceController
extends WorkspaceController<CampaignLibraryNode> {
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private WorkspaceService<CampaignLibrary> workspaceService;
    @Inject
    @Named(value="campaign.driveNodeBuilder")
    private Provider<DriveNodeBuilder<CampaignLibraryNode>> driveNodeBuilderProvider;
    @Inject
    @Named(value="campaignWorkspaceDisplayService")
    private WorkspaceDisplayService workspaceDisplayService;

    @Override
    protected WorkspaceService<CampaignLibrary> getWorkspaceService() {
        return this.workspaceService;
    }

    @Override
    protected String getWorkspaceViewName() {
        return "campaign-workspace.html";
    }

    @Override
    public WorkspaceType getWorkspaceType() {
        return WorkspaceType.CAMPAIGN_WORKSPACE;
    }

    @Override
    protected void populateModel(Model model, Locale locale) {
    }

    @Override
    protected Provider<DriveNodeBuilder<CampaignLibraryNode>> driveNodeBuilderProvider() {
        return this.driveNodeBuilderProvider;
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.workspaceDisplayService;
    }

    @Override
    protected String[] getNodeParentsInWorkspace(EntityReference entityReference) {
        List parents = this.campaignLibraryNavigationService.getParentNodesAsStringList(entityReference);
        return parents.toArray(new String[parents.size()]);
    }

    @Override
    protected String getTreeElementIdInWorkspace(EntityReference entityReference) {
        return entityReference.getType().equals((Object)EntityType.CAMPAIGN) ? "Campaign-" + entityReference.getId() : "Iteration-" + entityReference.getId();
    }
}

