/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Abbreviated;
import org.squashtest.tm.domain.campaign.CampaignTestPlanItem;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseImportance;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.IndexedCampaignTestPlanItem;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.web.internal.controller.campaign.TestPlanTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneModelUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.JeditableComboHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.json.JsonDataset;

final class CampaignTestPlanTableModelHelper
extends DataTableModelBuilder<IndexedCampaignTestPlanItem> {
    private Locale locale;
    private InternationalizationHelper messageSource;
    private PermissionEvaluationService permService;

    CampaignTestPlanTableModelHelper(InternationalizationHelper messageSource, Locale locale, PermissionEvaluationService permService) {
        this.messageSource = messageSource;
        this.locale = locale;
        this.permService = permService;
    }

    private String formatNoData(Locale locale) {
        return this.messageSource.noData(locale);
    }

    public Map<String, Object> buildItemData(IndexedCampaignTestPlanItem indexedItem) {
        Integer index = indexedItem.getIndex() + 1;
        CampaignTestPlanItem item = indexedItem.getItem();
        HashMap<String, Object> result = new HashMap<String, Object>();
        TestCase testCase = item.getReferencedTestCase();
        String user = item.getUser() != null ? String.valueOf(item.getUser().getFirstName()) + " " + item.getUser().getLastName() + " (" + item.getUser().getLogin() + ")" : this.formatNoData(this.locale);
        Long assigneeId = item.getUser() != null ? item.getUser().getId() : User.NO_USER_ID;
        String reference = testCase.getReference().isEmpty() ? this.formatNoData(this.locale) : HtmlUtils.htmlEscape((String)testCase.getReference());
        TestPlanTableModelHelper.DatasetInfos dsInfos = this.makeDatasetInfo(item);
        result.put("entity-id", item.getId());
        result.put("entity-index", index);
        result.put("project-name", HtmlUtils.htmlEscape((String)testCase.getProject().getName()));
        result.put("reference", reference);
        result.put("tc-name", HtmlUtils.htmlEscape((String)testCase.getName()));
        result.put("assigned-user", HtmlUtils.htmlEscape((String)user));
        result.put("assigned-to", assigneeId);
        result.put("importance", this.formatImportance(testCase.getImportance(), this.locale));
        result.put("exec-mode", testCase.isAutomated() ? "A" : "M");
        result.put("dataset", dsInfos);
        result.put("empty-delete-holder", " ");
        result.put("milestone-dates", MilestoneModelUtils.timeIntervalToString(testCase.getMilestones(), this.messageSource, this.locale));
        result.put("tc-id", testCase.getId());
        result.put("milestone-labels", MilestoneModelUtils.milestoneLabelsOrderByDate(testCase.getMilestones()));
        result.put("readable", this.permService.canRead((Object)testCase));
        return result;
    }

    private TestPlanTableModelHelper.DatasetInfos makeDatasetInfo(CampaignTestPlanItem item) {
        if (item.getReferencedTestCase().getDatasets().isEmpty()) {
            return TestPlanTableModelHelper.DatasetInfos.EMPTY_INFOS;
        }
        Dataset selected = item.getReferencedDataset();
        Set available = item.getReferencedTestCase().getDatasets();
        JsonDataset jsonSelected = this.convert(selected);
        ArrayList<JsonDataset> jsonAvailable = new ArrayList<JsonDataset>(available.size() + 1);
        jsonAvailable.add(this.convert(null));
        for (Dataset ds : available) {
            jsonAvailable.add(this.convert(ds));
        }
        return new TestPlanTableModelHelper.DatasetInfos(jsonSelected, jsonAvailable);
    }

    private JsonDataset convert(Dataset ds) {
        JsonDataset jsds = new JsonDataset();
        if (ds == null) {
            jsds.setName(this.messageSource.internationalize("label.noneDSEscaped", this.locale));
            jsds.setId(JeditableComboHelper.coerceIntoComboId(null));
        } else {
            jsds.setName(HtmlUtils.htmlEscape((String)ds.getName()));
            jsds.setId(JeditableComboHelper.coerceIntoComboId(ds.getId()));
        }
        return jsds;
    }

    private String formatImportance(TestCaseImportance importance, Locale locale) {
        return this.messageSource.internationalizeAbbreviation((Abbreviated)importance, locale);
    }
}

