/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.collections.MultiMap;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.MultiSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndMultiSorting;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.testcase.Dataset;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseLibrary;
import org.squashtest.tm.domain.testcase.TestCaseLibraryNode;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.campaign.CampaignTestPlanTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.helper.JsTreeHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.JeditableComboHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableMultiSorting;
import org.squashtest.tm.web.internal.model.jquery.TestPlanAssignableUser;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
public class CampaignTestPlanManagerController {
    private static final String TESTCASES_IDS_REQUEST_PARAM = "testCasesIds[]";
    @Inject
    @Named(value="testCase.driveNodeBuilder")
    private Provider<DriveNodeBuilder<TestCaseLibraryNode>> driveNodeBuilder;
    @Inject
    private CampaignTestPlanManagerService testPlanManager;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private WorkspaceDisplayService testCaseWorkspaceDisplayService;
    @Inject
    protected UserAccountService userAccountService;
    @Inject
    private PermissionEvaluationService permService;
    private final DatatableMapper<String> testPlanMapper = new NameBasedMapper().map("entity-index", "index(CampaignTestPlanItem)").mapAttribute("project-name", "name", Project.class).mapAttribute("reference", "reference", TestCase.class).mapAttribute("tc-name", "name", TestCase.class).mapAttribute("dataset.selected.name", "name", Dataset.class).mapAttribute("assigned-user", "login", User.class).mapAttribute("importance", "importance", TestCase.class).mapAttribute("exec-mode", "automatedTest", TestCase.class).map("milestone-dates", "endDate");

    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/manager"}, method={RequestMethod.GET})
    public ModelAndView showManager(@PathVariable long campaignId, @CookieValue(value="jstree_open", required=false, defaultValue="") String[] openedNodes) {
        Campaign campaign = this.testPlanManager.findCampaign(campaignId);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(campaign);
        MultiMap expansionCandidates = JsTreeHelper.mapIdsByType(openedNodes);
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        List projectIds = this.testPlanManager.findLinkableTestCaseLibraries().stream().map(TestCaseLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        Optional activeMilestoneId = this.activeMilestoneHolder.getActiveMilestoneId();
        Collection linkableLibrariesModel = this.testCaseWorkspaceDisplayService.findAllLibraries(projectIds, currentUser, expansionCandidates, (Long)activeMilestoneId.get());
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-campaign-test-plan-manager");
        mav.addObject("campaign", (Object)campaign);
        mav.addObject("linkableLibrariesModel", (Object)linkableLibrariesModel);
        mav.addObject("milestoneConf", (Object)milestoneConf);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"campaigns/{campaignId}/test-plan"}, params={"sEcho"})
    public DataTableModel getTestCasesTableModel(@PathVariable(value="campaignId") long campaignId, DataTableDrawParameters params, Locale locale) {
        DataTableMultiSorting sorter = new DataTableMultiSorting(params, this.testPlanMapper);
        DataTableColumnFiltering filter = new DataTableColumnFiltering(params);
        PagedCollectionHolder holder = this.testPlanManager.findTestPlan(campaignId, (PagingAndMultiSorting)sorter, (ColumnFiltering)filter);
        return new CampaignTestPlanTableModelHelper(this.messageSource, locale, this.permService).buildDataModel(holder, params.getsEcho());
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/test-plan"}, method={RequestMethod.POST}, params={"testCasesIds[]"})
    public void addTestCasesToCampaign(@RequestParam(value="testCasesIds[]") List<Long> testCasesIds, @PathVariable long campaignId) {
        this.testPlanManager.addTestCasesToCampaignTestPlan(testCasesIds, campaignId);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/{testPlanIds}"}, method={RequestMethod.DELETE})
    public void removeItemsFromTestPlan(@PathVariable(value="campaignId") long campaignId, @PathVariable(value="testPlanIds") List<Long> itemsIds) {
        this.testPlanManager.removeTestPlanItems(campaignId, itemsIds);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/{itemId}/assign-user"}, method={RequestMethod.POST}, params={"userId"})
    public void assignUserToCampaignTestPlanItem(@PathVariable long itemId, @PathVariable long campaignId, @RequestParam long userId) {
        this.testPlanManager.assignUserToTestPlanItem(itemId, campaignId, userId);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/assignable-users"}, method={RequestMethod.GET})
    public List<TestPlanAssignableUser> getAssignUserForCampaignTestPlanItem(@PathVariable(value="campaignId") long campaignId, Locale locale) {
        List usersList = this.testPlanManager.findAssignableUserForTestPlan(campaignId);
        String unassignedLabel = this.formatUnassigned(locale);
        LinkedList<TestPlanAssignableUser> jsonUsers = new LinkedList<TestPlanAssignableUser>();
        jsonUsers.add(new TestPlanAssignableUser(User.NO_USER_ID.toString(), unassignedLabel));
        for (User user : usersList) {
            jsonUsers.add(new TestPlanAssignableUser(user));
        }
        return jsonUsers;
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/{testPlanIds}"}, method={RequestMethod.POST}, params={"assignee"})
    public Long assignUserToCampaignTestPlanItem(@PathVariable(value="testPlanIds") List<Long> testPlanIds, @PathVariable(value="campaignId") long campaignId, @RequestParam(value="assignee") long assignee) {
        this.testPlanManager.assignUserToTestPlanItems(testPlanIds, campaignId, assignee);
        return assignee;
    }

    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/{itemIds}/position/{newIndex}"}, method={RequestMethod.POST})
    @ResponseBody
    public void moveTestPlanItems(@PathVariable(value="campaignId") long campaignId, @PathVariable(value="newIndex") int newIndex, @PathVariable(value="itemIds") List<Long> itemIds) {
        this.testPlanManager.moveTestPlanItems(campaignId, newIndex, itemIds);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/{testPlanId}"}, method={RequestMethod.POST}, params={"dataset"})
    public Long setDataset(@PathVariable(value="testPlanId") long testPlanId, @RequestParam(value="dataset") Long datasetId) {
        this.testPlanManager.changeDataset(testPlanId, JeditableComboHelper.coerceIntoEntityId(datasetId));
        return datasetId;
    }

    @RequestMapping(value={"/campaigns/{campaignId}/test-plan/order"}, method={RequestMethod.POST})
    @ResponseBody
    public void reorderTestPlan(@PathVariable(value="campaignId") long campaignId, DataTableDrawParameters parameters) {
        DataTableMultiSorting sorting = new DataTableMultiSorting(parameters, this.testPlanMapper);
        this.testPlanManager.reorderTestPlan(campaignId, (MultiSorting)sorting);
    }

    private String formatUnassigned(Locale locale) {
        return this.messageSource.internationalize("label.Unassigned", locale);
    }
}

