/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.SinglePageCollectionHolder;
import org.squashtest.tm.core.foundation.lang.DateUtils;
import org.squashtest.tm.domain.Level;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.audit.AuditableMixin;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignStatus;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestPlanStatistics;
import org.squashtest.tm.domain.customfield.BoundEntity;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.campaign.CampaignTestPlanManagerService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.customfield.CustomFieldValueFinderService;
import org.squashtest.tm.service.customreport.CustomReportDashboardService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.statistics.campaign.CampaignStatisticsBundle;
import org.squashtest.tm.service.user.PartyPreferenceService;
import org.squashtest.tm.web.internal.controller.campaign.CampaignStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneFeatureConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestonePanelConfiguration;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneUIConfigurationService;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseImportanceJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.TestCaseModeJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.controller.testcase.executions.ExecutionStatusJeditableComboDataBuilder;
import org.squashtest.tm.web.internal.helper.LevelLabelFormatter;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.json.JsonGeneralInfo;
import org.squashtest.tm.web.internal.model.json.JsonIteration;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/campaigns/{campaignId}"})
public class CampaignModificationController {
    private static final String CAMPAIGN_ID = "campaignId";
    private static final String LOG_MSG_SET_CPG_SART_DATE = "Setting scheduled start date for campaign ";
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignModificationController.class);
    private static final String PLANNING_URL = "/planning";
    private static final String NEW_DATE_ = ", new date : ";
    private static final String CAMPAIGN = "campaign";
    @Inject
    private CampaignModificationService campaignModService;
    @Inject
    private IterationModificationService iterationModService;
    @Inject
    private CustomFieldValueFinderService cufValueService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentHelper;
    @Inject
    private Provider<TestCaseImportanceJeditableComboDataBuilder> importanceComboBuilderProvider;
    @Inject
    private Provider<TestCaseModeJeditableComboDataBuilder> modeComboBuilderProvider;
    @Inject
    private Provider<LevelLabelFormatter> levelLabelFormatterProvider;
    @Inject
    private Provider<CampaignStatusJeditableComboDataBuilder> statusComboBuilderProvider;
    @Inject
    private CampaignTestPlanManagerService testPlanManager;
    @Inject
    private MilestoneUIConfigurationService milestoneConfService;
    @Inject
    private PermissionEvaluationService permissionService;
    @Inject
    private CustomReportDashboardService customReportDashboardService;
    @Inject
    private Provider<ExecutionStatusJeditableComboDataBuilder> executionStatusComboBuilderProvider;
    @Inject
    private PartyPreferenceService partyPreferenceService;

    @RequestMapping(value={"/statistics"}, method={RequestMethod.GET})
    public ModelAndView refreshStats(@PathVariable long campaignId) {
        TestPlanStatistics campaignStatistics = this.campaignModService.findCampaignStatistics(campaignId);
        Campaign campaign = this.campaignModService.findById(campaignId);
        ModelAndView mav = new ModelAndView("fragment/generics/statistics-fragment");
        mav.addObject("allowsSettled", (Object)campaign.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        mav.addObject("allowsUntestable", (Object)campaign.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
        mav.addObject("statisticsEntity", (Object)campaignStatistics);
        return mav;
    }

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public String showCampaignInfo(@PathVariable long campaignId, Model model) {
        this.populateCampaignModel(campaignId, model);
        return "page/campaign-workspace/show-campaign";
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showCampaign(@PathVariable long campaignId, Model model) {
        this.populateCampaignModel(campaignId, model);
        return "fragment/campaigns/campaign";
    }

    private Model populateCampaignModel(long campaignId, Model model) {
        Campaign campaign = this.campaignModService.findById(campaignId);
        TestPlanStatistics statistics = this.campaignModService.findCampaignStatistics(campaignId);
        boolean hasCUF = this.cufValueService.hasCustomFields((BoundEntity)campaign);
        DataTableModel attachments = this.attachmentHelper.findPagedAttachments((AttachmentHolder)campaign);
        Map userPrefs = this.partyPreferenceService.findPreferencesForCurrentUser();
        model.addAttribute(CAMPAIGN, (Object)campaign);
        model.addAttribute("statistics", (Object)statistics);
        model.addAttribute("hasCUF", (Object)hasCUF);
        model.addAttribute("attachmentsModel", (Object)attachments);
        model.addAttribute("assignableUsers", this.getAssignableUsers(campaignId));
        model.addAttribute("weights", this.getWeights());
        model.addAttribute("modes", this.getModes());
        model.addAttribute("campaignStatusComboJson", (Object)this.buildStatusComboData());
        model.addAttribute("campaignStatusLabel", (Object)this.formatStatus(campaign.getStatus()));
        model.addAttribute("statuses", this.getStatuses(campaign.getProject().getId()));
        model.addAttribute("userPrefs", (Object)userPrefs);
        MilestoneFeatureConfiguration milestoneConf = this.milestoneConfService.configure(campaign);
        model.addAttribute("milestoneConf", (Object)milestoneConf);
        this.populateOptionalExecutionStatuses(campaign, model);
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN);
        model.addAttribute("shouldShowDashboard", (Object)shouldShowDashboard);
        model.addAttribute("canShowDashboard", (Object)canShowDashboard);
        return model;
    }

    private void populateOptionalExecutionStatuses(Campaign campaign, Model model) {
        model.addAttribute("allowsSettled", (Object)campaign.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addAttribute("allowsUntestable", (Object)campaign.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
    }

    private Map<String, String> getAssignableUsers(long campaignId) {
        Locale locale = LocaleContextHolder.getLocale();
        String unassignedLabel = this.messageSource.internationalize("label.Unassigned", locale);
        List usersList = this.testPlanManager.findAssignableUserForTestPlan(campaignId);
        Collections.sort(usersList, new UserLoginComparator());
        LinkedHashMap<String, String> jsonUsers = new LinkedHashMap<String, String>(usersList.size());
        jsonUsers.put(User.NO_USER_ID.toString(), unassignedLabel);
        for (User user : usersList) {
            String identity = String.valueOf(user.getFirstName()) + " " + user.getLastName() + " (" + user.getLogin() + ")";
            jsonUsers.put(user.getId().toString(), HtmlUtils.htmlEscape((String)identity));
        }
        return jsonUsers;
    }

    private Map<String, String> getStatuses(long projectId) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((ExecutionStatusJeditableComboDataBuilder)((ExecutionStatusJeditableComboDataBuilder)this.executionStatusComboBuilderProvider.get()).useContext(projectId).useLocale(locale)).buildMap();
    }

    private Map<String, String> getWeights() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseImportanceJeditableComboDataBuilder)((TestCaseImportanceJeditableComboDataBuilder)this.importanceComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private Map<String, String> getModes() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((TestCaseModeJeditableComboDataBuilder)((TestCaseModeJeditableComboDataBuilder)this.modeComboBuilderProvider.get()).useLocale(locale)).buildMap();
    }

    private String formatStatus(CampaignStatus status) {
        Locale locale = LocaleContextHolder.getLocale();
        return ((LevelLabelFormatter)this.levelLabelFormatterProvider.get()).useLocale(locale).formatLabel((Level)status);
    }

    @RequestMapping(value={"/status-combo-data"}, method={RequestMethod.GET})
    @ResponseBody
    private String buildStatusComboData() {
        Locale locale = LocaleContextHolder.getLocale();
        return ((CampaignStatusJeditableComboDataBuilder)((CampaignStatusJeditableComboDataBuilder)this.statusComboBuilderProvider.get()).useLocale(locale)).buildMarshalled();
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=campaign-description", "value"})
    public String updateDescription(@RequestParam(value="value") String newDescription, @PathVariable long campaignId) {
        this.campaignModService.changeDescription(campaignId, newDescription);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Campaign " + campaignId + ": updated description to " + newDescription);
        }
        return HTMLCleanupUtils.cleanHtml(newDescription);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=campaign-reference", "value"})
    public String updateReference(@RequestParam(value="value") String newReference, @PathVariable long campaignId) {
        this.campaignModService.changeReference(campaignId, newReference);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Campaign " + campaignId + ": updated reference to " + newReference);
        }
        return HtmlUtils.htmlEscape((String)newReference);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"id=campaign-status", "value"})
    public String changeStatus(@PathVariable long campaignId, @RequestParam(value="value") CampaignStatus status) {
        this.campaignModService.changeStatus(campaignId, status);
        return this.formatStatus(status);
    }

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    public Object rename(@RequestParam(value="newName") String newName, @PathVariable long campaignId) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Renaming Campaign " + campaignId + " as " + newName);
        }
        this.campaignModService.rename(campaignId, newName);
        return new RenameModel(newName);
    }

    @RequestMapping(value={"/general"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public JsonGeneralInfo refreshGeneralInfos(@PathVariable long campaignId) {
        Campaign campaign = this.campaignModService.findById(campaignId);
        return new JsonGeneralInfo((AuditableMixin)campaign);
    }

    private Date strToDate(String strDate) {
        return DateUtils.millisecondsToDate((String)strDate);
    }

    private String dateToStr(Date date) {
        return DateUtils.dateToMillisecondsAsString((Date)date);
    }

    @ResponseBody
    @RequestMapping(value={"/planning"}, params={"scheduledStart"})
    public String setScheduledStart(@PathVariable long campaignId, @RequestParam(value="scheduledStart") String strDate) {
        Date newScheduledStart = this.strToDate(strDate);
        String toReturn = this.dateToStr(newScheduledStart);
        LOGGER.info(LOG_MSG_SET_CPG_SART_DATE + campaignId + NEW_DATE_ + newScheduledStart);
        this.campaignModService.changeScheduledStartDate(campaignId, newScheduledStart);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"scheduledEnd"})
    @ResponseBody
    String setScheduledEnd(@PathVariable long campaignId, @RequestParam(value="scheduledEnd") String strDate) {
        Date newScheduledEnd = this.strToDate(strDate);
        String toReturn = this.dateToStr(newScheduledEnd);
        LOGGER.info(LOG_MSG_SET_CPG_SART_DATE + campaignId + NEW_DATE_ + newScheduledEnd);
        this.campaignModService.changeScheduledEndDate(campaignId, newScheduledEnd);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"actualStart"})
    @ResponseBody
    String setActualStart(@PathVariable long campaignId, @RequestParam(value="actualStart") String strDate) {
        Date newActualStart = this.strToDate(strDate);
        String toReturn = this.dateToStr(newActualStart);
        LOGGER.info(LOG_MSG_SET_CPG_SART_DATE + campaignId + NEW_DATE_ + newActualStart);
        this.campaignModService.changeActualStartDate(campaignId, newActualStart);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"actualEnd"})
    @ResponseBody
    String setActualEnd(@PathVariable long campaignId, @RequestParam(value="actualEnd") String strDate) {
        Date newActualEnd = this.strToDate(strDate);
        String toReturn = this.dateToStr(newActualEnd);
        LOGGER.info(LOG_MSG_SET_CPG_SART_DATE + campaignId + NEW_DATE_ + newActualEnd);
        this.campaignModService.changeActualEndDate(campaignId, newActualEnd);
        return toReturn;
    }

    @RequestMapping(value={"/planning"}, params={"setActualStartAuto"})
    @ResponseBody
    String setActualStartAuto(@PathVariable long campaignId, @RequestParam(value="setActualStartAuto") Boolean auto) {
        LOGGER.info("Autosetting actual start date for campaign " + campaignId + ", new value " + auto.toString());
        this.campaignModService.changeActualStartAuto(campaignId, auto.booleanValue());
        Campaign campaign = this.campaignModService.findById(campaignId);
        return this.dateToStr(campaign.getActualStartDate());
    }

    @RequestMapping(value={"/planning"}, params={"setActualEndAuto"})
    @ResponseBody
    String setActualEndAuto(@PathVariable long campaignId, @RequestParam(value="setActualEndAuto") Boolean auto) {
        LOGGER.info("CampaignModificationController : autosetting actual end date for campaign " + campaignId + ", new value " + auto.toString());
        this.campaignModService.changeActualEndAuto(campaignId, auto.booleanValue());
        Campaign campaign = this.campaignModService.findById(campaignId);
        return this.dateToStr(campaign.getActualEndDate());
    }

    @RequestMapping(value={"/iterations"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public List<JsonIteration> getIterations(@PathVariable(value="campaignId") long campaignId) {
        List iterations = this.campaignModService.findIterationsByCampaignId(campaignId);
        return this.createJsonIterations(iterations);
    }

    @RequestMapping(value={"/iterations/count"}, produces={"application/json"}, method={RequestMethod.GET})
    @ResponseBody
    public Integer getNbIterations(@PathVariable(value="campaignId") long campaignId) {
        return this.campaignModService.countIterations(Long.valueOf(campaignId));
    }

    @RequestMapping(value={"/iterations/planning"}, consumes={"application/json"}, method={RequestMethod.POST})
    @ResponseBody
    public void setIterationsPlanning(@RequestBody JsonIteration[] iterations) throws ParseException {
        JsonIteration[] jsonIterationArray = iterations;
        int n = iterations.length;
        int n2 = 0;
        while (n2 < n) {
            JsonIteration iter = jsonIterationArray[n2];
            Date date = iter.getScheduledStartDate() != null ? DateUtils.parseIso8601DateTime((String)iter.getScheduledStartDate()) : null;
            this.iterationModService.changeScheduledStartDate(iter.getId(), date);
            date = iter.getScheduledEndDate() != null ? DateUtils.parseIso8601DateTime((String)iter.getScheduledEndDate()) : null;
            this.iterationModService.changeScheduledEndDate(iter.getId(), date);
            ++n2;
        }
    }

    @ResponseBody
    @RequestMapping(value={"/dashboard-statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public CampaignStatisticsBundle getStatisticsAsJson(@PathVariable(value="campaignId") long campaignId) {
        return this.campaignModService.gatherCampaignStatisticsBundle(campaignId);
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"}, params={"printmode"})
    public ModelAndView getDashboard(Model model, @PathVariable(value="campaignId") long campaignId, @RequestParam(value="printmode", defaultValue="false") Boolean printmode) {
        Campaign campaign = this.campaignModService.findById(campaignId);
        CampaignStatisticsBundle bundle = this.campaignModService.gatherCampaignStatisticsBundle(campaignId);
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-campaign-dashboard");
        mav.addObject(CAMPAIGN, (Object)campaign);
        mav.addObject("dashboardModel", (Object)bundle);
        mav.addObject("printmode", (Object)printmode);
        this.populateOptionalExecutionStatuses(campaign, model);
        return mav;
    }

    @RequestMapping(value={"/milestones"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getBoundMilestones(@PathVariable(value="campaignId") long campaignId, DataTableDrawParameters params) {
        Collection allMilestones = this.campaignModService.findAllMilestones(campaignId);
        return this.buildMilestoneModel(new ArrayList<Milestone>(allMilestones), params.getsEcho());
    }

    @RequestMapping(value={"/milestones/{milestoneId}"}, method={RequestMethod.POST})
    @ResponseBody
    public void bindMilestone(@PathVariable(value="campaignId") long campaignId, @PathVariable(value="milestoneId") Long milestoneId) {
        this.campaignModService.bindMilestone(campaignId, milestoneId.longValue());
    }

    @RequestMapping(value={"/milestones/{milestoneIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void unbindMilestones(@PathVariable(value="campaignId") long campaignId, @PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.campaignModService.unbindMilestones(campaignId, milestoneIds);
    }

    @RequestMapping(value={"/milestones/associables"}, method={RequestMethod.GET})
    @ResponseBody
    public DataTableModel getNotYetBoundMilestones(@PathVariable(value="campaignId") Long campaignId, DataTableDrawParameters params) {
        Collection notBoundMilestones = this.campaignModService.findAssociableMilestones(campaignId.longValue());
        return this.buildMilestoneModel(new ArrayList<Milestone>(notBoundMilestones), params.getsEcho());
    }

    @RequestMapping(value={"/milestones/panel"}, method={RequestMethod.GET})
    public String getMilestonesPanel(@PathVariable(value="campaignId") Long campaignId, Model model) {
        MilestonePanelConfiguration conf = new MilestonePanelConfiguration();
        Campaign camp = this.campaignModService.findById(campaignId.longValue());
        Collection allMilestones = this.campaignModService.findAllMilestones(campaignId.longValue());
        List currentModel = this.buildMilestoneModel(new ArrayList<Milestone>(allMilestones), "0").getAaData();
        HashMap<String, String> identity = new HashMap<String, String>();
        identity.put("restype", "campaigns");
        identity.put("resid", campaignId.toString());
        String rootPath = "campaigns/" + campaignId.toString();
        Boolean editable = this.permissionService.hasRole("ROLE_ADMIN") || this.permissionService.hasRole("ROLE_TM_PROJECT_MANAGER");
        List mil = camp.getProject().getMilestones();
        CollectionUtils.filter((Collection)mil, (Predicate)new Predicate(){

            public boolean evaluate(Object milestone) {
                return ((Milestone)milestone).getStatus().isBindableToObject();
            }
        });
        Boolean isMilestoneInProject = !mil.isEmpty();
        conf.setNodeType(CAMPAIGN);
        conf.setRootPath(rootPath);
        conf.setIdentity(identity);
        conf.setCurrentModel(currentModel);
        conf.setEditable(editable);
        conf.setMultilines(false);
        conf.setIsMilestoneInProject(isMilestoneInProject);
        model.addAttribute("conf", (Object)conf);
        return "milestones/milestones-tab.html";
    }

    private DataTableModel buildMilestoneModel(List<Milestone> milestones, String sEcho) {
        SinglePageCollectionHolder collectionHolder = new SinglePageCollectionHolder(milestones);
        Locale locale = LocaleContextHolder.getLocale();
        return new MilestoneTableModelHelper(this.messageSource, locale).buildDataModel(collectionHolder, sEcho);
    }

    private List<JsonIteration> createJsonIterations(List<Iteration> iterations) {
        ArrayList<JsonIteration> jsonIters = new ArrayList<JsonIteration>(iterations.size());
        for (Iteration iter : iterations) {
            JsonIteration jsonIter = new JsonIteration((long)iter.getId(), HTMLCleanupUtils.cleanAndUnescapeHTML(iter.getName()), iter.getScheduledStartDate(), iter.getScheduledEndDate());
            jsonIters.add(jsonIter);
        }
        return jsonIters;
    }

    private static final class UserLoginComparator
    implements Comparator<User>,
    Serializable {
        private UserLoginComparator() {
        }

        @Override
        public int compare(User u1, User u2) {
            return u1.getLogin().compareTo(u2.getLogin());
        }
    }
}

