/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.io.File;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.servlet.http.HttpServletResponse;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BeanPropertyBindingResult;
import org.springframework.validation.BindException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.Workspace;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.campaign.CampaignLibraryNode;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.campaign.export.CampaignExportCSVModel;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.exception.library.RightsUnsuficientsForOperationException;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CampaignLibraryFinderService;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationModificationService;
import org.squashtest.tm.service.deletion.OperationReport;
import org.squashtest.tm.service.deletion.SuppressionPreviewReport;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.internal.dto.UserDto;
import org.squashtest.tm.service.internal.dto.json.JsTreeNode;
import org.squashtest.tm.service.library.LibraryNavigationService;
import org.squashtest.tm.service.milestone.ActiveMilestoneHolder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.statistics.campaign.CampaignStatisticsBundle;
import org.squashtest.tm.service.workspace.WorkspaceDisplayService;
import org.squashtest.tm.web.internal.controller.campaign.CampaignFormModel;
import org.squashtest.tm.web.internal.controller.campaign.IterationFormModel;
import org.squashtest.tm.web.internal.controller.generic.LibraryNavigationController;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.builder.CampaignLibraryTreeNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.DriveNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.IterationNodeBuilder;
import org.squashtest.tm.web.internal.model.builder.TestSuiteNodeBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/campaign-browser"})
public class CampaignLibraryNavigationController
extends LibraryNavigationController<CampaignLibrary, CampaignFolder, CampaignLibraryNode> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CampaignLibraryNavigationController.class);
    private static final String REMOVE_FROM_ITER = "remove_from_iter";
    private static final String NODE_IDS = "nodeIds[]";
    @Inject
    @Named(value="campaign.driveNodeBuilder")
    private Provider<DriveNodeBuilder<CampaignLibraryNode>> driveNodeBuilder;
    @Inject
    private Provider<IterationNodeBuilder> iterationNodeBuilder;
    @Inject
    private Provider<CampaignLibraryTreeNodeBuilder> campaignLibraryTreeNodeBuilder;
    @Inject
    private Provider<TestSuiteNodeBuilder> suiteNodeBuilder;
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private CampaignLibraryFinderService campaignLibraryFinderService;
    @Inject
    private CampaignFinder campaignFinder;
    @Inject
    private ExecutionFinder executionFinder;
    @Inject
    private IterationModificationService iterationModificationService;
    @Inject
    private PermissionEvaluationService permissionEvaluator;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private ActiveMilestoneHolder activeMilestoneHolder;
    @Inject
    @Named(value="campaignWorkspaceDisplayService")
    private WorkspaceDisplayService workspaceDisplayService;

    @ResponseBody
    @RequestMapping(value={"/drives/{libraryId}/content/new-campaign"}, method={RequestMethod.POST})
    public JsTreeNode addNewCampaignToLibraryRootContent(@PathVariable Long libraryId, @RequestBody CampaignFormModel campaignForm) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)campaignForm, "add-campaign");
        CampaignFormModel.CampaignFormModelValidator validator = new CampaignFormModel.CampaignFormModelValidator(this.getMessageSource());
        validator.validate(campaignForm, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Campaign newCampaign = campaignForm.getCampaign();
        Map<Long, RawValue> customFieldValues = campaignForm.getCufs();
        this.campaignLibraryNavigationService.addCampaignToCampaignLibrary(libraryId.longValue(), newCampaign, customFieldValues);
        return this.createTreeNodeFromLibraryNode((CampaignLibraryNode)newCampaign);
    }

    @ResponseBody
    @RequestMapping(value={"/folders/{folderId}/content/new-campaign"}, method={RequestMethod.POST})
    public JsTreeNode addNewCampaignToFolderContent(@PathVariable long folderId, @RequestBody CampaignFormModel campaignForm) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)campaignForm, "add-campaign");
        CampaignFormModel.CampaignFormModelValidator validator = new CampaignFormModel.CampaignFormModelValidator(this.getMessageSource());
        validator.validate(campaignForm, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Campaign newCampaign = campaignForm.getCampaign();
        Map<Long, RawValue> customFieldValues = campaignForm.getCufs();
        this.campaignLibraryNavigationService.addCampaignToCampaignFolder(folderId, newCampaign, customFieldValues);
        return this.createTreeNodeFromLibraryNode((CampaignLibraryNode)newCampaign);
    }

    @Override
    protected LibraryNavigationService<CampaignLibrary, CampaignFolder, CampaignLibraryNode> getLibraryNavigationService() {
        return this.campaignLibraryNavigationService;
    }

    @Override
    protected JsTreeNode createTreeNodeFromLibraryNode(CampaignLibraryNode model) {
        CampaignLibraryTreeNodeBuilder builder = (CampaignLibraryTreeNodeBuilder)this.campaignLibraryTreeNodeBuilder.get();
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        if (activeMilestone.isPresent()) {
            builder.filterByMilestone((Milestone)activeMilestone.get());
        }
        return builder.setNode(model).build();
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/content/new-iteration"}, method={RequestMethod.POST})
    public JsTreeNode addNewIterationToCampaign(@PathVariable long campaignId, @RequestBody IterationFormModel iterationForm) throws BindException {
        BeanPropertyBindingResult validation = new BeanPropertyBindingResult((Object)iterationForm, "add-iteration");
        IterationFormModel.IterationFormModelValidator validator = new IterationFormModel.IterationFormModelValidator(this.getMessageSource());
        validator.validate(iterationForm, (Errors)validation);
        if (validation.hasErrors()) {
            throw new BindException((BindingResult)validation);
        }
        Iteration newIteration = iterationForm.getIteration();
        Map<Long, RawValue> customFieldValues = iterationForm.getCufs();
        boolean copyTestPlan = iterationForm.isCopyTestPlan();
        int newIterationIndex = this.campaignLibraryNavigationService.addIterationToCampaign(newIteration, campaignId, copyTestPlan, customFieldValues);
        return this.createIterationTreeNode(newIteration, newIterationIndex);
    }

    private JsTreeNode createIterationTreeNode(Iteration iteration, int iterationIndex) {
        return ((IterationNodeBuilder)((IterationNodeBuilder)((IterationNodeBuilder)this.iterationNodeBuilder.get()).setModel(iteration)).setIndex(iterationIndex)).build();
    }

    private JsTreeNode createBatchedIterationTreeNode(Iteration iteration, int iterationIndex, PermissionEvaluationService permissionEvaluationService) {
        return ((IterationNodeBuilder)((IterationNodeBuilder)new IterationNodeBuilder(permissionEvaluationService, this.internationalizationHelper).setModel(iteration)).setIndex(iterationIndex)).build();
    }

    private JsTreeNode createTestSuiteTreeNode(TestSuite testSuite) {
        return ((TestSuiteNodeBuilder)((TestSuiteNodeBuilder)this.suiteNodeBuilder.get()).setModel(testSuite)).build();
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getCampaignIterationsTreeModel(@PathVariable long campaignId) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Collection nodes = this.workspaceDisplayService().getCampaignNodeContent(Long.valueOf(campaignId), currentUser, "Campaign");
        return new ArrayList<JsTreeNode>(nodes);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{resourceId}/content"}, method={RequestMethod.GET})
    public List<JsTreeNode> getIterationTestSuitesTreeModel(@PathVariable(value="resourceId") long iterationId) {
        UserDto currentUser = this.userAccountService.findCurrentUserDto();
        Collection nodes = this.workspaceDisplayService().getCampaignNodeContent(Long.valueOf(iterationId), currentUser, "Iteration");
        return new ArrayList<JsTreeNode>(nodes);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{destinationId}/content/{nodeIds}"}, method={RequestMethod.PUT})
    public void moveNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId) {
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{destinationId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="position") int position) {
        try {
            this.campaignLibraryNavigationService.moveIterationsWithinCampaign(destinationId, nodeIds, position);
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{destinationId}/content/{nodeIds}/{position}"}, method={RequestMethod.PUT})
    public void moveTestSuiteNodes(@PathVariable(value="nodeIds") Long[] nodeIds, @PathVariable(value="destinationId") long destinationId, @PathVariable(value="position") int position) {
        try {
            this.iterationModificationService.changeTestSuitePosition(destinationId, position, Arrays.asList(nodeIds));
        }
        catch (AccessDeniedException ade) {
            throw new RightsUnsuficientsForOperationException((Exception)((Object)ade));
        }
    }

    @ResponseBody
    private List<JsTreeNode> createCopiedIterationsModel(List<Iteration> newIterations, int nextIterationNumber) {
        int iterationIndex = nextIterationNumber;
        ArrayList<JsTreeNode> res = new ArrayList<JsTreeNode>();
        ShortCutPermissionEvaluator pev = new ShortCutPermissionEvaluator();
        for (Iteration iteration : newIterations) {
            res.add(this.createBatchedIterationTreeNode(iteration, iterationIndex, pev));
            ++iterationIndex;
        }
        return res;
    }

    @ResponseBody
    private List<JsTreeNode> createCopiedTestSuitesModel(List<TestSuite> newTestSuites) {
        ArrayList<JsTreeNode> res = new ArrayList<JsTreeNode>();
        for (TestSuite testSuite : newTestSuites) {
            res.add(this.createTestSuiteTreeNode(testSuite));
        }
        return res;
    }

    @ResponseBody
    @RequestMapping(value={"/drives"}, method={RequestMethod.GET}, params={"linkables"})
    public List<JsTreeNode> getLinkablesRootModel() {
        List<Long> linkableCampaigntLibraryIds = this.campaignLibraryFinderService.findLinkableCampaignLibraries().stream().map(CampaignLibrary::getProject).map(GenericProject::getId).collect(Collectors.toList());
        return this.createLinkableLibrariesModel(linkableCampaigntLibraryIds);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationIds}/deletion-simulation"}, method={RequestMethod.GET})
    public LibraryNavigationController.Messages simulateIterationDeletion(@PathVariable(value="iterationIds") List<Long> iterationIds, Locale locale) {
        List reportList = this.campaignLibraryNavigationService.simulateIterationDeletion(iterationIds);
        LibraryNavigationController.Messages messages = new LibraryNavigationController.Messages();
        for (SuppressionPreviewReport report : reportList) {
            messages.addMessage(report.toString(this.getMessageSource(), locale));
        }
        return messages;
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationIds}"}, method={RequestMethod.DELETE})
    public OperationReport confirmIterationsDeletion(@PathVariable(value="iterationIds") List<Long> iterationIds) {
        return this.campaignLibraryNavigationService.deleteIterations(iterationIds);
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteIds}/deletion-simulation"}, method={RequestMethod.GET})
    public LibraryNavigationController.Messages simulateSuiteDeletion(@PathVariable(value="suiteIds") List<Long> suiteIds, Locale locale) {
        List reportList = this.campaignLibraryNavigationService.simulateSuiteDeletion(suiteIds);
        LibraryNavigationController.Messages messages = new LibraryNavigationController.Messages();
        for (SuppressionPreviewReport report : reportList) {
            messages.addMessage(report.toString(this.getMessageSource(), locale));
        }
        return messages;
    }

    @ResponseBody
    @RequestMapping(value={"/test-suites/{suiteIds}"}, params={"remove_from_iter"}, method={RequestMethod.DELETE})
    public OperationReport confirmSuitesDeletion(@PathVariable(value="suiteIds") List<Long> suiteIds, @RequestParam(value="remove_from_iter") boolean removeFromIter) {
        return this.campaignLibraryNavigationService.deleteSuites(suiteIds, removeFromIter);
    }

    @ResponseBody
    @RequestMapping(value={"/campaigns/{campaignId}/iterations/new"}, method={RequestMethod.POST}, params={"nodeIds[]", "next-iteration-index"})
    public List<JsTreeNode> copyIterations(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="campaignId") long campaignId, @RequestParam(value="next-iteration-index") int nextIterationIndex) {
        List iterationsList = this.campaignLibraryNavigationService.copyIterationsToCampaign(campaignId, nodeIds);
        return this.createCopiedIterationsModel(iterationsList, nextIterationIndex);
    }

    @ResponseBody
    @RequestMapping(value={"/iterations/{iterationId}/test-suites/new"}, method={RequestMethod.POST}, params={"nodeIds[]"})
    public List<JsTreeNode> copyTestSuites(@RequestParam(value="nodeIds[]") Long[] nodeIds, @PathVariable(value="iterationId") long iterationId) {
        List testSuiteList = this.iterationModificationService.copyPasteTestSuitesToIteration(nodeIds, iterationId);
        return this.createCopiedTestSuitesModel(testSuiteList);
    }

    @ResponseBody
    @RequestMapping(value={"/export-campaign/{campaignId}"}, method={RequestMethod.GET}, params={"export=csv"})
    public FileSystemResource exportCampaign(@PathVariable(value="campaignId") long campaignId, @RequestParam(value="exportType", defaultValue="S") String exportType, HttpServletResponse response) {
        Campaign campaign = this.campaignFinder.findById(campaignId);
        CampaignExportCSVModel model = this.campaignLibraryNavigationService.exportCampaignToCSV(Long.valueOf(campaignId), exportType);
        response.setContentType("application/octet-stream");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        response.setHeader("Content-Disposition", "attachment; filename=EXPORT_CPG_" + exportType + "_" + campaign.getName().replace(" ", "_") + "_" + sdf.format(new Date()) + ".csv");
        File exported = this.exportToFile(model);
        return new FileSystemResource(exported);
    }

    @ResponseBody
    @RequestMapping(value={"/export-campaign-by-execution/{executionId}"}, method={RequestMethod.GET}, params={"export=csv"})
    public FileSystemResource exportCampaignByExecution(@PathVariable(value="executionId") long executionId, @RequestParam(value="exportType", defaultValue="S") String exportType, HttpServletResponse response) {
        Execution execution = this.executionFinder.findById(executionId);
        Campaign campaign = this.campaignFinder.findById(execution.getCampaign().getId().longValue());
        CampaignExportCSVModel model = this.campaignLibraryNavigationService.exportCampaignToCSV(execution.getCampaign().getId(), exportType);
        response.setContentType("application/octet-stream");
        SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd_HHmmss");
        response.setHeader("Content-Disposition", "attachment; filename=EXPORT_CPG_" + exportType + "_" + campaign.getName().replace(" ", "_") + "_" + sdf.format(new Date()) + ".csv");
        File exported = this.exportToFile(model);
        return new FileSystemResource(exported);
    }

    @ResponseBody
    @RequestMapping(value={"/dashboard-milestones-statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public CampaignStatisticsBundle getStatisticsAsJson() {
        return this.campaignLibraryNavigationService.gatherCampaignStatisticsBundleByMilestone();
    }

    @RequestMapping(value={"/dashboard-milestones"}, method={RequestMethod.GET}, produces={"text/html"})
    public ModelAndView getDashboard(Model model) {
        ModelAndView mav = new ModelAndView("fragment/campaigns/campaign-milestone-dashboard");
        Optional activeMilestone = this.activeMilestoneHolder.getActiveMilestone();
        boolean shouldShowDashboard = this.customReportDashboardService.shouldShowFavoriteDashboardInWorkspace(Workspace.CAMPAIGN);
        boolean canShowDashboard = this.customReportDashboardService.canShowDashboardInWorkspace(Workspace.CAMPAIGN);
        mav.addObject("shouldShowDashboard", (Object)shouldShowDashboard);
        mav.addObject("canShowDashboard", (Object)canShowDashboard);
        mav.addObject("isMilestoneDashboard", (Object)true);
        mav.addObject("milestone", activeMilestone.get());
        if (!shouldShowDashboard || !canShowDashboard) {
            CampaignStatisticsBundle csbundle = this.campaignLibraryNavigationService.gatherCampaignStatisticsBundleByMilestone();
            mav.addObject("dashboardModel", (Object)csbundle);
            boolean allowsSettled = csbundle.getCampaignTestCaseStatusStatistics().getNbSettled() > 0;
            boolean allowsUntestable = csbundle.getCampaignTestCaseStatusStatistics().getNbUntestable() > 0;
            mav.addObject("allowsSettled", (Object)allowsSettled);
            mav.addObject("allowsUntestable", (Object)allowsUntestable);
        }
        return mav;
    }

    @RequestMapping(value={"/dashboard-milestones"}, method={RequestMethod.GET}, produces={"text/html"}, params={"printmode"})
    public ModelAndView getDashboard(Model model, @RequestParam(value="printmode", defaultValue="false") Boolean printmode) {
        ModelAndView mav = this.getDashboard(model);
        mav.setViewName("page/campaign-workspace/show-campaign-milestone-dashboard");
        mav.addObject("printmode", (Object)printmode);
        return mav;
    }

    private File exportToFile(CampaignExportCSVModel model) {
        try (PrintWriter writer = null;){
            File file = File.createTempFile("export-requirement", "tmp");
            file.deleteOnExit();
            writer = new PrintWriter(file);
            CampaignExportCSVModel.Row header = model.getHeader();
            writer.write(String.valueOf(header.toString()) + "\n");
            Iterator iterator = model.dataIterator();
            while (iterator.hasNext()) {
                CampaignExportCSVModel.Row datarow = (CampaignExportCSVModel.Row)iterator.next();
                String cleanRowValue = HTMLCleanupUtils.htmlToText(datarow.toString()).replaceAll("\\n", "").replaceAll("\\r", "");
                writer.write(String.valueOf(cleanRowValue) + "\n");
            }
            writer.close();
            File file2 = file;
            return file2;
        }
    }

    @Override
    protected WorkspaceDisplayService workspaceDisplayService() {
        return this.workspaceDisplayService;
    }

    private class ShortCutPermissionEvaluator
    implements PermissionEvaluationService {
        private Boolean hasRole;
        private Map<String, Boolean> perms = new HashMap<String, Boolean>();
        private Map<String[], Map<String, Boolean>> hasRolePerms = new HashMap<String[], Map<String, Boolean>>();

        private ShortCutPermissionEvaluator() {
        }

        public boolean hasRoleOrPermissionOnObject(String role, String permission, Object object) {
            return this.hasRole(role) || this.hasPermissionOnObject(permission, object);
        }

        public boolean hasPermissionOnObject(String permission, Object entity) {
            Boolean res = this.perms.get(permission);
            if (res == null) {
                res = CampaignLibraryNavigationController.this.permissionEvaluator.hasPermissionOnObject(permission, entity);
                this.perms.put(permission, res);
            }
            return res;
        }

        public boolean hasRoleOrPermissionOnObject(String role, String permission, Long entityId, String entityClassName) {
            return CampaignLibraryNavigationController.this.permissionEvaluator.hasRoleOrPermissionOnObject(role, permission, entityId, entityClassName);
        }

        public boolean canRead(Object object) {
            return CampaignLibraryNavigationController.this.permissionEvaluator.canRead(object);
        }

        public boolean hasMoreThanRead(Object object) {
            return CampaignLibraryNavigationController.this.permissionEvaluator.hasMoreThanRead(object);
        }

        public boolean hasRole(String role) {
            if (this.hasRole == null) {
                this.hasRole = CampaignLibraryNavigationController.this.permissionEvaluator.hasRole(role);
            }
            return this.hasRole;
        }

        public boolean hasPermissionOnObject(String permission, Long entityId, String entityClassName) {
            return CampaignLibraryNavigationController.this.permissionEvaluator.hasPermissionOnObject(permission, entityId, entityClassName);
        }

        public Map<String, Boolean> hasRoleOrPermissionsOnObject(String role, String[] permissions, Object entity) {
            Map res = this.hasRolePerms.get(permissions);
            if (res == null) {
                res = CampaignLibraryNavigationController.this.permissionEvaluator.hasRoleOrPermissionsOnObject(role, permissions, entity);
                this.hasRolePerms.put(permissions, res);
            }
            return res;
        }

        public Collection<String> permissionsOn(@NotNull String className, long id) {
            return CampaignLibraryNavigationController.this.permissionEvaluator.permissionsOn(className, id);
        }
    }
}

