/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.Set;
import javax.inject.Inject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;

@Controller
@RequestMapping(value={"/campaign-libraries/{libraryId}"})
public class CampaignLibraryModificationController {
    @Inject
    private CampaignLibraryNavigationService campaignLibraryNavigationService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;

    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showCampaignLibrary(@PathVariable long libraryId) {
        CampaignLibrary lib = (CampaignLibrary)this.campaignLibraryNavigationService.findLibrary(libraryId);
        ModelAndView mav = new ModelAndView("fragment/libraries/library");
        Set<Attachment> attachments = this.attachmentsHelper.findAttachments((AttachmentHolder)lib);
        mav.addObject("library", (Object)lib);
        mav.addObject("attachments", attachments);
        mav.addObject("workspaceName", (Object)"campaign");
        return mav;
    }
}

