/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.HashMap;
import java.util.Map;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.ValidationUtils;
import org.springframework.validation.Validator;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.customfield.RawValue;
import org.squashtest.tm.service.internal.dto.RawValueModel;

public class CampaignFormModel {
    private String name;
    private String reference;
    private String description;
    private static final String MESSAGE_NOT_BLANK = "message.notBlank";
    private RawValueModel.RawValueModelMap customFields = new RawValueModel.RawValueModelMap();

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getReference() {
        return this.reference;
    }

    public void setReference(String reference) {
        this.reference = reference;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public RawValueModel.RawValueModelMap getCustomFields() {
        return this.customFields;
    }

    public void setCustomFields(RawValueModel.RawValueModelMap customFields) {
        this.customFields = customFields;
    }

    public Campaign getCampaign() {
        Campaign newCampaign = new Campaign();
        newCampaign.setName(this.name);
        newCampaign.setDescription(this.description);
        newCampaign.setReference(this.reference);
        return newCampaign;
    }

    @JsonIgnore
    public Map<Long, RawValue> getCufs() {
        HashMap<Long, RawValue> cufs = new HashMap<Long, RawValue>(this.customFields.size());
        for (Map.Entry entry : this.customFields.entrySet()) {
            cufs.put((Long)entry.getKey(), ((RawValueModel)entry.getValue()).toRawValue());
        }
        return cufs;
    }

    public static class CampaignFormModelValidator
    implements Validator {
        private MessageSource messageSource;

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public CampaignFormModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> clazz) {
            return clazz.equals(CampaignFormModel.class);
        }

        public void validate(Object target, Errors errors) {
            String notBlank = this.messageSource.getMessage(CampaignFormModel.MESSAGE_NOT_BLANK, null, LocaleContextHolder.getLocale());
            CampaignFormModel model = (CampaignFormModel)target;
            ValidationUtils.rejectIfEmptyOrWhitespace((Errors)errors, (String)"name", (String)CampaignFormModel.MESSAGE_NOT_BLANK, (String)notBlank);
            for (Map.Entry entry : model.getCustomFields().entrySet()) {
                RawValueModel value = (RawValueModel)entry.getValue();
                if (!value.isEmpty()) continue;
                errors.rejectValue("customFields[" + entry.getKey() + "]", CampaignFormModel.MESSAGE_NOT_BLANK, notBlank);
            }
        }
    }
}

