/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import javax.inject.Inject;
import javax.inject.Named;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.service.campaign.CampaignModificationService;
import org.squashtest.tm.service.library.FolderModificationService;
import org.squashtest.tm.service.statistics.campaign.ManyCampaignStatisticsBundle;
import org.squashtest.tm.web.internal.controller.generic.FolderModificationController;

@Controller
@RequestMapping(value={"/campaign-folders/{folderId}"})
public class CampaignFolderModificationController
extends FolderModificationController<CampaignFolder> {
    private FolderModificationService<CampaignFolder> folderModificationService;
    @Inject
    private CampaignModificationService campaignModificationService;

    @Override
    protected FolderModificationService<CampaignFolder> getFolderModificationService() {
        return this.folderModificationService;
    }

    @Inject
    @Named(value="squashtest.tm.service.CampaignFolderModificationService")
    public final void setFolderModificationService(FolderModificationService<CampaignFolder> folderModificationService) {
        this.folderModificationService = folderModificationService;
    }

    @Override
    @RequestMapping(method={RequestMethod.GET})
    public final ModelAndView showFolder(@PathVariable long folderId, HttpServletRequest request) {
        CampaignFolder folder = (CampaignFolder)this.folderModificationService.findFolder(folderId);
        ModelAndView mav = super.showFolder(folderId, request);
        mav.setViewName("fragment/campaigns/campaign-folder");
        this.populateOptionalExecutionStatuses(folder, mav);
        return mav;
    }

    @Override
    protected String getWorkspaceName() {
        return "campaign";
    }

    @ResponseBody
    @RequestMapping(value={"/dashboard-statistics"}, method={RequestMethod.GET}, produces={"application/json"})
    public ManyCampaignStatisticsBundle getStatisticsAsJson(@PathVariable(value="folderId") long folderId) {
        return this.campaignModificationService.gatherFolderStatisticsBundle(Long.valueOf(folderId));
    }

    @RequestMapping(value={"/dashboard"}, method={RequestMethod.GET}, produces={"text/html"}, params={"printmode"})
    public ModelAndView getDashboard(Model model, @PathVariable(value="folderId") long folderId, @RequestParam(value="printmode", defaultValue="false") Boolean printmode) {
        CampaignFolder folder = (CampaignFolder)this.folderModificationService.findFolder(folderId);
        ManyCampaignStatisticsBundle bundle = this.campaignModificationService.gatherFolderStatisticsBundle(Long.valueOf(folderId));
        ModelAndView mav = new ModelAndView("page/campaign-workspace/show-campaign-folder-dashboard");
        mav.addObject("folder", (Object)folder);
        mav.addObject("dashboardModel", (Object)bundle);
        mav.addObject("printmode", (Object)printmode);
        this.populateOptionalExecutionStatuses(folder, model);
        return mav;
    }

    private void populateOptionalExecutionStatuses(CampaignFolder folder, Model model) {
        model.addAttribute("allowsSettled", (Object)folder.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addAttribute("allowsUntestable", (Object)folder.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
    }

    private void populateOptionalExecutionStatuses(CampaignFolder folder, ModelAndView model) {
        model.addObject("allowsSettled", (Object)folder.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.SETTLED));
        model.addObject("allowsUntestable", (Object)folder.getProject().getCampaignLibrary().allowsStatus(ExecutionStatus.UNTESTABLE));
    }
}

