/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.campaign;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.squashtest.tm.service.internal.dto.AutomatedSuiteDto;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class AutomatedSuiteTableModelHelper
extends DataTableModelBuilder<AutomatedSuiteDto> {
    private final InternationalizationHelper i18nHelper;
    private final Locale locale;

    public AutomatedSuiteTableModelHelper(@NotNull Locale locale, @NotNull InternationalizationHelper i18nHelper) {
        this.locale = locale;
        this.i18nHelper = i18nHelper;
    }

    protected Map<String, Object> buildItemData(AutomatedSuiteDto suite) {
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("entity-index", this.getCurrentIndex());
        res.put("uuid", suite.getSuiteId());
        res.put("created-on", this.i18nHelper.localizeDate(suite.getCreatedOn(), this.locale));
        res.put("created-by", HTMLCleanupUtils.escapeOrDefault(suite.getCreatedBy(), null));
        res.put("last-modified-on", this.i18nHelper.localizeDate(suite.getLastModifiedOn(), this.locale));
        res.put("last-modified-by", HTMLCleanupUtils.escapeOrDefault(suite.getLastModifiedBy(), null));
        res.put("status", suite.getExecutionStatus().getCanonicalStatus());
        res.put("has-executions", suite.isHasExecutions());
        res.put("result-urls", suite.getUrlList());
        res.put("attachment-list-id", suite.getAttachmentListId());
        res.put("attachment-list", suite.getAttachmentList());
        return res;
    }
}

