/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.bugtracker;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.domain.servers.AuthenticationPolicy;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.ThirdPartyServer;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.bugtracker.BugTrackerModificationService;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.service.servers.ServerAuthConfiguration;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementBean;
import org.squashtest.tm.web.internal.controller.thirdpartyserver.ThirdPartyServerCredentialsManagementHelper;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/bugtracker/{bugtrackerId}"})
public class BugTrackerModificationController {
    private static final String BUGTRACKER_ID = "bugtrackerId";
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerModificationController.class);
    @Inject
    private BugTrackerModificationService bugtrackerModificationService;
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private BugTrackerFinderService bugtrackerFinder;
    @Inject
    private ThirdPartyServerCredentialsManagementHelper credentialsBeanHelper;

    @RequestMapping(value={"/info"}, method={RequestMethod.GET})
    public ModelAndView getProjectInfos(@PathVariable long bugtrackerId, Locale locale) {
        BugTracker bugTracker = this.bugtrackerFinder.findById(bugtrackerId);
        String jsonBugtrackerKinds = this.findJsonBugTrackerKinds();
        ThirdPartyServerCredentialsManagementBean authBean = this.makeAuthBean(bugTracker, locale);
        String asteriskedPassword = BugTrackerControllerHelper.retrieveAsteriskedPassword(bugTracker.getAuthenticationProtocol(), authBean.getCredentials());
        ModelAndView mav = new ModelAndView("page/bugtrackers/bugtracker-info");
        mav.addObject("bugtracker", (Object)bugTracker);
        mav.addObject("asteriskedPassword", (Object)asteriskedPassword);
        mav.addObject("bugtrackerKinds", (Object)jsonBugtrackerKinds);
        mav.addObject("authConf", (Object)authBean);
        return mav;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"newName"})
    @ResponseBody
    public Object changeName(@PathVariable long bugtrackerId, @RequestParam String newName) {
        this.bugtrackerModificationService.changeName(bugtrackerId, newName);
        LOGGER.debug("BugTracker modification : change bugtracker {} name = {}", (Object)bugtrackerId, (Object)newName);
        return new RenameModel(newName);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=bugtracker-url", "value"})
    @ResponseBody
    public String changeUrl(@PathVariable long bugtrackerId, @RequestParam(value="value") String newUrl) {
        this.bugtrackerModificationService.changeUrl(bugtrackerId, newUrl);
        LOGGER.debug("BugTracker modification : change bugtracker {} url = {}", (Object)bugtrackerId, (Object)newUrl);
        return HTMLCleanupUtils.cleanHtml(newUrl);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"isIframeFriendly"})
    @ResponseBody
    public Object changeIframeFriendly(@PathVariable long bugtrackerId, @RequestParam boolean isIframeFriendly) {
        this.bugtrackerModificationService.changeIframeFriendly(bugtrackerId, isIframeFriendly);
        LOGGER.debug("BugTracker modification : change bugtracker {} is iframe-friendly = {}", (Object)bugtrackerId, (Object)isIframeFriendly);
        return new IframeFriendly(isIframeFriendly);
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=bugtracker-kind", "value"})
    @ResponseBody
    public String changeKind(@RequestParam(value="value") String kind, @PathVariable long bugtrackerId) {
        LOGGER.debug("BugTracker modification : change bugtracker {} kind = {}", (Object)bugtrackerId, (Object)kind);
        this.bugtrackerModificationService.changeKind(bugtrackerId, kind);
        return HTMLCleanupUtils.cleanHtml(kind);
    }

    @RequestMapping(value={"/authentication-policy"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeAuthPolicy(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestParam(value="value") AuthenticationPolicy policy) {
        this.bugtrackerModificationService.changeAuthenticationPolicy(bugtrackerId, policy);
    }

    @RequestMapping(value={"/authentication-protocol"}, method={RequestMethod.POST}, params={"value"})
    @ResponseBody
    public void changeAuthProtocol(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestParam(value="value") AuthenticationProtocol protocol) {
        this.bugtrackerModificationService.changeAuthenticationProtocol(bugtrackerId, protocol);
    }

    @RequestMapping(value={"/authentication-protocol/configuration"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void saveAuthConfiguration(@PathVariable(value="bugtrackerId") long bugtrackerId, @Valid @RequestBody ServerAuthConfiguration configuration) {
        this.bugtrackerModificationService.storeAuthConfiguration(bugtrackerId, configuration);
    }

    @RequestMapping(value={"/credentials/validator"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void testCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestBody ManageableCredentials credentials) {
        try {
            this.bugtrackerModificationService.testCredentials(bugtrackerId, credentials);
        }
        catch (BugTrackerNoCredentialsException ex) {
            LOGGER.debug("server-app credentials test failed : ", (Throwable)ex);
            String message = this.i18nHelper.internationalize("thirdpartyserver.admin.messages.testcreds.fail", LocaleContextHolder.getLocale());
            throw new BugTrackerNoCredentialsException(message, (Throwable)ex);
        }
    }

    @RequestMapping(value={"/credentials"}, method={RequestMethod.POST}, consumes={"application/json"})
    @ResponseBody
    public void storeCredentials(@PathVariable(value="bugtrackerId") long bugtrackerId, @RequestBody ManageableCredentials credentials) {
        this.bugtrackerModificationService.storeCredentials(bugtrackerId, credentials);
    }

    private String findJsonBugTrackerKinds() {
        Set bugtrackerKinds = this.bugtrackerFinder.findBugTrackerKinds();
        HashMap<String, String> mapKinds = new HashMap<String, String>(bugtrackerKinds.size());
        for (String kind : bugtrackerKinds) {
            kind = HTMLCleanupUtils.cleanHtml(kind);
            mapKinds.put(kind, kind);
        }
        return JsonHelper.serialize(mapKinds);
    }

    private ThirdPartyServerCredentialsManagementBean makeAuthBean(BugTracker bugTracker, Locale locale) {
        ThirdPartyServerCredentialsManagementBean bean = this.credentialsBeanHelper.initializeFor((ThirdPartyServer)bugTracker, locale);
        AuthenticationProtocol[] availableProtos = this.bugtrackerModificationService.getSupportedProtocols(bugTracker);
        bean.setAvailableProtos(Arrays.asList(availableProtos));
        return bean;
    }

    private static final class IframeFriendly {
        private Boolean isIframeFriendly;

        private IframeFriendly(boolean iframeFriendly) {
            this.isIframeFriendly = iframeFriendly;
        }

        public Boolean isIframeFriendly() {
            return this.isIframeFriendly;
        }
    }
}

