/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.bugtracker;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.bugtracker.definition.RemotePriority;
import org.squashtest.tm.bugtracker.definition.RemoteStatus;
import org.squashtest.tm.bugtracker.definition.RemoteUser;
import org.squashtest.tm.core.foundation.lang.Wrapped;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueOwnership;
import org.squashtest.tm.domain.bugtracker.RemoteIssueDecorator;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.servers.AuthenticationProtocol;
import org.squashtest.tm.domain.servers.BasicAuthenticationCredentials;
import org.squashtest.tm.domain.servers.TokenAuthCredentials;
import org.squashtest.tm.domain.testcase.KeywordTestCase;
import org.squashtest.tm.domain.testcase.ScriptedTestCase;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.domain.testcase.TestCaseVisitor;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.RequirementVersionIssueOwnership;
import org.squashtest.tm.service.internal.servers.UserOAuth1aToken;
import org.squashtest.tm.service.servers.ManageableCredentials;
import org.squashtest.tm.web.internal.controller.campaign.TestSuiteHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Component
public final class BugTrackerControllerHelper {
    private static final String ISSUE_URL = "issue-url";
    private static final String BT_PROJECT = "BtProject";
    private static final String DESCRIPTION_STEPS_SEPARATION = "\n\n\n";
    private static final String ASTERISK_LABEL = "*";
    @Inject
    private BugTrackersLocalService service;
    @Inject
    private InternationalizationHelper source;
    private static final String REMOTE_ID = "remote-id";
    private static final String SUMMARY = "summary";
    private static final String PRIORITY = "priority";

    private BugTrackerControllerHelper() {
    }

    public static String getAdditionalInformation(ExecutionStep buggedStep, final Locale locale, final MessageSource messageSource) {
        Execution execution = buggedStep.getExecution();
        final List executionSteps = execution.getSteps();
        final int totalStepNumber = executionSteps.size();
        final long buggedStepId = buggedStep.getId();
        final Wrapped additionalInformation = new Wrapped();
        TestCaseVisitor testCaseVisitor = new TestCaseVisitor(){

            public void visit(TestCase testCase) {
                additionalInformation.setValue((Object)BugTrackerControllerHelper.getAdditionalInformationForStandardTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource));
            }

            public void visit(KeywordTestCase keywordTestCase) {
                additionalInformation.setValue((Object)BugTrackerControllerHelper.getAdditionalInformationForKeywordTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource));
            }

            public void visit(ScriptedTestCase scriptedTestCase) {
                additionalInformation.setValue((Object)BugTrackerControllerHelper.getAdditionalInformationForScriptedTestCase(executionSteps, buggedStepId, totalStepNumber, locale, messageSource));
            }
        };
        execution.getReferencedTestCase().accept(testCaseVisitor);
        return (String)additionalInformation.getValue();
    }

    private static String getAdditionalInformationForStandardTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String actionText = HTMLCleanupUtils.htmlToText(step.getAction());
            String expectedResult = HTMLCleanupUtils.htmlToText(step.getExpectedResult());
            builder.append(messageSource.getMessage("issue.default.additionalInformation.action", null, locale));
            builder.append(actionText);
            builder.append(messageSource.getMessage("issue.default.additionalInformation.expectedResult", null, locale));
            builder.append(expectedResult);
            builder.append(DESCRIPTION_STEPS_SEPARATION);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    private static String getAdditionalInformationForKeywordTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String actionText = HTMLCleanupUtils.htmlToText(step.getAction());
            builder.append(messageSource.getMessage("issue.default.additionalInformation.action", null, locale));
            builder.append(actionText);
            builder.append(DESCRIPTION_STEPS_SEPARATION);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    private static String getAdditionalInformationForScriptedTestCase(List<ExecutionStep> executionSteps, long buggedStepId, int totalStepNumber, Locale locale, MessageSource messageSource) {
        StringBuilder builder = new StringBuilder();
        for (ExecutionStep step : executionSteps) {
            BugTrackerControllerHelper.appendStepTitle(locale, messageSource, totalStepNumber, builder, step);
            String scriptTextWithCarriageReturns = step.getAction().replaceAll("</br>", "<br/>");
            String scriptText = HTMLCleanupUtils.htmlToText(scriptTextWithCarriageReturns);
            builder.append(messageSource.getMessage("issue.default.additionalInformation.script", null, locale));
            builder.append(scriptText);
            builder.append(DESCRIPTION_STEPS_SEPARATION);
            if (step.getId().equals(buggedStepId)) break;
        }
        return builder.toString();
    }

    private static void appendStepTitle(Locale locale, MessageSource messageSource, int totalStepNumber, StringBuilder builder, ExecutionStep step) {
        builder.append("=============================================\n|    ");
        builder.append(messageSource.getMessage("issue.default.additionalInformation.step", null, locale));
        builder.append(" ");
        builder.append(step.getExecutionStepOrder() + 1);
        builder.append("/");
        builder.append(totalStepNumber);
        builder.append("\n=============================================\n");
    }

    public static String getDefaultDescription(Execution execution, Locale locale, MessageSource messageSource, String executionUrl) {
        StringBuilder description = new StringBuilder();
        BugTrackerControllerHelper.appendTestCaseDesc(execution.getReferencedTestCase(), description, locale, messageSource);
        BugTrackerControllerHelper.appendExecutionDesc(description, locale, messageSource, executionUrl);
        BugTrackerControllerHelper.appendDescHeader(description, locale, messageSource);
        return description.toString();
    }

    public static String getDefaultDescription(ExecutionStep step, Locale locale, MessageSource messageSource, String executionUrl) {
        StringBuilder description = new StringBuilder();
        BugTrackerControllerHelper.appendTestCaseDesc(step.getExecution().getReferencedTestCase(), description, locale, messageSource);
        BugTrackerControllerHelper.appendExecutionDesc(description, locale, messageSource, executionUrl);
        BugTrackerControllerHelper.appendStepDesc(step, description, locale, messageSource);
        BugTrackerControllerHelper.appendDescHeader(description, locale, messageSource);
        return description.toString();
    }

    public static String buildExecutionUrl(HttpServletRequest request, Execution execution) {
        StringBuilder requestUrl = new StringBuilder(request.getScheme());
        requestUrl.append("://").append(request.getServerName()).append(':').append(request.getServerPort()).append(request.getContextPath()).append("/executions/").append(execution.getId());
        return HTMLCleanupUtils.cleanHtml(requestUrl.toString());
    }

    private static void appendDescHeader(StringBuilder description, Locale locale, MessageSource messageSource) {
        description.append("\n# ");
        description.append(messageSource.getMessage("issue.default.description.description", null, locale));
        description.append(" :\n");
    }

    private static void appendStepDesc(ExecutionStep step, StringBuilder description, Locale locale, MessageSource messageSource) {
        description.append("# ");
        description.append(messageSource.getMessage("issue.default.description.concernedStep", null, locale));
        description.append(": ");
        description.append(step.getExecutionStepOrder() + 1);
        description.append("/");
        description.append(step.getExecution().getSteps().size());
        description.append("\n");
    }

    private static void appendExecutionDesc(StringBuilder description, Locale locale, MessageSource messageSource, String executionUrl) {
        description.append("# ");
        description.append(messageSource.getMessage("issue.default.description.execution", null, locale));
        description.append(": ");
        description.append(executionUrl);
        description.append("\n");
    }

    private static void appendTestCaseDesc(TestCase testCase, StringBuilder description, Locale locale, MessageSource messageSource) {
        if (testCase != null) {
            description.append("# ");
            description.append(messageSource.getMessage("issue.default.description.testCase", null, locale));
            description.append(": [");
            description.append(HTMLCleanupUtils.cleanAndUnescapeHTML(testCase.getReference()));
            description.append("] ");
            description.append(HTMLCleanupUtils.cleanAndUnescapeHTML(testCase.getName()));
            description.append("\n");
        }
    }

    public static String retrieveAsteriskedPassword(AuthenticationProtocol bugtrackerAuthProtocol, ManageableCredentials credentials) {
        String result = "";
        if (credentials != null) {
            switch (bugtrackerAuthProtocol) {
                case BASIC_AUTH: {
                    result = BugTrackerControllerHelper.retrieveAsteriskedBasicAuthPassword(credentials);
                    break;
                }
                case OAUTH_1A: {
                    result = BugTrackerControllerHelper.retrieveAsteriskedOAuth1ASecretToken(credentials);
                    break;
                }
                case TOKEN_AUTH: {
                    result = BugTrackerControllerHelper.retrieveAsteriskedTokenAuthToken(credentials);
                    break;
                }
            }
        }
        return result;
    }

    private static String retrieveAsteriskedBasicAuthPassword(ManageableCredentials credentials) {
        BasicAuthenticationCredentials basicAuthCreds = (BasicAuthenticationCredentials)credentials;
        return StringUtils.repeat((String)ASTERISK_LABEL, (int)basicAuthCreds.getPassword().length);
    }

    private static String retrieveAsteriskedOAuth1ASecretToken(ManageableCredentials credentials) {
        UserOAuth1aToken oAuth1aCredentials = (UserOAuth1aToken)credentials;
        return StringUtils.repeat((String)ASTERISK_LABEL, (int)oAuth1aCredentials.getTokenSecret().length());
    }

    private static String retrieveAsteriskedTokenAuthToken(ManageableCredentials credentials) {
        TokenAuthCredentials tokenAuthCreds = (TokenAuthCredentials)credentials;
        return StringUtils.repeat((String)ASTERISK_LABEL, (int)tokenAuthCreds.getToken().length());
    }

    public DataTableModelBuilder<RequirementVersionIssueOwnership<RemoteIssueDecorator>> createModelBuilderForRequirementVersion() {
        RequirementVersionIssuesTableModel builder = new RequirementVersionIssuesTableModel();
        return builder;
    }

    DataTableModelBuilder<IssueOwnership<RemoteIssueDecorator>> createModelBuilderFor(String entityType) {
        DataTableModelBuilder builder;
        switch (entityType) {
            case "test-case": {
                builder = new TestCaseIssuesTableModel();
                break;
            }
            case "iteration": 
            case "campaign": 
            case "test-suite": 
            case "campaign-folder": {
                builder = new IterationIssuesTableModel();
                break;
            }
            case "execution": {
                builder = new ExecutionIssuesTableModel();
                break;
            }
            case "execution-step": {
                builder = new StepIssuesTableModel();
                break;
            }
            default: {
                throw new IllegalArgumentException("BugTrackerController : cannot fetch issues for unknown entity type '" + entityType + "'");
            }
        }
        return builder;
    }

    private static String findAssignee(RemoteIssue issue) {
        String assignee = "";
        RemoteUser remoteUser = issue.getAssignee();
        if (remoteUser != null) {
            assignee = remoteUser.getName();
        }
        return HTMLCleanupUtils.cleanHtml(assignee);
    }

    private static String findStatus(RemoteIssue issue) {
        String status = "";
        RemoteStatus remoteStatus = issue.getStatus();
        if (remoteStatus != null) {
            status = remoteStatus.getName();
        }
        return status;
    }

    private static String findPriority(RemoteIssue issue) {
        String priority = "";
        RemotePriority remotePriority = issue.getPriority();
        if (remotePriority != null) {
            priority = remotePriority.getName();
        }
        return HTMLCleanupUtils.cleanHtml(priority);
    }

    public static String findOwnerDescForTestCase(IssueDetector bugged, MessageSource messageSource, Locale locale) {
        TestCaseModelOwnershipNamebuilder nameBuilder = new TestCaseModelOwnershipNamebuilder();
        nameBuilder.setMessageSource(messageSource);
        nameBuilder.setLocale(locale);
        return nameBuilder.buildName(bugged);
    }

    private static String findTestSuiteNameList(Execution execution) {
        List buggedSuites = execution.getTestPlan().getTestSuites();
        return HTMLCleanupUtils.cleanHtml(TestSuiteHelper.buildEllipsedSuiteNameList(buggedSuites, 20));
    }

    private static String findIterationName(Execution execution) {
        Iteration iteration = execution.getTestPlan().getIteration();
        String iterationName = "";
        if (iteration != null) {
            iterationName = HTMLCleanupUtils.cleanHtml(iteration.getName());
        }
        return iterationName;
    }

    private final class ExecutionIssuesTableModel
    extends DataTableModelBuilder<IssueOwnership<RemoteIssueDecorator>> {
        private IssueOwnershipNameBuilder nameBuilder = new ExecutionModelOwnershipNamebuilder();

        public ExecutionIssuesTableModel() {
            this.nameBuilder.setMessageSource(BugTrackerControllerHelper.this.source);
            this.nameBuilder.setLocale(LocaleContextHolder.getLocale());
        }

        public Map<String, Object> buildItemData(IssueOwnership<RemoteIssueDecorator> ownership) {
            RemoteIssueDecorator issue = (RemoteIssueDecorator)ownership.getIssue();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(BugTrackerControllerHelper.ISSUE_URL, HTMLCleanupUtils.cleanHtml(BugTrackerControllerHelper.this.service.getIssueUrl(issue.getId(), ownership.getOwner().getBugTracker()).toExternalForm()));
            result.put(BugTrackerControllerHelper.REMOTE_ID, issue.getId());
            result.put(BugTrackerControllerHelper.SUMMARY, HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(issue.getSummary())));
            result.put(BugTrackerControllerHelper.PRIORITY, BugTrackerControllerHelper.findPriority((RemoteIssue)issue));
            result.put("status", BugTrackerControllerHelper.findStatus((RemoteIssue)issue));
            result.put("assignee", BugTrackerControllerHelper.findAssignee((RemoteIssue)issue));
            result.put("owner", this.nameBuilder.buildName(ownership.getOwner()));
            result.put("empty-delete-holder", "");
            result.put("local-id", issue.getIssueId());
            result.put(BugTrackerControllerHelper.BT_PROJECT, HTMLCleanupUtils.cleanHtml(issue.getProject().getName()));
            return result;
        }
    }

    private static final class ExecutionModelOwnershipNamebuilder
    extends IssueOwnershipAbstractNameBuilder {
        private ExecutionModelOwnershipNamebuilder() {
        }

        @Override
        public String buildExecName(Execution bugged) {
            if (bugged == null) {
                return "";
            }
            return bugged.getName();
        }

        @Override
        String buildStepName(ExecutionStep bugged) {
            Integer index = bugged.getExecutionStepOrder() + 1;
            return this.messageSource.getMessage("squashtm.generic.hierarchy.execution.step.name", new Object[]{index}, this.locale);
        }
    }

    private static abstract class IssueOwnershipAbstractNameBuilder
    implements IssueOwnershipNameBuilder {
        protected Locale locale;
        protected MessageSource messageSource;

        private IssueOwnershipAbstractNameBuilder() {
        }

        @Override
        public void setLocale(Locale locale) {
            this.locale = locale;
        }

        @Override
        public void setMessageSource(MessageSource source) {
            this.messageSource = source;
        }

        @Override
        public String buildName(IssueDetector bugged) {
            String name = "this is clearly a bug";
            if (bugged instanceof ExecutionStep) {
                ExecutionStep step = (ExecutionStep)bugged;
                name = this.buildStepName(step);
            } else if (bugged instanceof Execution) {
                Execution exec = (Execution)bugged;
                name = this.buildExecName(exec);
            }
            return HTMLCleanupUtils.cleanHtml(name);
        }

        @Override
        public String buildURLPath(IssueDetector bugged) {
            Execution exec = bugged instanceof ExecutionStep ? ((ExecutionStep)bugged).getExecution() : (Execution)bugged;
            String path = "/executions/" + exec.getId();
            return HTMLCleanupUtils.cleanHtml(path);
        }

        abstract String buildStepName(ExecutionStep var1);

        abstract String buildExecName(Execution var1);
    }

    private static interface IssueOwnershipNameBuilder {
        public void setMessageSource(MessageSource var1);

        public void setLocale(Locale var1);

        public String buildName(IssueDetector var1);

        public String buildURLPath(IssueDetector var1);
    }

    private final class IterationIssuesTableModel
    extends DataTableModelBuilder<IssueOwnership<RemoteIssueDecorator>> {
        private IssueOwnershipNameBuilder nameBuilder = new IterationModelOwnershipNamebuilder();

        public IterationIssuesTableModel() {
            this.nameBuilder.setMessageSource(BugTrackerControllerHelper.this.source);
            this.nameBuilder.setLocale(LocaleContextHolder.getLocale());
        }

        public Map<String, String> buildItemData(IssueOwnership<RemoteIssueDecorator> ownership) {
            HashMap<String, String> result = new HashMap<String, String>();
            RemoteIssue issue = (RemoteIssue)ownership.getIssue();
            String strUrl = HTMLCleanupUtils.cleanHtml(BugTrackerControllerHelper.this.service.getIssueUrl(((RemoteIssueDecorator)ownership.getIssue()).getId(), ownership.getOwner().getBugTracker()).toExternalForm());
            String ownerName = this.nameBuilder.buildName(ownership.getOwner());
            String ownerPath = this.nameBuilder.buildURLPath(ownership.getOwner());
            result.put(BugTrackerControllerHelper.ISSUE_URL, strUrl);
            result.put("issue-id", issue.getId());
            result.put("issue-summary", HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(issue.getSummary())));
            result.put("issue-priority", BugTrackerControllerHelper.findPriority(issue));
            result.put("issue-status", BugTrackerControllerHelper.findStatus(issue));
            result.put("issue-assignee", BugTrackerControllerHelper.findAssignee(issue));
            result.put("issue-owner", ownerName);
            result.put("issue-owner-url", ownerPath);
            result.put(BugTrackerControllerHelper.BT_PROJECT, HTMLCleanupUtils.cleanHtml(issue.getProject().getName()));
            return result;
        }
    }

    private static final class IterationModelOwnershipNamebuilder
    extends IssueOwnershipAbstractNameBuilder {
        private IterationModelOwnershipNamebuilder() {
        }

        @Override
        String buildExecName(Execution bugged) {
            String suiteNameList = BugTrackerControllerHelper.findTestSuiteNameList(bugged);
            if (suiteNameList.isEmpty()) {
                return this.messageSource.getMessage("squashtm.generic.hierarchy.execution.name.noSuite", new Object[]{bugged.getName(), bugged.getExecutionOrder() + 1}, this.locale);
            }
            return this.messageSource.getMessage("squashtm.generic.hierarchy.execution.name", new Object[]{bugged.getName(), suiteNameList, bugged.getExecutionOrder() + 1}, this.locale);
        }

        @Override
        String buildStepName(ExecutionStep executionStep) {
            return this.buildExecName(executionStep.getExecution());
        }
    }

    private final class RequirementVersionIssuesTableModel
    extends DataTableModelBuilder<RequirementVersionIssueOwnership<RemoteIssueDecorator>> {
        private IssueOwnershipNameBuilder nameBuilder = new IterationModelOwnershipNamebuilder();

        public RequirementVersionIssuesTableModel() {
            this.nameBuilder.setMessageSource(BugTrackerControllerHelper.this.source);
            this.nameBuilder.setLocale(LocaleContextHolder.getLocale());
        }

        public Map<String, String> buildItemData(RequirementVersionIssueOwnership<RemoteIssueDecorator> ownership) {
            HashMap<String, String> result = new HashMap<String, String>();
            RemoteIssue issue = (RemoteIssue)ownership.getIssue();
            RequirementVersion requirementVersion = ownership.getRequirementVersion();
            String strUrl = HTMLCleanupUtils.cleanAndUnescapeHTML(BugTrackerControllerHelper.this.service.getIssueUrl(((RemoteIssueDecorator)ownership.getIssue()).getId(), ownership.getOwner().getBugTracker()).toExternalForm());
            String ownerName = this.nameBuilder.buildName(ownership.getOwner());
            String ownerPath = this.nameBuilder.buildURLPath(ownership.getOwner());
            String reqRef = HTMLCleanupUtils.cleanAndUnescapeHTML(requirementVersion.getReference());
            String reqId = String.valueOf(requirementVersion.getRequirement().getId());
            String reqVersionId = String.valueOf(requirementVersion.getId());
            result.put(BugTrackerControllerHelper.ISSUE_URL, strUrl);
            result.put("issue-id", issue.getId());
            result.put("issue-summary", HTMLCleanupUtils.cleanAndUnescapeHTML(issue.getSummary()));
            result.put("issue-priority", BugTrackerControllerHelper.findPriority(issue));
            result.put("issue-status", BugTrackerControllerHelper.findStatus(issue));
            result.put("issue-assignee", BugTrackerControllerHelper.findAssignee(issue));
            result.put("issue-owner", ownerName);
            result.put("issue-owner-url", ownerPath);
            result.put(BugTrackerControllerHelper.BT_PROJECT, HTMLCleanupUtils.cleanAndUnescapeHTML(issue.getProject().getName()));
            result.put("requirement-reference", reqRef);
            result.put("requirement-id", reqId);
            result.put("current-version-id", reqVersionId);
            return result;
        }
    }

    private final class StepIssuesTableModel
    extends DataTableModelBuilder<IssueOwnership<RemoteIssueDecorator>> {
        StepIssuesTableModel() {
        }

        public Map<String, Object> buildItemData(IssueOwnership<RemoteIssueDecorator> ownership) {
            RemoteIssueDecorator issue = (RemoteIssueDecorator)ownership.getIssue();
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put(BugTrackerControllerHelper.ISSUE_URL, HTMLCleanupUtils.cleanHtml(BugTrackerControllerHelper.this.service.getIssueUrl(issue.getId(), ownership.getOwner().getBugTracker()).toExternalForm()));
            result.put(BugTrackerControllerHelper.REMOTE_ID, issue.getId());
            result.put(BugTrackerControllerHelper.SUMMARY, HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(issue.getSummary())));
            result.put(BugTrackerControllerHelper.PRIORITY, BugTrackerControllerHelper.findPriority((RemoteIssue)issue));
            result.put("empty-delete-holder", "");
            result.put("local-id", issue.getIssueId());
            result.put(BugTrackerControllerHelper.BT_PROJECT, HTMLCleanupUtils.cleanHtml(issue.getProject().getName()));
            return result;
        }
    }

    private final class TestCaseIssuesTableModel
    extends DataTableModelBuilder<IssueOwnership<RemoteIssueDecorator>> {
        private IssueOwnershipNameBuilder nameBuilder = new TestCaseModelOwnershipNamebuilder();

        public TestCaseIssuesTableModel() {
            this.nameBuilder.setMessageSource(BugTrackerControllerHelper.this.source);
            this.nameBuilder.setLocale(LocaleContextHolder.getLocale());
        }

        public Map<String, Object> buildItemData(IssueOwnership<RemoteIssueDecorator> ownership) {
            RemoteIssue issue = (RemoteIssue)ownership.getIssue();
            HashMap<String, Object> row = new HashMap<String, Object>();
            String url = HTMLCleanupUtils.cleanHtml(BugTrackerControllerHelper.this.service.getIssueUrl(issue.getId(), ownership.getOwner().getBugTracker()).toExternalForm());
            String issueOwner = this.nameBuilder.buildName(ownership.getOwner());
            row.put("url", url);
            row.put(BugTrackerControllerHelper.REMOTE_ID, issue.getId());
            row.put(BugTrackerControllerHelper.SUMMARY, HtmlUtils.htmlUnescape((String)HTMLCleanupUtils.cleanHtml(issue.getSummary())));
            row.put(BugTrackerControllerHelper.PRIORITY, BugTrackerControllerHelper.findPriority(issue));
            row.put("status", BugTrackerControllerHelper.findStatus(issue));
            row.put("assignee", BugTrackerControllerHelper.findAssignee(issue));
            row.put("execution", issueOwner);
            row.put("execution-id", ownership.getExecution().getId());
            row.put(BugTrackerControllerHelper.BT_PROJECT, HTMLCleanupUtils.cleanHtml(issue.getProject().getName()));
            return row;
        }
    }

    private static final class TestCaseModelOwnershipNamebuilder
    extends IssueOwnershipAbstractNameBuilder {
        private TestCaseModelOwnershipNamebuilder() {
        }

        @Override
        String buildExecName(Execution execution) {
            String iterationName = BugTrackerControllerHelper.findIterationName(execution);
            String suiteNameList = BugTrackerControllerHelper.findTestSuiteNameList(execution);
            if (suiteNameList.isEmpty()) {
                return this.messageSource.getMessage("squashtm.test-case.hierarchy.execution.name.noSuite", new Object[]{iterationName, execution.getExecutionOrder() + 1}, this.locale);
            }
            return this.messageSource.getMessage("squashtm.test-case.hierarchy.execution.name", new Object[]{iterationName, suiteNameList, execution.getExecutionOrder() + 1}, this.locale);
        }

        @Override
        String buildStepName(ExecutionStep executionStep) {
            return this.buildExecName(executionStep.getExecution());
        }
    }
}

