/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.bugtracker;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.csp.core.bugtracker.core.BugTrackerNoCredentialsException;
import org.squashtest.csp.core.bugtracker.domain.BTIssue;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.csp.core.bugtracker.spi.BugTrackerInterfaceDescriptor;
import org.squashtest.tm.bugtracker.advanceddomain.AdvancedIssue;
import org.squashtest.tm.bugtracker.advanceddomain.DelegateCommand;
import org.squashtest.tm.bugtracker.definition.Attachment;
import org.squashtest.tm.bugtracker.definition.RemoteIssue;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.Paging;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagingBackedPagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.SortOrder;
import org.squashtest.tm.core.foundation.collection.SpringPaginationUtils;
import org.squashtest.tm.core.foundation.exception.NullArgumentException;
import org.squashtest.tm.domain.Identified;
import org.squashtest.tm.domain.bugtracker.IssueDetector;
import org.squashtest.tm.domain.bugtracker.IssueOwnership;
import org.squashtest.tm.domain.bugtracker.RemoteIssueDecorator;
import org.squashtest.tm.domain.campaign.Campaign;
import org.squashtest.tm.domain.campaign.CampaignFolder;
import org.squashtest.tm.domain.campaign.Iteration;
import org.squashtest.tm.domain.campaign.TestSuite;
import org.squashtest.tm.domain.execution.Execution;
import org.squashtest.tm.domain.execution.ExecutionStep;
import org.squashtest.tm.domain.project.Project;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.domain.servers.AuthenticationStatus;
import org.squashtest.tm.domain.testcase.TestCase;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.service.bugtracker.BugTrackersLocalService;
import org.squashtest.tm.service.bugtracker.RequirementVersionIssueOwnership;
import org.squashtest.tm.service.campaign.CampaignFinder;
import org.squashtest.tm.service.campaign.CampaignLibraryNavigationService;
import org.squashtest.tm.service.campaign.IterationFinder;
import org.squashtest.tm.service.campaign.TestSuiteFinder;
import org.squashtest.tm.service.execution.ExecutionFinder;
import org.squashtest.tm.service.internal.bugtracker.BugTrackerConnectorFactory;
import org.squashtest.tm.service.requirement.RequirementVersionManagerService;
import org.squashtest.tm.service.testcase.TestCaseFinder;
import org.squashtest.tm.web.internal.controller.attachment.UploadedData;
import org.squashtest.tm.web.internal.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.internal.controller.bugtracker.BugTrackerControllerHelper;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;
import oslcdomain.OslcIssue;

@Controller
@RequestMapping(value={"/bugtracker"})
public class BugTrackerController {
    private static final String SORTING_DEFAULT_ATTRIBUTE = "Issue.remoteIssueId";
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerController.class);
    @Inject
    private BugTrackerConnectorFactory btFactory;
    @Inject
    private BugTrackersLocalService bugTrackersLocalService;
    @Inject
    private RequirementVersionManagerService requirementVersionManager;
    @Inject
    private CampaignFinder campaignFinder;
    @Inject
    private IterationFinder iterationFinder;
    @Inject
    private TestSuiteFinder testSuiteFinder;
    @Inject
    private ExecutionFinder executionFinder;
    @Inject
    private TestCaseFinder testCaseFinder;
    @Inject
    private BugTrackerManagerService bugTrackerManagerService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private BugTrackerControllerHelper helper;
    @Inject
    private CampaignLibraryNavigationService clnService;
    static final String EXECUTION_STEP_TYPE = "execution-step";
    static final String EXECUTION_TYPE = "execution";
    static final String ITERATION_TYPE = "iteration";
    static final String CAMPAIGN_TYPE = "campaign";
    static final String TEST_SUITE_TYPE = "test-suite";
    static final String TEST_CASE_TYPE = "test-case";
    static final String CAMPAIGN_FOLDER_TYPE = "campaign-folder";
    static final String REQUIREMENT_VERSION_TYPE = "requirement-version";
    private static final String STEP_ID = "stepId";
    private static final String EXEC_ID = "execId";
    private static final String BUGTRACKER_ID = "bugTrackerId";
    private static final String EMPTY_BUGTRACKER_MAV = "fragment/bugtracker/bugtracker-panel-empty";
    private static final String STYLE_ARG = "style";
    private static final String STYLE_TOGGLE = "toggle";
    private static final String MODEL_TABLE_ENTRIES = "tableEntries";
    private static final String MODEL_BUG_TRACKER_STATUS = "bugTrackerStatus";
    private static final String POSTING_NEW_ISSUE_MESSAGE = "BugTrackerController: posting a new issue for execution-step ";

    @InitBinder
    public void initBinder(ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @RequestMapping(value={"{bugtrackerId}/workspace"}, method={RequestMethod.GET})
    public ModelAndView showWorkspace(@PathVariable Long bugtrackerId) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(bugtrackerId.longValue());
        ModelAndView mav = new ModelAndView("page/bugtrackers/bugtracker-workspace");
        mav.addObject("bugtrackerUrl", (Object)HTMLCleanupUtils.cleanHtml(bugTracker.getUrl()));
        return mav;
    }

    @RequestMapping(value={"execution-step/{stepId}"}, method={RequestMethod.GET})
    public ModelAndView getExecStepIssuePanel(@PathVariable Long stepId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle, @RequestParam(value="useDelegatePopup", required=false, defaultValue="false") Boolean useParentPopup) {
        ExecutionStep step = this.executionFinder.findExecutionStepById(stepId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)step, EXECUTION_STEP_TYPE, locale, panelStyle, step.getProject());
        mav.addObject("useParentContextPopup", (Object)useParentPopup);
        this.populateWithKnownIssuesIfNeeded(mav, EXECUTION_STEP_TYPE, stepId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"execution-step/{stepId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getExecStepKnownIssuesData(@PathVariable(value="stepId") Long stepId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(EXECUTION_STEP_TYPE, stepId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"execution-step/{stepId}/new-issue"}, method={RequestMethod.GET})
    @ResponseBody
    public RemoteIssue getExecStepReportStub(@PathVariable Long stepId, Locale locale, HttpServletRequest request, @RequestParam(value="project-name", required=true) String projectName) {
        ExecutionStep step = this.executionFinder.findExecutionStepById(stepId.longValue());
        String executionUrl = BugTrackerControllerHelper.buildExecutionUrl(request, step.getExecution());
        return this.makeReportIssueModel(step, locale, executionUrl, projectName);
    }

    @RequestMapping(value={"execution-step/{stepId}/new-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecStepIssueReport(@PathVariable(value="stepId") Long stepId, @RequestBody BTIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @RequestMapping(value={"execution-step/{stepId}/new-advanced-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecStepAdvancedIssueReport(@PathVariable(value="stepId") Long stepId, @RequestBody AdvancedIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @RequestMapping(value={"execution-step/{stepId}/new-oslc-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecStepIssueReport(@PathVariable(value="stepId") Long stepId, @RequestBody String issueId) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + stepId);
        ExecutionStep entity = this.executionFinder.findExecutionStepById(stepId.longValue());
        OslcIssue issue = new OslcIssue();
        issue.setId(issueId);
        return this.attachIssue((RemoteIssue)issue, (IssueDetector)entity);
    }

    @RequestMapping(value={"execution/{execId}"}, method={RequestMethod.GET})
    public ModelAndView getExecIssuePanel(@PathVariable Long execId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        Execution bugged = this.executionFinder.findById(execId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)bugged, EXECUTION_TYPE, locale, panelStyle, bugged.getProject());
        this.populateWithKnownIssuesIfNeeded(mav, EXECUTION_TYPE, execId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"execution/{execId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getExecKnownIssuesData(@PathVariable(value="execId") Long execId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(EXECUTION_TYPE, execId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"execution/{execId}/new-issue"})
    @ResponseBody
    public RemoteIssue getExecReportStub(@PathVariable Long execId, Locale locale, HttpServletRequest request, @RequestParam(value="project-name", required=true) String projectName) {
        Execution execution = this.executionFinder.findById(execId.longValue());
        String executionUrl = BugTrackerControllerHelper.buildExecutionUrl(request, execution);
        return this.makeReportIssueModel(execution, locale, executionUrl, projectName);
    }

    @RequestMapping(value={"execution/{execId}/new-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecIssueReport(@PathVariable(value="execId") Long execId, @RequestBody BTIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @RequestMapping(value={"execution/{execId}/new-advanced-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecAdvancedIssueReport(@PathVariable(value="execId") Long execId, @RequestBody AdvancedIssue jsonIssue) {
        LOGGER.trace(POSTING_NEW_ISSUE_MESSAGE + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        if (jsonIssue.hasBlankId()) {
            return this.processIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
        }
        return this.attachIssue((RemoteIssue)jsonIssue, (IssueDetector)entity);
    }

    @RequestMapping(value={"execution/{execId}/new-oslc-issue"}, method={RequestMethod.POST})
    @ResponseBody
    public Object postExecIssueReport(@PathVariable(value="execId") Long execId, @RequestBody String issueId) {
        LOGGER.trace("BugTrackerController: posting a new issue for execution " + execId);
        Execution entity = this.executionFinder.findById(execId.longValue());
        OslcIssue issue = new OslcIssue();
        issue.setId(issueId);
        return this.attachIssue((RemoteIssue)issue, (IssueDetector)entity);
    }

    @RequestMapping(value={"requirement-version/{rvId}/{panelSource}"}, method={RequestMethod.GET})
    public ModelAndView getRequirementWorkspaceIssuePanel(@PathVariable(value="rvId") Long rvId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle, @PathVariable(value="panelSource") String panelSource) {
        RequirementVersion requirementVersion = this.requirementVersionManager.findById(rvId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)requirementVersion, REQUIREMENT_VERSION_TYPE, locale, panelStyle, requirementVersion.getProject());
        if (this.shouldGetTableData(mav)) {
            DefaultPagingAndSorting pas = new DefaultPagingAndSorting(SORTING_DEFAULT_ATTRIBUTE);
            pas.setSortOrder(SortOrder.DESCENDING);
            DataTableModel issues = this.getKnownIssuesDataForRequirementVersion(REQUIREMENT_VERSION_TYPE, rvId, panelSource, (PagingAndSorting)pas, "0");
            mav.addObject(MODEL_TABLE_ENTRIES, (Object)issues);
        }
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"requirement-version/{rvId}/known-issues/{panelSource}"}, method={RequestMethod.GET})
    public DataTableModel getRequirementVersionKnownIssuesData(@PathVariable(value="rvId") Long rvId, DataTableDrawParameters params, @PathVariable(value="panelSource") String panelSource) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesDataForRequirementVersion(REQUIREMENT_VERSION_TYPE, rvId, panelSource, sorter, params.getsEcho());
    }

    @RequestMapping(value={"test-case/{tcId}"}, method={RequestMethod.GET})
    public ModelAndView getTestCaseIssuePanel(@PathVariable Long tcId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        TestCase testCase = this.testCaseFinder.findById(tcId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)testCase, TEST_CASE_TYPE, locale, panelStyle, testCase.getProject());
        this.populateWithKnownIssuesIfNeeded(mav, TEST_CASE_TYPE, tcId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"test-case/{tcId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getTestCaseKnownIssuesData(@PathVariable(value="tcId") Long tcId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(TEST_CASE_TYPE, tcId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"iteration/{iterId}"}, method={RequestMethod.GET})
    public ModelAndView getIterationIssuePanel(@PathVariable Long iterId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        Iteration iteration = (Iteration)this.iterationFinder.findById(iterId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)iteration, ITERATION_TYPE, locale, panelStyle, iteration.getProject());
        this.populateWithKnownIssuesIfNeeded(mav, ITERATION_TYPE, iterId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"iteration/{iterId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getIterationKnownIssuesData(@PathVariable(value="iterId") Long iterId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(ITERATION_TYPE, iterId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"campaign/{campId}"}, method={RequestMethod.GET})
    public ModelAndView getCampaignIssuePanel(@PathVariable Long campId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        Campaign campaign = this.campaignFinder.findById(campId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)campaign, CAMPAIGN_TYPE, locale, panelStyle, campaign.getProject());
        this.populateWithKnownIssuesIfNeeded(mav, CAMPAIGN_TYPE, campId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"campaign/{campId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getCampaignKnownIssuesData(@PathVariable(value="campId") Long campId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(CAMPAIGN_TYPE, campId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"test-suite/{testSuiteId}"}, method={RequestMethod.GET})
    public ModelAndView getTestSuiteIssuePanel(@PathVariable Long testSuiteId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        TestSuite testSuite = (TestSuite)this.testSuiteFinder.findById(testSuiteId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)testSuite, TEST_SUITE_TYPE, locale, panelStyle, testSuite.getIteration().getProject());
        this.populateWithKnownIssuesIfNeeded(mav, TEST_SUITE_TYPE, testSuiteId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"test-suite/{testSuiteId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getTestSuiteKnownIssuesData(@PathVariable(value="testSuiteId") Long testSuiteId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(TEST_SUITE_TYPE, testSuiteId, sorter, params.getsEcho());
    }

    @RequestMapping(value={"campaign-folder/{campaignFolderId}"}, method={RequestMethod.GET})
    public ModelAndView getCampaignFolderIssuePanel(@PathVariable(value="campaignFolderId") Long campaignFolderId, Locale locale, @RequestParam(value="style", required=false, defaultValue="toggle") String panelStyle) {
        CampaignFolder campaignFolder = (CampaignFolder)this.clnService.findFolder(campaignFolderId.longValue());
        ModelAndView mav = this.makeIssuePanel((Identified)campaignFolder, CAMPAIGN_FOLDER_TYPE, locale, panelStyle, campaignFolder.getProject());
        this.populateWithKnownIssuesIfNeeded(mav, CAMPAIGN_FOLDER_TYPE, campaignFolderId);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"campaign-folder/{campaignFolderId}/known-issues"}, method={RequestMethod.GET})
    public DataTableModel getCampaignFolderKnownIssuesData(@PathVariable(value="campaignFolderId") Long campaignFolderId, DataTableDrawParameters params) {
        IssueCollectionSorting sorter = new IssueCollectionSorting(params);
        return this.getKnownIssuesData(CAMPAIGN_FOLDER_TYPE, campaignFolderId, sorter, params.getsEcho());
    }

    private void populateWithKnownIssuesIfNeeded(ModelAndView mav, String entityType, Long entityId) {
        if (this.shouldGetTableData(mav)) {
            DataTableModel issues = this.getKnownIssuesDataInDescendingOrder(entityType, entityId);
            mav.addObject(MODEL_TABLE_ENTRIES, (Object)issues);
        }
    }

    private DataTableModel getKnownIssuesDataInDescendingOrder(String entityType, Long entityId) {
        DefaultPagingAndSorting pas = new DefaultPagingAndSorting(SORTING_DEFAULT_ATTRIBUTE);
        pas.setSortOrder(SortOrder.DESCENDING);
        return this.getKnownIssuesData(entityType, entityId, (PagingAndSorting)pas, "0");
    }

    @RequestMapping(value={"/find-issue/{remoteKey}"}, method={RequestMethod.GET}, params={"bugTrackerId"})
    @ResponseBody
    public RemoteIssue findIssue(@PathVariable(value="remoteKey") String remoteKey, @RequestParam(value="bugTrackerId") long bugTrackerId) {
        BugTracker bugTracker = this.bugTrackerManagerService.findById(bugTrackerId);
        return this.bugTrackersLocalService.getIssue(remoteKey, bugTracker);
    }

    private Map<String, String> processIssue(RemoteIssue issue, IssueDetector entity) {
        RemoteIssue postedIssue = this.bugTrackersLocalService.createIssue(entity, issue);
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(postedIssue.getId(), entity.getBugTracker());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", issueUrl.toString());
        result.put("issueId", postedIssue.getId());
        List remoteReqIds = this.bugTrackersLocalService.findAllRemoteReqIdByServerUrlVerifiedByATestCase(entity.getBugTracker().getUrl(), entity.getReferencedTestCase().getId());
        if (!remoteReqIds.isEmpty()) {
            this.bugTrackersLocalService.linkIssueToRemoteRequirements(postedIssue.getId(), remoteReqIds, entity.getBugTracker());
        }
        return result;
    }

    private Map<String, String> attachIssue(RemoteIssue issue, IssueDetector entity) {
        this.bugTrackersLocalService.attachIssue(entity, issue.getId());
        URL issueUrl = this.bugTrackersLocalService.getIssueUrl(issue.getId(), entity.getBugTracker());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("url", issueUrl.toString());
        result.put("issueId", issue.getId());
        List remoteReqIds = this.bugTrackersLocalService.findAllRemoteReqIdByServerUrlVerifiedByATestCase(entity.getBugTracker().getUrl(), entity.getReferencedTestCase().getId());
        if (!remoteReqIds.isEmpty()) {
            this.bugTrackersLocalService.linkIssueToRemoteRequirements(issue.getId(), remoteReqIds, entity.getBugTracker());
        }
        return result;
    }

    @ResponseBody
    @RequestMapping(value={"/issues/{issueId}"}, method={RequestMethod.DELETE})
    public void detachIssue(@PathVariable(value="issueId") Long issueId) {
        this.bugTrackersLocalService.detachIssue(issueId.longValue());
    }

    @ResponseBody
    @RequestMapping(value={"/{btName}/remote-issues/{remoteIssueId}/attachments"}, method={RequestMethod.POST})
    public void forwardAttachmentsToIssue(@PathVariable(value="btName") String btName, @PathVariable(value="remoteIssueId") String remoteIssueId, @RequestParam(value="attachment[]") List<UploadedData> uploads) {
        ArrayList<Attachment> issueAttachments = new ArrayList<Attachment>(uploads.size());
        for (UploadedData upload : uploads) {
            Attachment newAttachment = new Attachment(upload.getName(), upload.getSizeInBytes(), upload.getStream());
            issueAttachments.add(newAttachment);
        }
        this.bugTrackersLocalService.forwardAttachments(remoteIssueId, btName, issueAttachments);
        for (Attachment attachment : issueAttachments) {
            try {
                attachment.getStreamContent().close();
            }
            catch (IOException ex) {
                LOGGER.warn("issue attachments : could not close stream for " + attachment.getName() + ", this is non fatal anyway", (Throwable)ex);
            }
        }
    }

    @ResponseBody
    @RequestMapping(value={"{btName}/command"}, method={RequestMethod.POST})
    public Object forwardDelegateCommand(@PathVariable(value="btName") String bugtrackerName, @RequestBody DelegateCommand command) {
        return this.bugTrackersLocalService.forwardDelegateCommand(command, bugtrackerName);
    }

    private RemoteIssue makeReportIssueModel(Execution exec, Locale locale, String executionUrl, String projectName) {
        String defaultDescription = BugTrackerControllerHelper.getDefaultDescription(exec, locale, (MessageSource)this.messageSource, executionUrl);
        return this.makeReportIssueModel((IssueDetector)exec, defaultDescription, projectName);
    }

    private RemoteIssue makeReportIssueModel(ExecutionStep step, Locale locale, String executionUrl, String projectName) {
        String defaultDescription = BugTrackerControllerHelper.getDefaultDescription(step, locale, (MessageSource)this.messageSource, executionUrl);
        return this.makeReportIssueModel(step, defaultDescription, locale, projectName);
    }

    private RemoteIssue makeReportIssueModel(ExecutionStep step, String defaultDescription, Locale locale, String projectName) {
        RemoteIssue emptyIssue = this.makeReportIssueModel((IssueDetector)step, defaultDescription, projectName);
        String comment = BugTrackerControllerHelper.getAdditionalInformation(step, locale, this.messageSource);
        emptyIssue.setComment(comment);
        return emptyIssue;
    }

    private RemoteIssue makeReportIssueModel(IssueDetector entity, String defaultDescription, String projectName) {
        RemoteIssue emptyIssue = this.bugTrackersLocalService.createReportIssueTemplate(projectName, entity.getBugTracker());
        emptyIssue.setDescription(defaultDescription);
        return emptyIssue;
    }

    private ModelAndView makeIssuePanel(Identified entity, String type, Locale locale, String panelStyle, Project project) {
        if (project.isBugtrackerConnected()) {
            AuthenticationStatus status = this.checkStatus(project.getId());
            BugTracker bugtracker = project.findBugTracker();
            BugTrackerInterfaceDescriptor descriptor = this.bugTrackersLocalService.getInterfaceDescriptor(bugtracker);
            descriptor.setLocale(locale);
            String projectNames = JsonHelper.serialize(project.getBugtrackerBinding().getProjectNames().stream().map(HTMLCleanupUtils::cleanAndUnescapeHTML).collect(Collectors.toList()));
            ModelAndView mav = new ModelAndView("fragment/bugtracker/bugtracker-panel-content");
            mav.addObject("entity", (Object)entity);
            mav.addObject("entityType", (Object)type);
            mav.addObject("interfaceDescriptor", (Object)descriptor);
            mav.addObject("panelStyle", (Object)panelStyle);
            mav.addObject(MODEL_BUG_TRACKER_STATUS, (Object)status);
            mav.addObject("project", (Object)project);
            mav.addObject("bugTracker", (Object)bugtracker);
            mav.addObject("projectNames", (Object)projectNames);
            mav.addObject("projectId", (Object)project.getId());
            mav.addObject("delete", (Object)"");
            mav.addObject("isOslc", (Object)this.btFactory.isOslcConnector(bugtracker.getKind()));
            return mav;
        }
        return new ModelAndView(EMPTY_BUGTRACKER_MAV);
    }

    @ResponseBody
    @RequestMapping(value={"/{bugtrackerIds}"}, method={RequestMethod.DELETE})
    public void deleteBugtrackers(@PathVariable(value="bugtrackerIds") List<Long> bugtrackerIds) {
        LOGGER.debug("ids of bugtracker to delete " + bugtrackerIds.toString());
        this.bugTrackerManagerService.deleteBugTrackers(bugtrackerIds);
    }

    private DataTableModel getKnownIssuesDataForRequirementVersion(String entityType, Long id, String panelSource, PagingAndSorting paging, String sEcho) {
        PagedCollectionHolder<List<RequirementVersionIssueOwnership<RemoteIssueDecorator>>> filteredCollection;
        try {
            filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipForRequirmentVersion(id, panelSource, paging);
        }
        catch (BugTrackerNoCredentialsException | NullArgumentException exception) {
            filteredCollection = this.makeEmptyIssueDecoratorCollectionHolderForRequirement(entityType, id, (Exception)exception, paging);
        }
        return this.helper.createModelBuilderForRequirementVersion().buildDataModel(filteredCollection, sEcho);
    }

    private DataTableModel getKnownIssuesData(String entityType, Long id, PagingAndSorting paging, String sEcho) {
        PagedCollectionHolder filteredCollection;
        try {
            switch (entityType) {
                case "test-case": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipForTestCase(id, paging);
                    break;
                }
                case "campaign-folder": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipForCampaignFolder(id, paging);
                    break;
                }
                case "campaign": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipsForCampaign(id, paging);
                    break;
                }
                case "iteration": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipForIteration(id, paging);
                    break;
                }
                case "test-suite": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipsForTestSuite(id, paging);
                    break;
                }
                case "execution": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnershipsforExecution(id, paging);
                    break;
                }
                case "execution-step": {
                    filteredCollection = this.bugTrackersLocalService.findSortedIssueOwnerShipsForExecutionStep(id, paging);
                    break;
                }
                default: {
                    String error = "BugTrackerController : cannot fetch issues for unknown entity type '" + entityType + "'";
                    if (LOGGER.isErrorEnabled()) {
                        LOGGER.error(error);
                    }
                    throw new IllegalArgumentException(error);
                }
            }
        }
        catch (BugTrackerNoCredentialsException | NullArgumentException exception) {
            filteredCollection = this.makeEmptyIssueDecoratorCollectionHolder(entityType, id, (Exception)exception, paging);
        }
        return this.helper.createModelBuilderFor(entityType).buildDataModel((PagedCollectionHolder<List<IssueOwnership<RemoteIssueDecorator>>>)filteredCollection, sEcho);
    }

    private AuthenticationStatus checkStatus(long projectId) {
        return this.bugTrackersLocalService.checkBugTrackerStatus(Long.valueOf(projectId));
    }

    private PagedCollectionHolder<List<RequirementVersionIssueOwnership<RemoteIssueDecorator>>> makeEmptyIssueDecoratorCollectionHolderForRequirement(String entityName, Long entityId, Exception cause, PagingAndSorting paging) {
        LOGGER.trace("BugTrackerController : fetching known issues for  " + HtmlUtils.htmlEscape((String)entityName) + " " + entityId + " failed, exception : ", (Throwable)cause);
        LinkedList emptyList = new LinkedList();
        return new PagingBackedPagedCollectionHolder((Paging)paging, 0L, emptyList);
    }

    private PagedCollectionHolder<List<IssueOwnership<RemoteIssueDecorator>>> makeEmptyIssueDecoratorCollectionHolder(String entityName, Long entityId, Exception cause, PagingAndSorting paging) {
        LOGGER.trace("BugTrackerController : fetching known issues for  " + HtmlUtils.htmlEscape((String)entityName) + " " + entityId + " failed, exception : ", (Throwable)cause);
        LinkedList emptyList = new LinkedList();
        return new PagingBackedPagedCollectionHolder((Paging)paging, 0L, emptyList);
    }

    private boolean shouldGetTableData(ModelAndView mav) {
        return mav.getModel().get(MODEL_BUG_TRACKER_STATUS) == AuthenticationStatus.AUTHENTICATED;
    }

    private static final class IssueCollectionSorting
    implements PagingAndSorting {
        private DataTableDrawParameters params;

        private IssueCollectionSorting(DataTableDrawParameters params) {
            this.params = params;
        }

        public int getFirstItemIndex() {
            return this.params.getiDisplayStart();
        }

        public String getSortedAttribute() {
            return BugTrackerController.SORTING_DEFAULT_ATTRIBUTE;
        }

        public int getPageSize() {
            return this.params.getiDisplayLength();
        }

        public boolean shouldDisplayAll() {
            return this.getPageSize() < 0;
        }

        public SortOrder getSortOrder() {
            return SortOrder.coerceFromCode((String)this.params.getsSortDir_0());
        }

        public Pageable toPageable() {
            return SpringPaginationUtils.toPageable((PagingAndSorting)this);
        }
    }
}

