/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.authorization;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.oauth2.provider.AuthorizationRequest;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.service.security.OAuth2ClientService;

@Controller
@SessionAttributes(value={"authorizationRequest"})
public class OauthController {
    @Inject
    private OAuth2ClientService oAuth2ClientService;

    @RequestMapping(value={"/oauth/confirm_access"})
    public ModelAndView getAccessConfirmation(Map<String, Object> model, Principal principal) throws Exception {
        AuthorizationRequest clientAuth = (AuthorizationRequest)model.remove("authorizationRequest");
        ClientDetails client = this.oAuth2ClientService.findClientDetailsById(clientAuth.getClientId());
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority item : client.getAuthorities()) {
            roles.add(item.getAuthority());
        }
        model.put("auth_request", clientAuth);
        model.put("client", client);
        model.put("roles", roles);
        return new ModelAndView("page/oauth/access_confirmation", model);
    }

    @RequestMapping(value={"/oauth/error"})
    public String handleError(Map<String, Object> model) throws Exception {
        model.put("message", "There was a problem with the OAuth2 protocol");
        return "page/oauth/oauth_error";
    }
}

