/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.authorization;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.constraints.NotNull;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.squashtest.tm.domain.chart.ChartDefinition;
import org.squashtest.tm.domain.customreport.CustomReportDashboard;
import org.squashtest.tm.domain.customreport.CustomReportFolder;
import org.squashtest.tm.domain.customreport.CustomReportLibrary;
import org.squashtest.tm.domain.customreport.CustomReportLibraryNode;
import org.squashtest.tm.domain.report.ReportDefinition;
import org.squashtest.tm.service.security.PermissionEvaluationService;

@RestController
@RequestMapping(value={"acls"})
public class AclsController {
    private static final Map<String, String> CLASS_NAME_BY_DASH_NAME;
    @Inject
    private PermissionEvaluationService permissionEvaluator;

    static {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("custom-report-library", CustomReportLibrary.class.getName());
        map.put("custom-report-library-node", CustomReportLibraryNode.class.getName());
        map.put("custom-report-folder", CustomReportFolder.class.getName());
        map.put("custom-report-dashboard", CustomReportDashboard.class.getName());
        map.put("chart-definition", ChartDefinition.class.getName());
        map.put("report-definition", ReportDefinition.class.getName());
        CLASS_NAME_BY_DASH_NAME = map;
    }

    @RequestMapping(value={"/{resType}/{resId}"})
    public Acl getAcls(@PathVariable String resType, @PathVariable long resId) {
        String className = CLASS_NAME_BY_DASH_NAME.get(resType);
        if (className == null) {
            throw new IllegalArgumentException("Resource type '" + resType + "' is unknown. Check source code for managed resource types.");
        }
        return new Acl(this.permissionEvaluator.permissionsOn(className, resId));
    }

    public static class Acl {
        private final Collection<String> perms;

        public Collection<String> getPerms() {
            return this.perms;
        }

        public Acl(@NotNull Collection<String> perms) {
            this.perms = perms;
        }
    }
}

