/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.authentication;

import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
public class LoginLogoutController {
    @Inject
    private ConfigurationService configService;
    @Value(value="${info.app.version}")
    private String version;
    @Autowired
    private Environment environment;
    private static final String LOGIN_MESSAGE = "LOGIN_MESSAGE";

    @RequestMapping(value={"/login"})
    public String login(Model model) {
        String welcomeMessage = this.configService.findConfiguration(LOGIN_MESSAGE);
        model.addAttribute("welcomeMessage", (Object)HTMLCleanupUtils.cleanHtml(welcomeMessage));
        model.addAttribute("version", (Object)this.version);
        List<String> activeProfiles = Arrays.asList(this.environment.getActiveProfiles());
        model.addAttribute("isH2", (Object)activeProfiles.contains("h2"));
        return "page/authentication/login";
    }

    @RequestMapping(value={"/logged-out"})
    public String logout() {
        return "logged-out.html";
    }
}

