/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.authentication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.springframework.http.MediaType;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.configurers.CsrfConfigurer;
import org.springframework.security.web.savedrequest.HttpSessionRequestCache;
import org.springframework.security.web.util.matcher.AndRequestMatcher;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.MediaTypeRequestMatcher;
import org.springframework.security.web.util.matcher.NegatedRequestMatcher;
import org.springframework.security.web.util.matcher.RequestHeaderRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.accept.ContentNegotiationStrategy;
import org.springframework.web.accept.HeaderContentNegotiationStrategy;

public final class HttpSessionRequestCacheWithExceptions
extends HttpSessionRequestCache {
    public HttpSessionRequestCacheWithExceptions(String ... excludedPaths) {
        this.init((ContentNegotiationStrategy)new HeaderContentNegotiationStrategy(), true, excludedPaths);
    }

    public HttpSessionRequestCacheWithExceptions(ContentNegotiationStrategy negociationStrategy, boolean isCsrfEnabled, String ... excludedPaths) {
        this.init(negociationStrategy, isCsrfEnabled, excludedPaths);
    }

    public HttpSessionRequestCacheWithExceptions(HttpSecurityBuilder<?> secBuilder, String ... excludedPaths) {
        ContentNegotiationStrategy contentStrat = (ContentNegotiationStrategy)secBuilder.getSharedObject(ContentNegotiationStrategy.class);
        if (contentStrat == null) {
            contentStrat = new HeaderContentNegotiationStrategy();
        }
        boolean isCsrfEnabled = secBuilder.getConfigurer(CsrfConfigurer.class) != null;
        this.init(contentStrat, isCsrfEnabled, excludedPaths);
    }

    private void init(ContentNegotiationStrategy negociationStrategy, boolean isCsrfEnabled, String ... exclusion) {
        List<RequestMatcher> matchers = this.createBaseMatchers(negociationStrategy, isCsrfEnabled);
        if (exclusion != null) {
            String[] stringArray = exclusion;
            int n = exclusion.length;
            int n2 = 0;
            while (n2 < n) {
                String path = stringArray[n2];
                matchers.add((RequestMatcher)new NegatedRequestMatcher((RequestMatcher)new AntPathRequestMatcher(path)));
                ++n2;
            }
        }
        this.setRequestMatcher((RequestMatcher)new AndRequestMatcher(matchers));
    }

    private List<RequestMatcher> createBaseMatchers(ContentNegotiationStrategy negociationStrategy, boolean isCsrfEnabled) {
        NegatedRequestMatcher notFavIcon = new NegatedRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/**/favicon.ico"));
        MediaTypeRequestMatcher jsonRequest = new MediaTypeRequestMatcher(negociationStrategy, new MediaType[]{MediaType.APPLICATION_JSON});
        jsonRequest.setIgnoredMediaTypes(Collections.singleton(MediaType.ALL));
        NegatedRequestMatcher notJson = new NegatedRequestMatcher((RequestMatcher)jsonRequest);
        NegatedRequestMatcher notXRequestedWith = new NegatedRequestMatcher((RequestMatcher)new RequestHeaderRequestMatcher("X-Requested-With", "XMLHttpRequest"));
        ArrayList<RequestMatcher> matchers = new ArrayList<RequestMatcher>();
        if (isCsrfEnabled) {
            AntPathRequestMatcher getRequests = new AntPathRequestMatcher("/**", "GET");
            matchers.add(0, (RequestMatcher)getRequests);
        }
        matchers.add((RequestMatcher)notFavIcon);
        matchers.add((RequestMatcher)notJson);
        matchers.add((RequestMatcher)notXRequestedWith);
        return matchers;
    }
}

