/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.audittrail;

import java.util.Locale;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.domain.event.ChangedProperty;
import org.squashtest.tm.domain.event.RequirementLargePropertyChange;
import org.squashtest.tm.service.audit.RequirementAuditTrailService;
import org.squashtest.tm.web.internal.controller.audittrail.ChangedPropertyJsonDecorator;
import org.squashtest.tm.web.internal.controller.audittrail.RequirementAuditEventTableModelBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

@Controller
@RequestMapping(value={"/audit-trail/requirement-versions"})
public class RequirementAuditTrailController {
    @Inject
    private RequirementAuditTrailService auditTrailService;
    @Inject
    private InternationalizationHelper i18nHelper;

    @RequestMapping(value={"{requirementVersionId}/events-table"}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getEventsTableModel(@PathVariable long requirementVersionId, DataTableDrawParameters drawParams, Locale locale) {
        Pageable pageable = SpringPagination.pageable(drawParams);
        Page auditTrail = this.auditTrailService.findAllByRequirementVersionIdOrderedByDate(requirementVersionId, pageable);
        RequirementAuditEventTableModelBuilder builder = new RequirementAuditEventTableModelBuilder(locale, this.i18nHelper);
        return builder.buildDataModel(auditTrail, drawParams.getsEcho());
    }

    @RequestMapping(value={"fat-prop-change-events/{eventId}"})
    @ResponseBody
    public ChangedProperty getLargePropertyChangeEvent(@PathVariable long eventId) {
        RequirementLargePropertyChange event = this.auditTrailService.findLargePropertyChangeById(eventId);
        return new ChangedPropertyJsonDecorator((ChangedProperty)this.escapeRLPC(event));
    }

    private RequirementLargePropertyChange escapeRLPC(RequirementLargePropertyChange event) {
        return (RequirementLargePropertyChange)RequirementLargePropertyChange.builder().setSource(event.getRequirementVersion()).setModifiedProperty(event.getPropertyName()).setOldValue((Object)HTMLCleanupUtils.cleanHtml(event.getOldValue())).setNewValue((Object)HTMLCleanupUtils.cleanHtml(event.getNewValue())).setAuthor(event.getAuthor()).build();
    }
}

