/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.audittrail;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.springframework.util.ReflectionUtils;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.i18n.Internationalizable;
import org.squashtest.tm.domain.event.RequirementAuditEvent;
import org.squashtest.tm.domain.event.RequirementAuditEventVisitor;
import org.squashtest.tm.domain.event.RequirementCreation;
import org.squashtest.tm.domain.event.RequirementLargePropertyChange;
import org.squashtest.tm.domain.event.RequirementPropertyChange;
import org.squashtest.tm.domain.event.RequirementVersionModification;
import org.squashtest.tm.domain.event.SyncRequirementCreation;
import org.squashtest.tm.domain.event.SyncRequirementUpdate;
import org.squashtest.tm.domain.infolist.InfoListItem;
import org.squashtest.tm.domain.requirement.RequirementVersion;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class RequirementAuditEventTableModelBuilder
extends DataTableModelBuilder<RequirementAuditEvent>
implements RequirementAuditEventVisitor {
    private final Locale locale;
    private final InternationalizationHelper i18nHelper;
    private Map<String, String> currentItemData;

    public RequirementAuditEventTableModelBuilder(@NotNull Locale locale, @NotNull InternationalizationHelper messageSource) {
        this.i18nHelper = messageSource;
        this.locale = locale;
    }

    protected Map<String, String> buildItemData(RequirementAuditEvent item) {
        item.accept((RequirementAuditEventVisitor)this);
        return this.currentItemData;
    }

    public void visit(RequirementCreation event) {
        String message = this.i18nHelper.internationalize("label.Creation", this.locale);
        this.populateCurrentItemData(message, "creation", (RequirementAuditEvent)event);
    }

    public void visit(SyncRequirementCreation event) {
        String message = this.i18nHelper.internationalize("label.CreationBySynchronization", this.locale);
        this.populateCurrentItemData(message, "sync-creation", (RequirementAuditEvent)event);
        this.currentItemData.put("event-meta", event.getSource());
    }

    public void visit(SyncRequirementUpdate event) {
        String message = this.i18nHelper.internationalize("label.UpdateBySynchronization", this.locale);
        this.populateCurrentItemData(message, "sync-update", (RequirementAuditEvent)event);
        this.currentItemData.put("event-meta", event.getSource());
    }

    public void visit(RequirementPropertyChange event) {
        Object[] args = this.buildMessageArgs(event);
        String message = this.i18nHelper.getMessage(this.buildPropertyChangeMessageKey((RequirementVersionModification)event), args, this.locale);
        this.populateCurrentItemData(message, "simple-prop", (RequirementAuditEvent)event);
    }

    private String buildPropertyChangeMessageKey(RequirementVersionModification event) {
        return "message.property-change." + event.getPropertyName() + ".label";
    }

    private Object[] buildMessageArgs(RequirementPropertyChange event) {
        Object[] args = this.propertyIsEnumeratedAndInternationalizable(event) ? this.buildMessageArgsForI18nableEnumProperty(event) : (this.propertyIsInfolist(event) ? this.buildMessageArgsForI18ableInfoListProperty(event) : this.buildMessageArgsForStringProperty(event));
        return args;
    }

    private boolean propertyIsEnumeratedAndInternationalizable(RequirementPropertyChange event) {
        Field field = ReflectionUtils.findField(RequirementVersion.class, (String)event.getPropertyName());
        Class<?> fieldType = field.getType();
        return Enum.class.isAssignableFrom(fieldType) && Internationalizable.class.isAssignableFrom(fieldType);
    }

    private boolean propertyIsInfolist(RequirementPropertyChange event) {
        Field field = ReflectionUtils.findField(RequirementVersion.class, (String)event.getPropertyName());
        Class<?> fieldType = field.getType();
        return InfoListItem.class.isAssignableFrom(fieldType);
    }

    private Object[] buildMessageArgsForStringProperty(RequirementPropertyChange event) {
        return new Object[]{event.getOldValue(), event.getNewValue()};
    }

    private Object[] buildMessageArgsForI18nableEnumProperty(RequirementPropertyChange event) {
        Field enumField = ReflectionUtils.findField(RequirementVersion.class, (String)event.getPropertyName());
        Class<?> enumType = enumField.getType();
        String oldValueLabel = this.retrieveEnumI18ndLabel(enumType, event.getOldValue());
        String newValueLabel = this.retrieveEnumI18ndLabel(enumType, event.getNewValue());
        return new Object[]{oldValueLabel, newValueLabel};
    }

    private Object[] buildMessageArgsForI18ableInfoListProperty(RequirementPropertyChange event) {
        return new Object[]{this.i18nHelper.getMessage(event.getOldValue(), null, event.getOldValue(), this.locale), this.i18nHelper.getMessage(event.getNewValue(), null, event.getNewValue(), this.locale)};
    }

    private String retrieveEnumI18ndLabel(Class enumType, String stringValue) {
        Internationalizable enumValue = (Internationalizable)Enum.valueOf(enumType, stringValue);
        return this.i18nHelper.internationalize(enumValue, this.locale);
    }

    public void visit(RequirementLargePropertyChange event) {
        String message = this.i18nHelper.internationalize(this.buildPropertyChangeMessageKey((RequirementVersionModification)event), this.locale);
        this.populateCurrentItemData(message, "fat-prop", (RequirementAuditEvent)event);
    }

    private void populateCurrentItemData(String message, String eventType, RequirementAuditEvent event) {
        String formattedDate = DateFormatUtils.format((Date)event.getDate(), (String)"dd/MM/yyyy HH'h'mm");
        String escapedAuthor = HtmlUtils.htmlEscape((String)event.getAuthor());
        String escapedMessage = HtmlUtils.htmlEscape((String)message);
        HashMap<String, String> row = new HashMap<String, String>(5);
        row.put("event-date", formattedDate);
        row.put("event-author", escapedAuthor);
        row.put("event-message", escapedMessage);
        row.put("event-type", eventType);
        row.put("event-id", String.valueOf(event.getId()));
        this.currentItemData = row;
    }
}

