/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.attachment;

import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class AttachmentsTableModelHelper
extends DataTableModelBuilder<Attachment> {
    private InternationalizationHelper i18nHelper;
    private Locale locale;
    private static final int INT_MAX_FILENAME_LENGTH = 50;

    public AttachmentsTableModelHelper(InternationalizationHelper i18nHelper) {
        this.i18nHelper = i18nHelper;
        this.locale = LocaleContextHolder.getLocale();
    }

    protected Map<Object, Object> buildItemData(Attachment item) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put("entity-id", item.getId());
        result.put("entity-index", this.getCurrentIndex());
        result.put("name", HtmlUtils.htmlEscape((String)item.getName()));
        result.put("hyphenated-name", HtmlUtils.htmlEscape((String)this.hyphenateFilename(item.getName())));
        result.put("size", item.getFormattedSize(this.locale));
        result.put("added-on", this.localizedDate(item.getAddedOn(), this.locale));
        result.put("empty-delete-holder", null);
        return result;
    }

    private String localizedDate(Date date, Locale locale) {
        return this.i18nHelper.localizeDate(date, locale);
    }

    private String hyphenateFilename(String longName) {
        String newName = longName;
        if (longName.length() > 50) {
            newName = String.valueOf(longName.substring(0, 47)) + "...";
        }
        return newName;
    }
}

