/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.attachment;

import java.io.IOException;
import java.util.List;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.jquery.RenameModel;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/attach-list/{attachListId}/attachments"})
public class AttachmentManagerController {
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentManagerController.class);
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentModelHelper;
    private static final String ATTACH_LIST_ID = "attachListId";
    private final DatatableMapper attachmentMapper = new NameBasedMapper().mapAttribute("item-id", "name", Attachment.class).mapAttribute("hyphenated-name", "name", Attachment.class).mapAttribute("size", "contentSize", Attachment.class).mapAttribute("added-on", "addedOn", Attachment.class);

    @RequestMapping(value={"/manager"}, method={RequestMethod.GET})
    public ModelAndView showAttachmentManager(@PathVariable(value="attachListId") long attachListId, @RequestParam(value="workspace") String workspace, @RequestParam(value="open", required=false, defaultValue="false") boolean openNewWindow) {
        ModelAndView mav = new ModelAndView("page/attachments/attachment-manager");
        mav.addObject("workspace", (Object)workspace);
        mav.addObject(ATTACH_LIST_ID, (Object)attachListId);
        mav.addObject("attachmentsModel", (Object)this.attachmentModelHelper.findPagedAttachments(attachListId));
        mav.addObject("openNewWindow", (Object)openNewWindow);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/details"}, method={RequestMethod.GET})
    public DataTableModel displayAttachmentDetails(@PathVariable(value="attachListId") long attachListId, DataTableDrawParameters params) {
        Pageable pageable = SpringPagination.pageable(params, this.attachmentMapper);
        return this.attachmentModelHelper.findPagedAttachments(attachListId, pageable, params.getsEcho());
    }

    @RequestMapping(value={"/{attachmentIds}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void removeAttachment(@PathVariable long attachListId, @PathVariable(value="attachmentIds") List<Long> ids) throws IOException {
        this.attachmentManagerService.removeListOfAttachments(attachListId, ids);
    }

    @RequestMapping(value={"/{attachmentId}/name"}, method={RequestMethod.POST}, params={"name"})
    @ResponseBody
    public Object renameAttachment(@PathVariable long attachmentId, @RequestParam(value="name") String newName) {
        this.attachmentManagerService.renameAttachment(attachmentId, newName);
        LOGGER.info("AttachmentController : renaming attachment " + attachmentId + " as " + newName);
        return new RenameModel(newName);
    }
}

