/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.attachment;

import java.beans.PropertyEditor;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.ServletRequestDataBinder;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.attachment.Attachment;
import org.squashtest.tm.service.attachment.AttachmentManagerService;
import org.squashtest.tm.service.attachment.RawAttachment;
import org.squashtest.tm.web.internal.controller.attachment.UploadedData;
import org.squashtest.tm.web.internal.controller.attachment.UploadedDataPropertyEditorSupport;
import org.squashtest.tm.web.internal.fileupload.UploadContentFilterUtil;
import org.squashtest.tm.web.internal.fileupload.UploadSummary;

@Controller
@RequestMapping(value={"/attach-list/{attachListId}/attachments"})
public class AttachmentController {
    private static final String UPLOAD_URL = "/upload";
    private static final Logger LOGGER = LoggerFactory.getLogger(AttachmentController.class);
    @Inject
    private AttachmentManagerService attachmentManagerService;
    @Inject
    private MessageSource messageSource;
    @Inject
    private UploadContentFilterUtil filterUtil;
    private static final String STR_UPLOAD_STATUS_OK = "dialog.attachment.summary.statusok.label";
    private static final String STR_UPLOAD_STATUS_WRONGFILETYPE = "dialog.attachment.summary.statuswrongtype.label";

    @InitBinder
    public void initBinder(HttpServletRequest request, ServletRequestDataBinder binder) throws ServletException {
        binder.registerCustomEditor(UploadedData.class, (PropertyEditor)new UploadedDataPropertyEditorSupport());
    }

    @RequestMapping(value={"/display"}, method={RequestMethod.GET})
    public ModelAndView displayAttachments(@PathVariable(value="attachListId") long attachListId) {
        Set attachmentSet = this.attachmentManagerService.findAttachments(Long.valueOf(attachListId));
        ModelAndView mav = new ModelAndView("fragment/attachments/attachment-display");
        mav.addObject("attachmentSet", (Object)attachmentSet);
        mav.addObject("attachListId", (Object)attachListId);
        return mav;
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, produces={"text/html"})
    public String uploadAttachmentAsHtml(@RequestParam(value="attachment[]") List<UploadedData> attachments, @PathVariable long attachListId, Locale locale, Model model) throws IOException {
        List<UploadedData> nonEmpty = this.removeEmptyData(attachments);
        List<UploadSummary> summaries = this.uploadAttachmentAsJson(nonEmpty, attachListId, locale);
        model.addAttribute("summary", summaries);
        return "fragment/import/upload-summary";
    }

    @RequestMapping(value={"/upload"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public List<UploadSummary> uploadAttachmentAsJson(@RequestParam(value="attachment[]") List<UploadedData> attachments, @PathVariable long attachListId, Locale locale) throws IOException {
        List<UploadSummary> summary = new LinkedList<UploadSummary>();
        for (UploadedData upload : attachments) {
            LOGGER.trace("AttachmentController : adding attachment " + upload.getName());
            boolean shouldProceed = this.filterUtil.isTypeAllowed(upload);
            if (!shouldProceed) {
                summary.add(new UploadSummary(upload.getName(), this.getUploadSummary(STR_UPLOAD_STATUS_WRONGFILETYPE, locale), 1));
                continue;
            }
            this.attachmentManagerService.addAttachment(attachListId, (RawAttachment)upload);
            summary.add(new UploadSummary(HtmlUtils.htmlEscape((String)upload.getName()), this.getUploadSummary(STR_UPLOAD_STATUS_OK, locale), 0));
        }
        summary = this.stripEmptySummary(summary);
        return summary;
    }

    private List<UploadSummary> stripEmptySummary(List<UploadSummary> summary) {
        int totalAttachment = summary.size();
        if (totalAttachment > 0 && summary.get(totalAttachment - 1).getName().isEmpty()) {
            summary.remove(totalAttachment - 1);
        }
        return summary;
    }

    private List<UploadedData> removeEmptyData(List<UploadedData> all) {
        ArrayList<UploadedData> nonEmpty = new ArrayList<UploadedData>();
        for (UploadedData dat : all) {
            if (dat.getSizeInBytes() <= 0L) continue;
            nonEmpty.add(dat);
        }
        return nonEmpty;
    }

    @ResponseBody
    @RequestMapping(value={"/download/{attachemendId}"}, method={RequestMethod.GET})
    public void downloadAttachment(@PathVariable(value="attachemendId") long attachmentId, HttpServletResponse response) {
        try {
            Attachment attachment = this.attachmentManagerService.findAttachment(Long.valueOf(attachmentId));
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "attachment; filename=" + attachment.getName().replace(" ", "_"));
            ServletOutputStream outStream = response.getOutputStream();
            this.attachmentManagerService.writeContent(attachmentId, (OutputStream)outStream);
        }
        catch (IOException e) {
            LOGGER.warn("Error happened during attachment download : " + e.getMessage(), (Throwable)e);
            response.setStatus(500);
        }
    }

    private String getUploadSummary(String key, Locale locale) {
        return this.messageSource.getMessage(key, null, locale);
    }
}

