/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.DefaultFiltering;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.project.ProjectPermission;
import org.squashtest.tm.domain.users.User;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.connectionhistory.ConnectionLogFinderService;
import org.squashtest.tm.service.internal.security.AuthenticationProviderContext;
import org.squashtest.tm.service.user.AdministrationService;
import org.squashtest.tm.service.user.AuthenticatedUser;
import org.squashtest.tm.service.user.TeamFinderService;
import org.squashtest.tm.web.internal.controller.administration.PasswordResetForm;
import org.squashtest.tm.web.internal.controller.administration.UserForm;
import org.squashtest.tm.web.internal.controller.administration.UserLoginForm;
import org.squashtest.tm.web.internal.controller.project.ProjectModel;
import org.squashtest.tm.web.internal.controller.users.PartyControllerSupport;
import org.squashtest.tm.web.internal.controller.users.PermissionGroupModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/users"})
public class UserAdministrationController
extends PartyControllerSupport {
    private static final String TEXT_PLAIN_CHARSET_UTF_8 = "text/plain;charset=UTF-8";
    private static final String USER_ID = "userId";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserAdministrationController.class);
    private static final String USER_URL = "/{userId}";
    private static final String USER_URLS = "/{userIds}";
    private static final PagingAndSorting TEAMS_DEFAULT_PAGING = new DefaultPagingAndSorting("name");
    private static final Filtering TEAMS_DEFAULT_FILTERING = DefaultFiltering.NO_FILTERING;
    private static final ColumnFiltering CONNECTION_COLUMN_DEFAULT_FILTERING = ColumnFiltering.unfiltered();
    private static final PagingAndSorting CONNECTIONS_DEFAULT_PAGING = new DefaultPagingAndSorting("id");
    @Inject
    private AdministrationService adminService;
    @Inject
    private TeamFinderService teamFinderService;
    @Inject
    private ConnectionLogFinderService connectionLogFinderService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private AuthenticationProviderContext authenticationProviderContext;
    @Inject
    private ConfigurationService configurationService;
    private DatatableMapper<String> userMapper = new NameBasedMapper(10).map("user-id", "id").map("user-active", "active").map("user-login", "login").map("user-group", "group").map("user-firstname", "firstName").map("user-lastname", "lastName").map("user-email", "email").map("user-created-on", "audit.createdOn").map("user-created-by", "audit.createdBy").map("user-modified-on", "audit.lastModifiedOn").map("user-modified-by", "audit.lastModifiedBy").map("user-connected-on", "lastConnectedOn");
    private DatatableMapper<String> permissionMapper = new NameBasedMapper(2).mapAttribute("project-name", "project.name", ProjectPermission.class).mapAttribute("permission-name", "permissionGroup.qualifiedName", ProjectPermission.class);

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public ModelAndView getUserList(Locale locale) {
        ModelAndView mav = new ModelAndView("page/users/show-users");
        List list = this.adminService.findAllUsersGroupOrderedByQualifiedName();
        DefaultPagingAndSorting paging = new DefaultPagingAndSorting("User.login");
        DefaultFiltering filter = DefaultFiltering.NO_FILTERING;
        DataTableModel model = this.getTableModel((PagingAndSorting)paging, (Filtering)filter, "noneed", locale);
        mav.addObject("usersGroupList", (Object)list);
        mav.addObject("userList", model.getAaData());
        PagedCollectionHolder teams = this.teamFinderService.findAllFiltered(TEAMS_DEFAULT_PAGING, TEAMS_DEFAULT_FILTERING);
        mav.addObject("pagedTeams", (Object)teams);
        mav.addObject("teamsPageSize", (Object)TEAMS_DEFAULT_PAGING.getPageSize());
        PagedCollectionHolder connectionLogs = this.connectionLogFinderService.findAllFiltered(CONNECTIONS_DEFAULT_PAGING, CONNECTION_COLUMN_DEFAULT_FILTERING);
        mav.addObject("pagedConnectionLogs", (Object)connectionLogs);
        mav.addObject("connectionsPageSize", (Object)CONNECTIONS_DEFAULT_PAGING.getPageSize());
        boolean canManageLocalPassword = this.authenticationProviderContext.isInternalProviderEnabled();
        mav.addObject("canManageLocalPassword", (Object)canManageLocalPassword);
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        mav.addObject("userLicenseInformationData", (Object)userLicenseInformation);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/table"}, params={"sEcho"}, method={RequestMethod.GET})
    public DataTableModel getTable(DataTableDrawParameters params, Locale locale) {
        DataTableSorting sorting = this.createSorting(params, this.userMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        return this.getTableModel(sorting, filtering, params.getsEcho(), locale);
    }

    private DataTableModel getTableModel(PagingAndSorting sorting, Filtering filtering, String sEcho, Locale locale) {
        PagedCollectionHolder holder = this.adminService.findAllUsersFiltered(sorting, filtering);
        return new UserDataTableModelBuilder(locale).buildDataModel(holder, sEcho);
    }

    @ResponseBody
    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"password"})
    public void addUser(@ModelAttribute(value="add-user") @Valid UserForm userForm) {
        this.adminService.addUser(userForm.getUser(), userForm.getGroupId(), userForm.getPassword());
    }

    @ResponseBody
    @RequestMapping(value={"/new"}, method={RequestMethod.POST}, params={"noPassword"})
    public void addUserWithoutCredentials(@ModelAttribute(value="add-user") @Valid UserForm userForm) {
        this.adminService.createUserWithoutCredentials(userForm.getUser(), userForm.getGroupId());
    }

    private DataTableSorting createSorting(DataTableDrawParameters params, DatatableMapper mapper) {
        return new DataTableSorting(params, mapper);
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}/deactivate"}, method={RequestMethod.POST})
    public void deactivateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deactivateUsers(userIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}/activate"}, method={RequestMethod.POST})
    public void activateUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.activateUsers(userIds);
    }

    @ResponseBody
    @RequestMapping(value={"/{userIds}"}, method={RequestMethod.DELETE})
    public void deleteUsers(@PathVariable(value="userIds") List<Long> userIds) {
        this.adminService.deleteUsers(userIds);
    }

    @RequestMapping(value={"/{userId}/info"}, method={RequestMethod.GET})
    public String getUserInfos(@PathVariable(value="userId") long userId, Model model) {
        AuthenticatedUser user = this.adminService.findUserById(userId);
        List usersGroupList = this.adminService.findAllUsersGroupOrderedByQualifiedName();
        List permissionModel = this.createPermissionTableModel(userId, (PagingAndSorting)new DefaultPagingAndSorting(), (Filtering)DefaultFiltering.NO_FILTERING, "").getAaData();
        List<PermissionGroupModel> pgm = this.getPermissionGroupModels();
        pgm.sort(Comparator.comparing(PermissionGroupModel::getDisplayName));
        List<ProjectModel> pm = this.getProjectModels(userId);
        boolean canManageLocalPassword = this.authenticationProviderContext.isInternalProviderEnabled();
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        model.addAttribute("usersGroupList", (Object)usersGroupList);
        model.addAttribute("user", (Object)user);
        model.addAttribute("permissionList", pgm);
        model.addAttribute("myprojectList", pm);
        model.addAttribute("permissions", permissionModel);
        model.addAttribute("canManageLocalPassword", (Object)canManageLocalPassword);
        model.addAttribute("userLicenseInformationData", (Object)userLicenseInformation);
        return "user-modification.html";
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/change-group"}, method={RequestMethod.POST})
    public void changeUserGroup(@PathVariable long userId, @RequestParam long groupId) {
        this.adminService.setUserGroupAuthority(userId, groupId);
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.POST}, params={"id=user-login", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String updateLogin(@ModelAttribute @Valid UserLoginForm userLoginform, @PathVariable long userId) {
        String userLogin = userLoginform.getValue();
        this.adminService.modifyUserLogin(userId, userLogin);
        return HtmlUtils.htmlEscape((String)userLogin);
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.POST}, params={"id=user-first-name", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String updateFirstName(@RequestParam(value="value") String firstName, @PathVariable long userId) {
        this.adminService.modifyUserFirstName(userId, firstName);
        return HtmlUtils.htmlEscape((String)firstName);
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.POST}, params={"id=user-last-name", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String updateLastName(@RequestParam(value="value") String lastName, @PathVariable long userId) {
        this.adminService.modifyUserLastName(userId, lastName);
        return HtmlUtils.htmlEscape((String)lastName);
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.POST}, params={"id=user-email", "value"}, produces={"text/plain;charset=UTF-8"})
    @ResponseBody
    public String updateEmail(@RequestParam(value="value") String email, @PathVariable long userId) {
        this.adminService.modifyUserEmail(userId, email);
        return HtmlUtils.htmlEscape((String)email);
    }

    @RequestMapping(value={"/{userId}"}, method={RequestMethod.POST}, params={"password"})
    @ResponseBody
    public void resetPassword(@ModelAttribute @Valid PasswordResetForm form, @PathVariable long userId) {
        LOGGER.trace("Reset password for user #" + userId);
        this.adminService.resetUserPassword(userId, form.getPassword());
    }

    @RequestMapping(value={"/{userId}/authentication"}, method={RequestMethod.PUT}, params={"password"})
    @ResponseBody
    public void createAuthentication(@ModelAttribute @Valid PasswordResetForm form, @PathVariable long userId) {
        LOGGER.trace("Create authentication for user #" + userId);
        this.adminService.createAuthentication(userId, form.getPassword());
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/add-permission"}, method={RequestMethod.POST})
    public void addNewPermission(@RequestParam(value="project") long projectId, @PathVariable long userId, @RequestParam String permission) {
        this.permissionService.addNewPermissionToProject(userId, projectId, permission);
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/remove-permission"}, method={RequestMethod.POST})
    public void removePermission(@RequestParam(value="project") List<Long> projectIds, @PathVariable(value="userId") long userId) {
        for (Long projectId : projectIds) {
            this.permissionService.removeProjectPermission(userId, projectId.longValue());
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/permission-popup"}, method={RequestMethod.GET})
    public Map<String, Object> getPermissionPopup(@PathVariable(value="userId") long userId) {
        return this.createPermissionPopupModel(userId);
    }

    @ResponseBody
    @RequestMapping(value={"/{userId}/permissions"}, method={RequestMethod.GET}, params={"sEcho"})
    public DataTableModel getPermissionTableModel(DataTableDrawParameters params, @PathVariable(value="userId") long userId) {
        DataTableSorting paging = new DataTableSorting(params, this.permissionMapper);
        DataTableFiltering filtering = new DataTableFiltering(params);
        return this.createPermissionTableModel(userId, paging, filtering, params.getsEcho());
    }

    private String formatString(String arg, Locale locale) {
        if (arg == null) {
            return this.formatNoData(locale);
        }
        return arg;
    }

    private String formatDate(Date date, Locale locale) {
        return this.messageSource.localizeDate(date, locale);
    }

    private String formatNoData(Locale locale) {
        return this.messageSource.noData(locale);
    }

    private final class UserDataTableModelBuilder
    extends DataTableModelBuilder<User> {
        private final Locale locale;

        private UserDataTableModelBuilder(Locale locale) {
            this.locale = locale;
        }

        public Map<?, ?> buildItemData(User item) {
            String group;
            User newP = item;
            if (item.getGroup() == null) {
                group = "";
            } else {
                group = UserAdministrationController.this.messageSource.internationalize("user.account.group." + item.getGroup().getQualifiedName() + ".label", this.locale);
                if (group == null) {
                    group = item.getGroup().getSimpleName();
                }
            }
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("user-id", item.getId());
            result.put("user-active", item.getActive());
            result.put("user-index", this.getCurrentIndex());
            result.put("user-login", HtmlUtils.htmlEscape((String)item.getLogin()));
            result.put("user-group", group);
            result.put("user-firstname", HtmlUtils.htmlEscape((String)item.getFirstName()));
            result.put("user-lastname", HtmlUtils.htmlEscape((String)item.getLastName()));
            result.put("user-email", HtmlUtils.htmlEscape((String)item.getEmail()));
            result.put("user-created-on", UserAdministrationController.this.formatDate(newP.getCreatedOn(), this.locale).substring(0, 10));
            result.put("user-created-by", HtmlUtils.htmlEscape((String)UserAdministrationController.this.formatString(newP.getCreatedBy(), this.locale)));
            result.put("user-modified-on", UserAdministrationController.this.formatDate(newP.getLastModifiedOn(), this.locale));
            result.put("user-modified-by", HtmlUtils.htmlEscape((String)UserAdministrationController.this.formatString(newP.getLastModifiedBy(), this.locale)));
            result.put("user-connected-on", UserAdministrationController.this.formatDate(item.getLastConnectedOn(), this.locale));
            result.put("empty-delete-holder", null);
            return result;
        }
    }
}

