/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.service.requirement.LinkedRequirementVersionManagerService;
import org.squashtest.tm.web.internal.controller.administration.RequirementLinkTypesTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/requirement-link-types"})
public class RequirementVersionLinkTypeAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(RequirementVersionLinkTypeAdministrationController.class);
    @Inject
    private InternationalizationHelper i18nHelper;
    @Inject
    private LinkedRequirementVersionManagerService reqLinksFinder;
    private final DatatableMapper<String> linkTypesMapper = new NameBasedMapper(4).mapAttribute("type-role1", "role1", RequirementVersionLinkType.class).mapAttribute("type-role1-code", "role1Code", RequirementVersionLinkType.class).mapAttribute("type-role2", "role2", RequirementVersionLinkType.class).mapAttribute("type-role2-code", "role2Code", RequirementVersionLinkType.class).mapAttribute("type-is-default", "isDefault", RequirementVersionLinkType.class);

    @ModelAttribute(value="tablePageSize")
    public long populateTablePageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showManager(Model model) {
        DataTableModel reqLinkTypesModel = this.getReqLinkTypesInitialModel();
        model.addAttribute("linkTypesModel", (Object)reqLinkTypesModel);
        return "requirement-link-type-manager.html";
    }

    @RequestMapping(value={"/table"}, method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getReqLinkTypesTableModel(DataTableDrawParameters params) {
        DataTableSorting pagingAndSorting = new DataTableSorting(params, this.linkTypesMapper);
        return this.buildReqLinkTypesModel(pagingAndSorting, params.getsEcho());
    }

    protected DataTableModel buildReqLinkTypesModel(PagingAndSorting pas, String sEcho) {
        PagedCollectionHolder holder = this.reqLinksFinder.getAllPagedAndSortedReqVersionLinkTypes(pas);
        return new RequirementLinkTypesTableModelHelper(this.i18nHelper).buildDataModel(holder, sEcho);
    }

    private DataTableModel getReqLinkTypesInitialModel() {
        PagedCollectionHolder holder = this.reqLinksFinder.getAllPagedAndSortedReqVersionLinkTypes((PagingAndSorting)new DefaultPagingAndSorting("RequirementVersionLinkType.role1"));
        return new RequirementLinkTypesTableModelHelper(this.i18nHelper).buildDataModel(holder, "0");
    }
}

