/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.Locale;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.requirement.RequirementVersionLinkType;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

class RequirementLinkTypesTableModelHelper
extends DataTableModelBuilder<RequirementVersionLinkType> {
    private InternationalizationHelper helper;
    private Locale locale = LocaleContextHolder.getLocale();

    public RequirementLinkTypesTableModelHelper(InternationalizationHelper helper) {
        this.helper = helper;
    }

    @Override
    protected Object buildItemData(RequirementVersionLinkType type) {
        HashMap<String, String> row = new HashMap<String, String>(8);
        row.put("type-id", type.getId().toString());
        row.put("type-index", Long.toString(this.getCurrentIndex()));
        row.put("type-role1", HtmlUtils.htmlEscape((String)this.formatRole(type.getRole1())));
        row.put("type-role1-code", HtmlUtils.htmlEscape((String)type.getRole1Code()));
        row.put("type-role2", HtmlUtils.htmlEscape((String)this.formatRole(type.getRole2())));
        row.put("type-role2-code", HtmlUtils.htmlEscape((String)type.getRole2Code()));
        row.put("type-is-default", Boolean.toString(type.isDefault()));
        row.put("empty-delete-holder", null);
        return row;
    }

    private String formatRole(String role) {
        return this.helper.getMessage(role, null, role, this.locale);
    }
}

