/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.api.plugin.EntityReference;
import org.squashtest.tm.api.plugin.EntityType;
import org.squashtest.tm.api.plugin.Plugin;
import org.squashtest.tm.api.plugin.PluginType;
import org.squashtest.tm.api.plugin.PluginValidationException;
import org.squashtest.tm.api.wizard.WorkspaceWizard;
import org.squashtest.tm.core.foundation.collection.DefaultFiltering;
import org.squashtest.tm.core.foundation.collection.DefaultPagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Filtering;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.attachment.AttachmentHolder;
import org.squashtest.tm.domain.bdd.BddImplementationTechnology;
import org.squashtest.tm.domain.bdd.BddScriptLanguage;
import org.squashtest.tm.domain.campaign.CampaignLibrary;
import org.squashtest.tm.domain.execution.ExecutionStatus;
import org.squashtest.tm.domain.project.AdministrableProject;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.domain.project.LibraryPluginBinding;
import org.squashtest.tm.service.bugtracker.BugTrackerFinderService;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.internal.project.ProjectHelper;
import org.squashtest.tm.service.internal.repository.ProjectDao;
import org.squashtest.tm.service.project.GenericProjectFinder;
import org.squashtest.tm.service.project.ProjectTemplateFinder;
import org.squashtest.tm.service.scmserver.ScmServerManagerService;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.testautomation.TestAutomationProjectFinderService;
import org.squashtest.tm.service.testautomation.TestAutomationServerManagerService;
import org.squashtest.tm.web.internal.controller.administration.PartyPermissionDatatableModelHelper;
import org.squashtest.tm.web.internal.controller.generic.ServiceAwareAttachmentTableModelHelper;
import org.squashtest.tm.web.internal.controller.project.ProjectPluginModel;
import org.squashtest.tm.web.internal.helper.JsonHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.plugins.manager.automationworkflow.AutomationWorkflowPluginManager;
import org.squashtest.tm.web.internal.plugins.manager.wizard.WorkspaceWizardManager;

@Controller
@RequestMapping(value={"/administration/projects"})
public class ProjectAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProjectAdministrationController.class);
    private static final String STATUS_ERROR = "ERROR";
    private static final String STATUS_OK = "OK";
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private GenericProjectFinder projectFinder;
    @Inject
    private ProjectTemplateFinder templateFinder;
    @Inject
    private BugTrackerFinderService bugtrackerFinderService;
    @Inject
    private InternationalizationHelper internationalizationHelper;
    @Inject
    private TestAutomationServerManagerService taServerService;
    @Inject
    private TestAutomationProjectFinderService taProjectFinderService;
    @Inject
    private ScmServerManagerService scmServerService;
    @Inject
    private WorkspaceWizardManager pluginManager;
    @Inject
    private AutomationWorkflowPluginManager workflowPluginManager;
    @Inject
    private ServiceAwareAttachmentTableModelHelper attachmentsHelper;
    @Inject
    private ConfigurationService configurationService;
    @Inject
    private ProjectDao projectDao;
    private static final String PROJECT_BUGTRACKER_NAME_UNDEFINED = "project.bugtracker.name.undefined";

    @ModelAttribute(value="projectsPageSize")
    public long populateProjectsPageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showProjects() {
        ModelAndView mav = new ModelAndView("page/projects/show-projects");
        mav.addObject("projects", (Object)this.projectFinder.findAllOrderedByName(Pagings.DEFAULT_PAGING));
        return mav;
    }

    @RequestMapping(value={"{projectId}"}, method={RequestMethod.GET})
    public ModelAndView showProjectEditor(@PathVariable long projectId, Locale locale) {
        return this.getProjectInfos(projectId, locale);
    }

    @RequestMapping(value={"{projectId}/info"}, method={RequestMethod.GET})
    public ModelAndView getProjectInfos(@PathVariable long projectId, Locale locale) {
        AdministrableProject adminProject = this.projectFinder.findAdministrableProjectById(projectId);
        List partyProjectPermissionsBean = (List)this.projectFinder.findPartyPermissionsBeanByProject((PagingAndSorting)new DefaultPagingAndSorting("login", Integer.valueOf(25)), (Filtering)DefaultFiltering.NO_FILTERING, projectId).getPagedItems();
        List<Object> partyPermissions = new PartyPermissionDatatableModelHelper(locale, this.internationalizationHelper).buildRawModel(partyProjectPermissionsBean, 1);
        List availablePermissions = this.projectFinder.findAllPossiblePermission();
        availablePermissions.sort(Comparator.comparing(it -> this.internationalizationHelper.internationalize("user.project-rights." + it.getSimpleName() + ".label", locale)));
        Map<String, String> automationWorkflows = this.getAvailableWorkflows(projectId, locale);
        LibraryPluginBinding lpb = this.projectDao.findPluginForProject(Long.valueOf(projectId), PluginType.AUTOMATION);
        WorkspaceWizard plugin = lpb != null ? (WorkspaceWizard)this.pluginManager.findAll().stream().filter(it -> it.getId().equals(lpb.getPluginId())).findAny().orElse(null) : null;
        boolean pluginAutomHasConf = plugin != null ? this.pluginManager.isHasConfiguration(plugin, projectId) : false;
        List availableTAServers = this.taServerService.findAllOrderedByName();
        Map jobUrls = this.taProjectFinderService.findProjectUrls(adminProject.getProject().getTestAutomationProjects());
        List availableScmServers = this.scmServerService.findAllOrderByName();
        Map<Long, String> comboDataMap = this.createComboDataForBugtracker(locale);
        CampaignLibrary cl = adminProject.getCampaignLibrary();
        HashMap<String, Boolean> allowedStatuses = new HashMap<String, Boolean>();
        allowedStatuses.put(ExecutionStatus.SETTLED.toString(), cl.allowsStatus(ExecutionStatus.SETTLED));
        allowedStatuses.put(ExecutionStatus.UNTESTABLE.toString(), cl.allowsStatus(ExecutionStatus.UNTESTABLE));
        List templatesList = this.templateFinder.findAllReferences();
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        ModelAndView mav = new ModelAndView("page/projects/project-info");
        mav.addObject("isAdmin", (Object)this.permissionEvaluationService.hasRole("ROLE_ADMIN"));
        mav.addObject("jobUrls", (Object)jobUrls);
        mav.addObject("templatesList", (Object)templatesList);
        mav.addObject("userLicenseInformationData", (Object)userLicenseInformation);
        mav.addObject("adminproject", (Object)adminProject);
        mav.addObject("bugtrackersList", (Object)JsonHelper.serialize(comboDataMap));
        mav.addObject("bugtrackersListEmpty", (Object)(comboDataMap.size() == 1 ? 1 : 0));
        mav.addObject("userPermissions", partyPermissions);
        mav.addObject("availablePermissions", (Object)availablePermissions);
        mav.addObject("allowTcModifDuringExec", (Object)adminProject.allowTcModifDuringExec());
        mav.addObject("allowedStatuses", allowedStatuses);
        mav.addObject("availableBddImplTechnologies", this.getAvailableBddImplTechnologies(locale));
        mav.addObject("chosenBddImplTechnology", (Object)adminProject.getProject().getBddImplementationTechnology().name());
        mav.addObject("availableBddScriptLanguages", this.getAvailableBddScriptLanguages(locale));
        mav.addObject("chosenBddScriptLanguage", (Object)adminProject.getProject().getBddScriptLanguage().name());
        mav.addObject("pluginAutomHasConf", (Object)pluginAutomHasConf);
        mav.addObject("allowAutomationWorkflow", (Object)adminProject.allowAutomationWorkflow());
        mav.addObject("chosenAutomationWorkflow", (Object)adminProject.getAutomationWorkflowType().getI18nKey());
        mav.addObject("availableAutomationWorkflows", automationWorkflows);
        mav.addObject("useTreeStructureInScmRepo", (Object)adminProject.useTreeStructureInScmRepo());
        mav.addObject("availableTAServers", (Object)availableTAServers);
        mav.addObject("availableScmServers", (Object)availableScmServers);
        mav.addObject("automatedSuitesLifetime", (Object)adminProject.getAutomatedSuitesLifetime());
        mav.addObject("attachments", this.attachmentsHelper.findAttachments((AttachmentHolder)adminProject.getProject()));
        return mav;
    }

    private Map<String, String> getAvailableBddImplTechnologies(Locale locale) {
        return Arrays.stream(BddImplementationTechnology.values()).collect(Collectors.toMap(Enum::name, bddImplTech -> this.internationalizationHelper.internationalize(bddImplTech.getI18nKey(), locale)));
    }

    private Map<String, String> getAvailableBddScriptLanguages(Locale locale) {
        return Arrays.stream(BddScriptLanguage.values()).collect(Collectors.toMap(Enum::name, bddScriptLanguage -> this.internationalizationHelper.internationalize(bddScriptLanguage.getI18nKey(), locale)));
    }

    private Map<String, String> getAvailableWorkflows(Long projectId, Locale locale) {
        Collection activePlugins = this.pluginManager.findEnabledWizards(projectId).stream().map(Plugin::getId).collect(Collectors.toList());
        return this.workflowPluginManager.getAutomationWorkflowsTypeFilteredByIds(activePlugins, locale);
    }

    @RequestMapping(value={"{projectId}/workflows"})
    @ResponseBody
    public Map<String, String> createComboDataForWorkflows(@PathVariable(value="projectId") Long projectId, Locale locale) {
        return this.getAvailableWorkflows(projectId, locale);
    }

    private Map<Long, String> createComboDataForBugtracker(Locale locale) {
        HashMap<Long, String> comboDataMap = new HashMap<Long, String>();
        for (BugTracker b : this.bugtrackerFinderService.findAll()) {
            if (b.getKind().equals("jira.xsquash")) continue;
            comboDataMap.put(b.getId(), HtmlUtils.htmlEscape((String)b.getName()));
        }
        comboDataMap.put(-1L, this.internationalizationHelper.internationalize(PROJECT_BUGTRACKER_NAME_UNDEFINED, locale));
        return comboDataMap;
    }

    @RequestMapping(value={"{projectId}/plugins"})
    public String getPluginsManager(@PathVariable(value="projectId") Long projectId, Model model, HttpServletRequest request) {
        GenericProject project = this.projectFinder.findById(projectId.longValue());
        Collection<WorkspaceWizard> plugins = this.pluginManager.findAll();
        Boolean isTemplate = ProjectHelper.isTemplate((GenericProject)project);
        ArrayList enabledPlugins = new ArrayList();
        enabledPlugins.addAll(project.getTestCaseLibrary().getEnabledPlugins());
        enabledPlugins.addAll(project.getRequirementLibrary().getEnabledPlugins());
        enabledPlugins.addAll(project.getCampaignLibrary().getEnabledPlugins());
        String context = request.getServletContext().getContextPath();
        Collection<ProjectPluginModel> models = this.toPluginModel(context, projectId, plugins, isTemplate);
        model.addAttribute("plugins", models);
        model.addAttribute("projectId", (Object)projectId);
        return "project-tabs/plugins-tab.html";
    }

    private Collection<ProjectPluginModel> toPluginModel(String servContext, long projectId, Collection<WorkspaceWizard> plugins, Boolean isTemplate) {
        ArrayList<ProjectPluginModel> output = new ArrayList<ProjectPluginModel>(plugins.size());
        EntityReference context = new EntityReference(EntityType.PROJECT, Long.valueOf(projectId));
        int loop = 1;
        for (WorkspaceWizard plugin : plugins) {
            boolean enabled = this.pluginManager.isActivePlugin(plugin, projectId);
            boolean hasConf = this.pluginManager.isHasConfiguration(plugin, projectId);
            ProjectPluginModel model = new ProjectPluginModel(plugin);
            model.setIndex(loop++);
            model.setEnabled(enabled);
            model.setHasConf(hasConf);
            model.setPluginType(plugin.getPluginType());
            String url = plugin.getConfigurationPath(context);
            if (url != null && !isTemplate.booleanValue()) {
                url = url.startsWith("/") ? url : "/" + url;
                model.setConfigUrl(String.valueOf(servContext) + url);
            } else {
                model.setConfigUrl("");
            }
            try {
                plugin.validate(context);
                model.setStatus(STATUS_OK);
            }
            catch (PluginValidationException damnit) {
                model.setStatus(STATUS_ERROR);
                LOGGER.debug("Plugin validation failed for Plugin " + plugin.getName(), (Throwable)damnit);
            }
            output.add(model);
        }
        return output;
    }
}

