/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.users.ActivePartyDetector;
import org.squashtest.tm.domain.users.Party;
import org.squashtest.tm.domain.users.PartyProjectPermissionsBean;
import org.squashtest.tm.security.acls.PermissionGroup;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class PartyPermissionDatatableModelHelper
extends DataTableModelBuilder<PartyProjectPermissionsBean> {
    private InternationalizationHelper messageSource;
    private Locale locale;
    private ActivePartyDetector activePartyDetector = new ActivePartyDetector();

    public PartyPermissionDatatableModelHelper(Locale locale, InternationalizationHelper messageSource) {
        this.locale = locale;
        this.messageSource = messageSource;
    }

    protected Map<?, ?> buildItemData(PartyProjectPermissionsBean item) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Party party = item.getParty();
        PermissionGroup group = item.getPermissionGroup();
        Boolean active = this.activePartyDetector.isActive(party);
        result.put("party-id", party.getId());
        result.put("party-active", active);
        result.put("party-name", HtmlUtils.htmlEscape((String)party.getName()));
        result.put("party-index", this.getCurrentIndex());
        result.put("permission-group", group);
        result.put("party-type", this.messageSource.internationalize("label." + party.getType().toLowerCase(), this.locale));
        result.put("empty-delete-holder", null);
        return result;
    }
}

