/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.Locale;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.domain.milestone.MilestoneStatus;
import org.squashtest.tm.domain.project.GenericProject;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.util.HTMLCleanupUtils;

public class MilestoneDataTableModelHelper
extends DataTableModelBuilder<Milestone> {
    private MilestoneManagerService milestoneManagerService;
    private InternationalizationHelper messageSource;
    private Locale locale;
    private GenericProject project;

    public Locale getLocale() {
        return this.locale;
    }

    public void setMilestoneManagerService(MilestoneManagerService milestoneManagerService) {
        this.milestoneManagerService = milestoneManagerService;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public InternationalizationHelper getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }

    public MilestoneDataTableModelHelper(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }

    public MilestoneDataTableModelHelper(InternationalizationHelper messageSource, Locale locale) {
        this.locale = locale;
        this.messageSource = messageSource;
    }

    @Override
    protected Object buildItemData(Milestone item) {
        HashMap<String, Object> row = new HashMap<String, Object>(12);
        Milestone auditable = item;
        row.put("entity-id", item.getId());
        row.put("index", this.getCurrentIndex() + 1L);
        row.put("label", HtmlUtils.htmlEscape((String)item.getLabel()));
        row.put("nbOfProjects", item.getNbOfBindedProject());
        row.put("description", HTMLCleanupUtils.cleanHtml(item.getDescription()));
        row.put("range", this.i18nRange(item.getRange()));
        row.put("owner", this.ownerToPrint(item));
        row.put("status", this.i18nStatus(item.getStatus()));
        Boolean isBoundToThisProject = false;
        if (this.project != null && this.milestoneManagerService.isMilestoneBoundToOneObjectOfProject(item, this.project)) {
            isBoundToThisProject = true;
        }
        row.put("binded-to-objects", this.messageSource.internationalizeYesNo(isBoundToThisProject, this.locale));
        row.put("endDate", this.messageSource.localizeDate(item.getEndDate(), this.locale).substring(0, 10));
        row.put("created-on", this.messageSource.localizeDate(auditable.getCreatedOn(), this.locale).substring(0, 10));
        row.put("created-by", HtmlUtils.htmlEscape((String)auditable.getCreatedBy()));
        row.put("last-mod-on", this.messageSource.localizeDate(auditable.getLastModifiedOn(), this.locale));
        row.put("last-mod-by", HTMLCleanupUtils.escapeOrDefault(auditable.getLastModifiedBy(), null));
        row.put("bindableToObject", item.getStatus().isBindableToObject());
        row.put("delete", "");
        row.put("checkbox", "");
        return row;
    }

    private String ownerToPrint(Milestone item) {
        String owner = null;
        owner = item.getRange() == MilestoneRange.GLOBAL ? this.messageSource.internationalize("label.milestone.global.owner", this.locale) : HtmlUtils.htmlEscape((String)item.getOwner().getName());
        return owner;
    }

    private String i18nRange(MilestoneRange milestoneRange) {
        String i18nKey = milestoneRange.getI18nKey();
        return this.messageSource.internationalize(i18nKey, this.locale);
    }

    private String i18nStatus(MilestoneStatus milestoneStatus) {
        String i18nKey = milestoneStatus.getI18nKey();
        return this.messageSource.internationalize(i18nKey, this.locale);
    }

    public void setProject(GenericProject project) {
        this.project = project;
    }
}

