/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import org.apache.commons.lang3.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.milestone.Milestone;
import org.squashtest.tm.domain.milestone.MilestoneRange;
import org.squashtest.tm.service.milestone.MilestoneManagerService;
import org.squashtest.tm.service.project.ProjectFinder;
import org.squashtest.tm.service.security.PermissionEvaluationService;
import org.squashtest.tm.service.user.UserAccountService;
import org.squashtest.tm.web.internal.controller.administration.MilestoneDataTableModelHelper;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneCloneStatusComboDataBuilder;
import org.squashtest.tm.web.internal.controller.milestone.MilestoneStatusComboDataBuilder;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;

@Controller
@RequestMapping(value={"administration/milestones"})
public class MilestoneAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MilestoneAdministrationController.class);
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private MilestoneManagerService milestoneManager;
    @Inject
    private PermissionEvaluationService permissionEvaluationService;
    @Inject
    private Provider<MilestoneStatusComboDataBuilder> statusComboDataBuilderProvider;
    @Inject
    private Provider<MilestoneCloneStatusComboDataBuilder> cloneStatusComboDataBuilderProvider;
    @Inject
    private ProjectFinder projectFinder;
    @Inject
    private UserAccountService userService;

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(method={RequestMethod.POST})
    public long addMilestone(@Valid @ModelAttribute(value="add-milestone") Milestone milestone) {
        this.setRange(milestone);
        this.setPerimeter(milestone);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("description " + milestone.getDescription());
            LOGGER.debug("label " + milestone.getLabel());
            LOGGER.debug("range " + milestone.getRange());
            LOGGER.debug("status " + milestone.getStatus());
            LOGGER.debug("end date " + milestone.getEndDate());
        }
        this.milestoneManager.addMilestone(milestone);
        return milestone.getId();
    }

    private void setRange(Milestone milestone) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(MilestoneRange.GLOBAL);
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
    }

    private void setPerimeter(Milestone milestone) {
        if (!this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            List projects = this.projectFinder.findAllICanManage();
            milestone.addProjectsToPerimeter(projects);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/{milestoneIds}"}, method={RequestMethod.DELETE})
    public void removeMilestones(@PathVariable(value="milestoneIds") List<Long> milestoneIds) {
        this.milestoneManager.removeMilestones(milestoneIds);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showMilestones(Locale locale) {
        ModelAndView mav = new ModelAndView("page/milestones/show-milestones");
        mav.addObject("milestoneStatus", ((MilestoneStatusComboDataBuilder)((MilestoneStatusComboDataBuilder)this.statusComboDataBuilderProvider.get()).useLocale(locale)).buildMap());
        mav.addObject("editableMilestoneIds", (Object)this.milestoneManager.findAllIdsOfEditableMilestone());
        mav.addObject("currentUser", (Object)StringEscapeUtils.escapeEcmaScript((String)this.userService.findCurrentUser().getName()));
        mav.addObject("isAdmin", (Object)this.permissionEvaluationService.hasRole("ROLE_ADMIN"));
        mav.addObject("milestoneCloneStatus", ((MilestoneCloneStatusComboDataBuilder)((MilestoneCloneStatusComboDataBuilder)this.cloneStatusComboDataBuilderProvider.get()).useLocale(locale)).buildMap());
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/list"})
    public DataTableModel getMilestonesTableModel(DataTableDrawParameters params, Locale locale) {
        MilestoneDataTableModelHelper helper = new MilestoneDataTableModelHelper(this.messageSource);
        helper.setLocale(locale);
        List<Object> aaData = helper.buildRawModel(this.milestoneManager.findAllVisibleToCurrentManager());
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }

    @ResponseBody
    @RequestMapping(value={"/{motherId}/clone"}, method={RequestMethod.POST})
    public long cloneMilestone(@Valid @ModelAttribute(value="new-milestone") Milestone milestone, @RequestParam boolean bindToRequirements, @RequestParam boolean bindToTestCases, @PathVariable(value="motherId") long motherId) {
        if (this.permissionEvaluationService.hasRole("ROLE_ADMIN")) {
            milestone.setRange(this.milestoneManager.findById(motherId).getRange());
        } else {
            milestone.setRange(MilestoneRange.RESTRICTED);
        }
        this.milestoneManager.cloneMilestone(motherId, milestone, bindToRequirements, bindToTestCases);
        return milestone.getId();
    }

    @ResponseBody
    @RequestMapping(value={"/{sourceId}/synchronize/{targetId}"}, method={RequestMethod.POST})
    public void synchronizeMilestone(@PathVariable(value="sourceId") long sourceId, @PathVariable(value="targetId") long targetId, @RequestParam boolean extendPerimeter, @RequestParam boolean isUnion) {
        this.milestoneManager.synchronize(sourceId, targetId, extendPerimeter, isUnion);
    }
}

