/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.inject.Inject;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.env.Environment;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/administration/log-file"})
public class LogfileController {
    @Value(value="${logging.dir}")
    private String loggingPath;
    @Inject
    private Environment environment;

    @RequestMapping(method={RequestMethod.GET})
    public void downloadLogfile(HttpServletResponse response) {
        try {
            File logfile = Arrays.asList(this.environment.getActiveProfiles()).contains("dev") ? new File(String.valueOf(this.loggingPath) + "/spring.log") : new File(String.valueOf(this.loggingPath) + "/squash-tm.log");
            response.setContentType("application/octet-stream");
            response.setHeader("Content-Disposition", "logfile; filename=" + logfile.getName().replace(" ", "_"));
            ServletOutputStream outStream = response.getOutputStream();
            this.writeContent(logfile, (OutputStream)outStream);
        }
        catch (IOException e) {
            response.setStatus(500);
            throw new RuntimeException(e);
        }
    }

    private void writeContent(File logfile, OutputStream outStream) throws IOException {
        try (FileInputStream fis = null;){
            int readByte;
            fis = new FileInputStream(logfile);
            do {
                if ((readByte = fis.read()) == -1) continue;
                outStream.write(readByte);
            } while (readByte != -1);
        }
    }
}

