/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.infolist.InfoList;
import org.squashtest.tm.domain.infolist.SystemInfoListCode;
import org.squashtest.tm.service.infolist.InfoListFinderService;
import org.squashtest.tm.service.infolist.IsBoundInfoListAdapter;
import org.squashtest.tm.web.internal.model.datatable.DataTable10Model;
import org.squashtest.tm.web.internal.model.datatable.DataTable10ModelAdaptor;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.util.IconLibrary;

@Controller
@RequestMapping(value={"/administration/info-lists"})
public class InfoListAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(InfoListAdministrationController.class);
    @Inject
    private InfoListFinderService infoListFinder;

    @ModelAttribute(value="tablePageSize")
    public long populateTablePageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showManager(Model model) {
        List lists = this.infoListFinder.findAllWithBoundInfo();
        model.addAttribute("infoLists", (Object)lists);
        model.addAttribute("icons", IconLibrary.getIconNames());
        return "info-list-manager.html";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"_"}, headers={"Accept=application/json, text/javascript"})
    @ResponseBody
    public DataTable10Model<IsBoundInfoListAdapter> getTableModel(@RequestParam(value="_") String echo, DataTableDrawParameters params, Locale locale) {
        DataTableModel model = new DataTableModel(echo);
        model.setAaData(this.infoListFinder.findAllWithBoundInfo());
        return DataTable10ModelAdaptor.adapt(model);
    }

    @RequestMapping(value={"/{infoListId}"}, method={RequestMethod.GET})
    public String showInfoListModificationPage(@PathVariable Long infoListId, Model model) {
        InfoList list = this.infoListFinder.findById(infoListId);
        SystemInfoListCode.verifyModificationPermission((InfoList)list);
        model.addAttribute("infoList", (Object)list);
        model.addAttribute("itemListIcons", IconLibrary.getIconNames());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("id " + list.getId());
            LOGGER.debug("label " + list.getLabel());
            LOGGER.debug("code " + list.getCode());
            LOGGER.debug("description " + list.getDescription());
        }
        return "info-list-modification.html";
    }
}

