/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.core.foundation.collection.Pagings;
import org.squashtest.tm.domain.customfield.CustomField;
import org.squashtest.tm.domain.customfield.InputType;
import org.squashtest.tm.service.customfield.CustomFieldManagerService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/custom-fields"})
public final class CustomFieldAdministrationController {
    private static final String NAME = "name";
    private static final String LABEL = "label";
    private static final String INPUT_TYPE = "inputType";
    private static final String CUSTOM_FIELDS = "customFields";
    private CustomFieldManagerService customFieldManagerService;
    @Inject
    private InternationalizationHelper messageSource;
    private final DatatableMapper<String> customFieldTableMapper = new NameBasedMapper(3).map("name", "name").map("label", "label").map("input-type", "inputType");

    @Inject
    public void setCustomFieldManagerService(CustomFieldManagerService customFieldManagerService) {
        this.customFieldManagerService = customFieldManagerService;
    }

    @ModelAttribute(value="inputTypes")
    public InputType[] populateInputTypes() {
        return InputType.values();
    }

    @ModelAttribute(value="customFieldsPageSize")
    public long populateCustomFieldsPageSize() {
        return Pagings.DEFAULT_PAGING.getPageSize();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String showManager(Model model) {
        List customFields = this.customFieldManagerService.findAllOrderedByName();
        model.addAttribute(CUSTOM_FIELDS, (Object)customFields);
        return "custom-field-manager.html";
    }

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getCustomFieldsTableModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.customFieldTableMapper);
        Page cfs = this.customFieldManagerService.findSortedCustomFields(pageable);
        return new CustomFieldDataTableModelHelper(locale).buildDataModel(cfs, params.getsEcho());
    }

    @RequestMapping(value={"/{customFieldId}"}, method={RequestMethod.DELETE})
    @ResponseBody
    public void deleteCustomField(@PathVariable List<Long> customFieldId) {
        this.customFieldManagerService.deleteCustomField(customFieldId);
    }

    private final class CustomFieldDataTableModelHelper
    extends DataTableModelBuilder<CustomField> {
        private Locale locale;

        private CustomFieldDataTableModelHelper(Locale locale) {
            this.locale = locale;
        }

        public Map<String, Object> buildItemData(CustomField item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put(CustomFieldAdministrationController.NAME, HtmlUtils.htmlEscape((String)item.getName()));
            res.put(CustomFieldAdministrationController.LABEL, HtmlUtils.htmlEscape((String)item.getLabel()));
            res.put("raw-input-type", item.getInputType().name());
            res.put("input-type", CustomFieldAdministrationController.this.messageSource.internationalize(item.getInputType().getI18nKey(), this.locale));
            res.put("empty-delete-holder", " ");
            return res;
        }
    }
}

