/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.io.File;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.inject.Inject;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.squashtest.tm.core.foundation.collection.ColumnFiltering;
import org.squashtest.tm.core.foundation.collection.PagedCollectionHolder;
import org.squashtest.tm.core.foundation.collection.PagingAndSorting;
import org.squashtest.tm.domain.users.ConnectionLog;
import org.squashtest.tm.service.connectionhistory.ConnectionLogExportService;
import org.squashtest.tm.service.connectionhistory.ConnectionLogFinderService;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableColumnFiltering;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;
import org.squashtest.tm.web.internal.model.datatable.DataTableSorting;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/connections"})
public class ConnectionController {
    private static final String FILENAME = "filename";
    private static final String LOGIN = "login";
    private static final String ID = "id";
    private static final String CONNECTION_DATE_KEY = "connection-date";
    private static final String CONNECTION_DATE_ATTRIBUTE = "connectionDate";
    private static final String SUCCESS_KEY = "successful";
    private static final String SUCCESS_ATTRIBUTE = "success";
    @Inject
    protected InternationalizationHelper messageSource;
    @Inject
    private ConnectionLogFinderService connectionLogFinderServiceservice;
    @Inject
    private ConnectionLogExportService connectionLogExportService;
    private DatatableMapper<String> connectionsMapper = new NameBasedMapper(9).mapAttribute("entity-id", "id", ConnectionLog.class).mapAttribute("login", "login", ConnectionLog.class).mapAttribute("connection-date", "connectionDate", ConnectionLog.class).mapAttribute("successful", "success", ConnectionLog.class);
    private static final Logger LOGGER = LoggerFactory.getLogger(ConnectionController.class);

    @RequestMapping(method={RequestMethod.GET}, params={"sEcho"})
    @ResponseBody
    public DataTableModel getTableModel(DataTableDrawParameters params, Locale locale) {
        DataTableSorting paging = new DataTableSorting(params, this.connectionsMapper);
        DataTableColumnFiltering columnFiltering = new DataTableColumnFiltering(params);
        PagedCollectionHolder holder = this.connectionLogFinderServiceservice.findAllFiltered((PagingAndSorting)paging, (ColumnFiltering)columnFiltering);
        return new ConnectionLogsDataTableModelHelper(locale, this.messageSource).buildDataModel(holder, params.getsEcho());
    }

    @ResponseBody
    @RequestMapping(value={"/exports"}, method={RequestMethod.GET}, params={"sEcho"})
    public FileSystemResource exportConnectionHistoryExcel(@RequestParam(value="filename") String filename, DataTableDrawParameters params, HttpServletResponse response) {
        DataTableColumnFiltering columnFiltering = new DataTableColumnFiltering(params);
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment; filename=" + filename + ".csv");
        File export = this.connectionLogExportService.exportConnectionLogsToCsv((ColumnFiltering)columnFiltering);
        return new FileSystemResource(export);
    }

    private static final class ConnectionLogsDataTableModelHelper
    extends DataTableModelBuilder<ConnectionLog> {
        private InternationalizationHelper messageSource;
        private Locale locale;

        private ConnectionLogsDataTableModelHelper(Locale locale, InternationalizationHelper messageSource) {
            this.locale = locale;
            this.messageSource = messageSource;
        }

        protected Map<String, Object> buildItemData(ConnectionLog item) {
            HashMap<String, Object> res = new HashMap<String, Object>();
            res.put("entity-id", item.getId());
            res.put("entity-index", this.getCurrentIndex());
            res.put(ConnectionController.LOGIN, item.getLogin());
            res.put(ConnectionController.CONNECTION_DATE_KEY, this.messageSource.localizeDate(item.getConnectionDate(), this.locale));
            res.put(ConnectionController.SUCCESS_KEY, item.getSuccess());
            return res;
        }
    }
}

