/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.provider.ClientAlreadyExistsException;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.client.BaseClientDetails;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.exception.WrongUrlException;
import org.squashtest.tm.exception.client.ClientNameAlreadyExistsException;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.feature.FeatureManager;
import org.squashtest.tm.service.security.OAuth2ClientService;
import org.squashtest.tm.service.user.UserManagerService;
import org.squashtest.tm.web.internal.controller.administration.ClientDataTableModelHelper;
import org.squashtest.tm.web.internal.controller.administration.ClientModel;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;

@Controller
@RequestMapping(value={"administration/config"})
public class ConfigAdministrationController {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConfigAdministrationController.class);
    private static final String WHITE_LIST = "uploadfilter.fileExtensions.whitelist";
    private static final String UPLOAD_SIZE_LIMIT = "uploadfilter.upload.sizeLimitInBytes";
    private static final String IMPORT_SIZE_LIMIT = "uploadfilter.upload.import.sizeLimitInBytes";
    @Value(value="${squashtm.stack.trace.control.panel.visible:false}")
    private Boolean stackTracePanel;
    @Inject
    private ConfigurationService configService;
    @Inject
    private OAuth2ClientService clientService;
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private FeatureManager features;
    @Inject
    private UserManagerService userManager;

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public void changeConfig(@RequestParam(value="uploadfilter.fileExtensions.whitelist") String whiteList, @RequestParam(value="uploadfilter.upload.sizeLimitInBytes") String uploadSizeLimit, @RequestParam(value="uploadfilter.upload.import.sizeLimitInBytes") String importSizeLimit) {
        this.configService.updateConfiguration(WHITE_LIST, whiteList);
        this.configService.updateConfiguration(UPLOAD_SIZE_LIMIT, uploadSizeLimit);
        this.configService.updateConfiguration(IMPORT_SIZE_LIMIT, importSizeLimit);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView administration() {
        ModelAndView mav = new ModelAndView("page/administration/config");
        mav.addObject("whiteList", (Object)this.configService.findConfiguration(WHITE_LIST));
        mav.addObject("uploadSizeLimit", (Object)this.configService.findConfiguration(UPLOAD_SIZE_LIMIT));
        mav.addObject("uploadImportSizeLimit", (Object)this.configService.findConfiguration(IMPORT_SIZE_LIMIT));
        mav.addObject("callbackUrl", (Object)this.configService.findConfiguration("squashtest.tm.callbackurl"));
        mav.addObject("caseInsensitiveLogin", (Object)this.features.isEnabled(FeatureManager.Feature.CASE_INSENSITIVE_LOGIN));
        mav.addObject("duplicateLogins", (Object)this.userManager.findAllDuplicateLogins());
        mav.addObject("shouldDisplayStackTraceControlPanel", (Object)this.stackTracePanel);
        mav.addObject("stackTrace", (Object)this.features.isEnabled(FeatureManager.Feature.STACK_TRACE));
        mav.addObject("autoconnectOnConnection", (Object)this.features.isEnabled(FeatureManager.Feature.AUTOCONNECT_ON_CONNECTION));
        return mav;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=whiteList", "value"})
    @ResponseBody
    public String changeWhiteList(@RequestParam(value="value") String newWhiteList) {
        this.configService.updateConfiguration(WHITE_LIST, newWhiteList);
        return newWhiteList;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=uploadSizeLimit", "value"})
    @ResponseBody
    public String changeUploadSizeLimit(@RequestParam(value="value") String newUploadSizeLimit) {
        this.configService.updateConfiguration(UPLOAD_SIZE_LIMIT, newUploadSizeLimit);
        return newUploadSizeLimit;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=uploadImportSizeLimit", "value"})
    @ResponseBody
    public String changeUploadImportSizeLimit(@RequestParam(value="value") String newUploadImportSizeLimit) {
        this.configService.updateConfiguration(IMPORT_SIZE_LIMIT, newUploadImportSizeLimit);
        return newUploadImportSizeLimit;
    }

    @RequestMapping(method={RequestMethod.POST}, params={"id=callbackUrl", "value"})
    @ResponseBody
    public String changeCallbackUrl(@RequestParam(value="value") String newCallbackUrl) {
        try {
            new URL(newCallbackUrl);
        }
        catch (MalformedURLException ex) {
            throw new WrongUrlException("callbackUrl", (Throwable)ex);
        }
        this.configService.set("squashtest.tm.callbackurl", newCallbackUrl);
        return newCallbackUrl;
    }

    @ResponseBody
    @RequestMapping(value={"clients/{idList}"}, method={RequestMethod.DELETE})
    public void removeMilestones(@PathVariable(value="idList") List<String> idList) {
        this.clientService.removeClientDetails(idList);
    }

    @ResponseBody
    @ResponseStatus(value=HttpStatus.CREATED)
    @RequestMapping(value={"clients"}, method={RequestMethod.POST})
    public ClientDetails addClient(@Valid @ModelAttribute(value="add-client") ClientModel model) {
        BaseClientDetails clientDetails = this.convertClientModelToBaseClientDetails(model);
        try {
            this.clientService.addClientDetails((ClientDetails)clientDetails);
        }
        catch (ClientAlreadyExistsException ex) {
            throw new ClientNameAlreadyExistsException((Exception)((Object)ex));
        }
        return clientDetails;
    }

    private BaseClientDetails convertClientModelToBaseClientDetails(ClientModel model) {
        BaseClientDetails clientDetails = new BaseClientDetails();
        clientDetails.setClientId(model.getClientId());
        clientDetails.setClientSecret(model.getClientSecret());
        HashSet<String> uris = new HashSet<String>();
        uris.add(model.getRegisteredRedirectUri());
        clientDetails.setRegisteredRedirectUri(uris);
        return clientDetails;
    }

    @RequestMapping(value={"clients/list"})
    @ResponseBody
    public DataTableModel getClientsTableModel(Locale locale) {
        ClientDataTableModelHelper helper = new ClientDataTableModelHelper(this.messageSource);
        helper.setLocale(locale);
        List<Object> aaData = helper.buildRawModel(this.clientService.findClientDetailsList());
        DataTableModel<Object> model = new DataTableModel<Object>("");
        model.setAaData(aaData);
        return model;
    }
}

