/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.Locale;
import java.util.Set;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class ClientDataTableModelHelper
extends DataTableModelBuilder<ClientDetails> {
    private InternationalizationHelper messageSource;
    private Locale locale;

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public InternationalizationHelper getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }

    public ClientDataTableModelHelper(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }

    public String formatRegisteredRedirectUri(Set<String> registeredRedirectUri) {
        StringBuilder builder = new StringBuilder();
        for (String uri : registeredRedirectUri) {
            builder.append(uri).append(" ");
        }
        return builder.toString();
    }

    @Override
    protected Object buildItemData(ClientDetails item) {
        HashMap<String, Object> row = new HashMap<String, Object>(3);
        row.put("entity-id", item.getClientId());
        row.put("index", this.getCurrentIndex() + 1L);
        row.put("name", HtmlUtils.htmlEscape((String)item.getClientId()));
        row.put("secret", item.getClientSecret());
        row.put("redirect_uri", this.formatRegisteredRedirectUri(item.getRegisteredRedirectUri()));
        row.put("delete", "");
        return row;
    }
}

