/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.web.util.HtmlUtils;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableModelBuilder;

public class BugtrackerDataTableModelHelper
extends DataTableModelBuilder<BugTracker> {
    private InternationalizationHelper messageSource;
    private Locale locale;

    public BugtrackerDataTableModelHelper(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }

    public Map<String, Object> buildItemData(BugTracker item) {
        HashMap<String, Object> row = new HashMap<String, Object>(7);
        String isIframeFriendlyStringValue = item.isIframeFriendly() ? this.messageSource.internationalize("squashtm.truefalse.true", this.locale) : this.messageSource.internationalize("squashtm.truefalse.false", this.locale);
        row.put("entity-id", item.getId());
        row.put("index", this.getCurrentIndex());
        row.put("name", HtmlUtils.htmlEscape((String)item.getName()));
        row.put("kind", item.getKind());
        row.put("url", item.getUrl());
        row.put("iframe-friendly", isIframeFriendlyStringValue);
        row.put("delete", "");
        return row;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    public InternationalizationHelper getMessageSource() {
        return this.messageSource;
    }

    public void setMessageSource(InternationalizationHelper messageSource) {
        this.messageSource = messageSource;
    }
}

