/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import java.util.Locale;
import java.util.Set;
import javax.inject.Inject;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.csp.core.bugtracker.domain.BugTracker;
import org.squashtest.tm.service.bugtracker.BugTrackerManagerService;
import org.squashtest.tm.web.internal.controller.administration.BugtrackerDataTableModelHelper;
import org.squashtest.tm.web.internal.i18n.InternationalizationHelper;
import org.squashtest.tm.web.internal.model.datatable.DataTableDrawParameters;
import org.squashtest.tm.web.internal.model.datatable.DataTableModel;
import org.squashtest.tm.web.internal.model.datatable.SpringPagination;
import org.squashtest.tm.web.internal.model.viewmapper.DatatableMapper;
import org.squashtest.tm.web.internal.model.viewmapper.NameBasedMapper;

@Controller
@RequestMapping(value={"/administration/bugtrackers"})
public class BugTrackerAdministrationController {
    @Inject
    private InternationalizationHelper messageSource;
    @Inject
    private BugTrackerManagerService bugTrackerManagerService;
    private static final Logger LOGGER = LoggerFactory.getLogger(BugTrackerAdministrationController.class);
    private DatatableMapper<String> bugtrackerMapper = new NameBasedMapper().map("id", "id").map("name", "name").map("kind", "kind").map("url", "url").map("iframe-friendly", "iframeFriendly");

    @ResponseBody
    @RequestMapping(method={RequestMethod.POST})
    public void createBugTracker(@Valid @ModelAttribute(value="add-bugtracker") BugTracker bugtracker) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("name " + bugtracker.getName());
            LOGGER.debug("kind " + bugtracker.getKind());
            LOGGER.debug("iframe " + bugtracker.isIframeFriendly());
            LOGGER.debug("url " + bugtracker.getUrl());
        }
        this.bugTrackerManagerService.addBugTracker(bugtracker);
    }

    @RequestMapping(method={RequestMethod.GET})
    public ModelAndView showBugtrackers() {
        Set bugtrackerKinds = this.bugTrackerManagerService.findBugTrackerKinds();
        ModelAndView mav = new ModelAndView("page/bugtrackers/show-bugtrackers");
        mav.addObject("bugtrackerKinds", (Object)bugtrackerKinds);
        return mav;
    }

    @ResponseBody
    @RequestMapping(value={"/list"}, params={"sEcho"})
    public DataTableModel getBugtrackerTableModel(DataTableDrawParameters params, Locale locale) {
        Pageable pageable = SpringPagination.pageable(params, this.bugtrackerMapper);
        Page holder = this.bugTrackerManagerService.findSortedBugtrackers(pageable);
        BugtrackerDataTableModelHelper helper = new BugtrackerDataTableModelHelper(this.messageSource);
        helper.setLocale(locale);
        return helper.buildDataModel(holder, params.getsEcho());
    }
}

