/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.administration;

import javax.inject.Inject;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.servlet.ModelAndView;
import org.squashtest.tm.domain.AdministrationStatistics;
import org.squashtest.tm.service.configuration.ConfigurationService;
import org.squashtest.tm.service.user.AdministrationService;

@Controller
public class AdministrationController {
    @Inject
    private AdministrationService administrationService;
    @Inject
    private ConfigurationService configurationService;
    @Value(value="${info.app.version}")
    private String sqTMversion;

    @RequestMapping(value={"/administration"})
    public ModelAndView administration() {
        AdministrationStatistics adminStat = this.administrationService.findAdministrationStatistics();
        ModelAndView mav = new ModelAndView("page/administration/administration");
        mav.addObject("adminStats", (Object)adminStat);
        mav.addObject("sqTMversion", (Object)this.sqTMversion);
        String userLicenseInformation = this.configurationService.findConfiguration("activated.user.excess");
        String dateLicenseInformation = this.configurationService.findConfiguration("plugin.license.expiration");
        mav.addObject("userLicenseInformation", (Object)userLicenseInformation);
        mav.addObject("dateLicenseInformation", dateLicenseInformation == null || dateLicenseInformation.isEmpty() ? null : Integer.valueOf(dateLicenseInformation));
        return mav;
    }
}

