/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.controller.actionword;

import java.util.Locale;
import org.apache.commons.lang3.StringUtils;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

public class ActionWordModel {
    private String name;
    private String description;

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public static class ActionWordModelValidator
    implements Validator {
        private MessageSource messageSource;

        public ActionWordModelValidator(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public MessageSource getMessageSource() {
            return this.messageSource;
        }

        public void setMessageSource(MessageSource messageSource) {
            this.messageSource = messageSource;
        }

        public boolean supports(Class<?> aClass) {
            return aClass.equals(ActionWordModel.class);
        }

        public void validate(Object target, Errors errors) {
            Locale locale = LocaleContextHolder.getLocale();
            String notBlank = this.messageSource.getMessage("message.actionword.empty", null, locale);
            String notNull = this.messageSource.getMessage("message.actionword.null", null, locale);
            ActionWordModel model = (ActionWordModel)target;
            String modelName = model.getName();
            if (modelName == null) {
                errors.rejectValue("name", "message.notNull", notNull);
            } else if (StringUtils.isBlank((CharSequence)modelName)) {
                errors.rejectValue("name", "message.notBlank", notBlank);
            }
        }
    }
}

