/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.internal.context;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ResourceLoaderAware;
import org.springframework.context.support.ReloadableResourceBundleMessageSource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.squashtest.tm.api.config.SquashPathProperties;

public class ReloadableSquashTmMessageSource
extends ReloadableResourceBundleMessageSource
implements ResourceLoaderAware {
    private static final Logger LOGGER = LoggerFactory.getLogger(ReloadableSquashTmMessageSource.class);
    private static final String PLUGIN_MESSAGES_SCAN_PATTERN = "WEB-INF/messages/**";
    private static final String MESSAGES_BASE_PATH = "/WEB-INF/messages/";
    private ResourcePatternResolver resourcePatternResolver;
    private String[] basenames;
    private SquashPathProperties squashPathProperties;

    public void setResourceLoader(ResourceLoader resourceLoader) {
        super.setResourceLoader(resourceLoader);
        this.resourcePatternResolver = resourceLoader instanceof ResourcePatternResolver ? (ResourcePatternResolver)resourceLoader : new PathMatchingResourcePatternResolver(resourceLoader);
    }

    public void setBasenames(String ... basenames) {
        this.basenames = basenames;
        super.setBasenames(basenames);
    }

    @PostConstruct
    public void registerFragmentMessageProperties() {
        try {
            LinkedHashSet<String> consolidatedBasenames = new LinkedHashSet<String>();
            LOGGER.debug("About to scan for external language pack basenames to build MessageSource");
            this.addExternalBasenames(consolidatedBasenames);
            LOGGER.debug("About to register configured basenames to build MessageSource");
            this.addConfiguredBasenames(consolidatedBasenames);
            LOGGER.debug("About to scan {} for additional fragment / plugin basenames", (Object)PLUGIN_MESSAGES_SCAN_PATTERN);
            this.addLookedUpBasenames(consolidatedBasenames);
            LOGGER.debug("About to scan classpath for plugin language packs to build MessageSource");
            this.addPluginBasenames(consolidatedBasenames);
            super.setBasenames(consolidatedBasenames.toArray(new String[consolidatedBasenames.size()]));
        }
        catch (IOException e) {
            LOGGER.warn("Error during message source initialization, some messages may not be properly translated.", (Throwable)e);
        }
    }

    private void addPluginBasenames(Set<String> consolidatedBasenames) throws IOException {
        Resource[] resources;
        Resource[] resourceArray = resources = this.resourcePatternResolver.getResources("classpath*:org/squashtest/tm/plugin/**/messages.properties");
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            Resource resource = resourceArray[n2];
            try {
                if (resource.exists()) {
                    String path = resource.getURL().getPath();
                    int bang = path.lastIndexOf(33);
                    String basename = "classpath:" + StringUtils.removeEnd((String)path.substring(bang + 2), (String)".properties");
                    consolidatedBasenames.add(basename);
                    LOGGER.info("Registering *discovered* plugin classpath path {} as a basename for application MessageSource", (Object)basename);
                }
            }
            catch (IOException e) {
                LOGGER.info("An IO error occurred while looking up plugin language resources '{}': {}", (Object)resource, (Object)e.getMessage());
                LOGGER.debug("Plugin language resources lookup error for resource {}", (Object)resource, (Object)e);
            }
            ++n2;
        }
    }

    private void addExternalBasenames(Set<String> consolidatedBasenames) {
        String locationPattern = String.valueOf(this.squashPathProperties.getLanguagesPath()) + "/**/messages.properties";
        if (!locationPattern.startsWith("file:")) {
            locationPattern = "file:" + locationPattern;
        }
        try {
            Resource[] resources;
            Resource[] resourceArray = resources = this.resourcePatternResolver.getResources(locationPattern);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (resource.exists()) {
                    String basename = StringUtils.removeEnd((String)resource.getURL().getPath(), (String)".properties");
                    consolidatedBasenames.add(basename);
                    LOGGER.info("Registering *discovered* external path {} as a basename for application MessageSource", (Object)basename);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            LOGGER.info("An IO error occurred while looking up external language resources '{}' : {}", (Object)locationPattern, (Object)e.getMessage());
            LOGGER.debug("External language lookup error. Current path : {}", (Object)new File(".").toString(), (Object)e);
        }
    }

    private void addLookedUpBasenames(Set<String> consolidatedBasenames) {
        try {
            Resource[] resources;
            Resource[] resourceArray = resources = this.resourcePatternResolver.getResources(PLUGIN_MESSAGES_SCAN_PATTERN);
            int n = resources.length;
            int n2 = 0;
            while (n2 < n) {
                Resource resource = resourceArray[n2];
                if (this.isFirstLevelDirectory(resource)) {
                    String basename = MESSAGES_BASE_PATH + resource.getFilename() + "/messages";
                    consolidatedBasenames.add(basename);
                    LOGGER.info("Registering *discovered* path {} as a basename for application MessageSource", (Object)basename);
                }
                ++n2;
            }
        }
        catch (IOException e) {
            LOGGER.info("Error during bean initialization, no fragment messages will be registered. Maybe there are no fragments.", (Throwable)e);
        }
    }

    private void addConfiguredBasenames(Set<String> consolidatedBasenames) {
        if (this.basenames != null) {
            String[] stringArray = this.basenames;
            int n = this.basenames.length;
            int n2 = 0;
            while (n2 < n) {
                String basename = stringArray[n2];
                consolidatedBasenames.add(basename);
                LOGGER.info("Registering *configured* path {} as a basename for application MessageSource", (Object)basename);
                ++n2;
            }
        }
    }

    private boolean isFirstLevelDirectory(Resource resource) throws IOException {
        if (!resource.exists()) {
            return false;
        }
        URL url = resource.getURL();
        return url.getPath().endsWith(MESSAGES_BASE_PATH + resource.getFilename() + '/');
    }

    public void setSquashPathProperties(SquashPathProperties squashPathProperties) {
        this.squashPathProperties = squashPathProperties;
    }
}

