/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.servlet.Filter;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.config.annotation.ObjectPostProcessor;
import org.springframework.security.config.annotation.web.HttpSecurityBuilder;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.config.annotation.web.builders.WebSecurity;
import org.springframework.security.config.annotation.web.configuration.WebSecurityConfigurerAdapter;
import org.springframework.security.config.annotation.web.configurers.ExpressionUrlAuthorizationConfigurer;
import org.springframework.security.config.annotation.web.configurers.FormLoginConfigurer;
import org.springframework.security.config.annotation.web.configurers.HttpBasicConfigurer;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.www.BasicAuthenticationFilter;
import org.springframework.security.web.context.SecurityContextPersistenceFilter;
import org.springframework.security.web.savedrequest.RequestCache;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.web.filter.HttpPutFormContentFilter;
import org.squashtest.tm.api.security.authentication.ApiSecurityExemptionEndPoint;
import org.squashtest.tm.api.security.authentication.SecurityExemptionEndPoint;
import org.squashtest.tm.web.config.MainEntryPoint;
import org.squashtest.tm.web.config.SquashAuthenticationSuccessHandler;
import org.squashtest.tm.web.internal.controller.authentication.HttpSessionRequestCacheWithExceptions;

@Configuration
public class WebSecurityConfig {
    private static final String ALTERNATE_AUTH_PATH = "/auth/**";
    private static final String LOGIN = "/login";
    private static final String ROOT_PATH = "/";

    @Configuration
    @Order(value=20)
    public static class ApiWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${squash.security.basic.token-charset}")
        private String basicAuthCharset = "ISO-8859-1";
        @Autowired(required=false)
        private final Collection<ApiSecurityExemptionEndPoint> apiSecurityExemptionEndPoints = Collections.emptyList();

        public void configure(WebSecurity webSecurity) {
            webSecurity.ignoring().antMatchers(this.gatherIgnoringAuthUrlPatterns());
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpBasicConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).authorizeRequests().antMatchers(this.gatherIgnoringAuthUrlPatterns())).permitAll().and()).antMatcher("/api/**").authorizeRequests().anyRequest()).authenticated().and()).httpBasic().withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(this.basicAuthCharset))).realmName("squash-api").authenticationEntryPoint(new AuthenticationEntryPoint(){

                public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
                    response.addHeader("WWW-Authenticate", "Basic realm=\"squah-api\"");
                    response.addHeader("Content-Type", "application/json");
                    response.sendError(401, String.valueOf(authException.getMessage()) + ". You may authenticate using " + "1/ basic authentication or " + "2/ fetching a cookie JSESSIONID from /login");
                }
            }).and()).logout().permitAll().logoutRequestMatcher((RequestMatcher)new AntPathRequestMatcher("/logout")).invalidateHttpSession(true).logoutSuccessUrl(WebSecurityConfig.ROOT_PATH);
        }

        private String[] gatherIgnoringAuthUrlPatterns() {
            ArrayList result = new ArrayList();
            for (ApiSecurityExemptionEndPoint endPoint : this.apiSecurityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreAuthUrlPatterns());
            }
            return result.toArray(new String[0]);
        }
    }

    private static final class BasicAuthCharsetConfigurer
    implements ObjectPostProcessor<BasicAuthenticationFilter> {
        private final String charset;

        public BasicAuthCharsetConfigurer(String charset) {
            this.charset = charset;
        }

        public <O extends BasicAuthenticationFilter> O postProcess(O object) {
            object.setCredentialsCharset(this.charset);
            return object;
        }
    }

    @Configuration
    @Order(value=10)
    public static class SquashTAWebSecurityConfigurationAdapter
    extends WebSecurityConfigurerAdapter {
        @Value(value="${squash.security.basic.token-charset}")
        private String basicAuthCharset = "ISO-8859-1";

        @Bean
        public AuthenticationManager authenticationManagerBean() throws Exception {
            return super.authenticationManagerBean();
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)http.csrf().disable()).antMatcher("/automated-executions/**").authorizeRequests().anyRequest()).access("hasRole('ROLE_TA_API_CLIENT')").and()).httpBasic().withObjectPostProcessor((ObjectPostProcessor)new BasicAuthCharsetConfigurer(this.basicAuthCharset));
        }
    }

    @Configuration
    @Order(value=30)
    public static class StandardWebSecurityConfigurerAdapter
    extends WebSecurityConfigurerAdapter {
        private static final List<String> DEFAULT_IGNORE_AUTH_URLS = Arrays.asList("/", "/login", "/auth/**", "/logout", "/logged-out");
        @Autowired(required=false)
        private Collection<SecurityExemptionEndPoint> securityExemptionEndPoints = Collections.EMPTY_LIST;
        @Value(value="${squash.security.filter.debug.enabled:false}")
        private boolean debugSecurityFilter;
        @Value(value="${squash.security.preferred-auth-url:/login}")
        private String entryPointUrl = "/login";
        @Value(value="${squash.security.ignored:/scripts/**}")
        private String[] secIngored;
        @Inject
        SquashAuthenticationSuccessHandler successHandler;

        public void configure(WebSecurity web) throws Exception {
            web.debug(this.debugSecurityFilter).ignoring().antMatchers(this.secIngored);
        }

        protected void configure(HttpSecurity http) throws Exception {
            ((HttpSecurity)((HttpSecurity)((FormLoginConfigurer)((FormLoginConfigurer)((FormLoginConfigurer)((HttpSecurity)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((ExpressionUrlAuthorizationConfigurer.AuthorizedUrl)((HttpSecurity)((HttpSecurity)((HttpSecurity)((HttpSecurity)http.csrf().ignoringAntMatchers(this.gatherIgnoringCsrfUrlPatterns()).and()).headers().defaultsDisabled().cacheControl().and().frameOptions().sameOrigin().and()).requestCache().requestCache((RequestCache)new HttpSessionRequestCacheWithExceptions((HttpSecurityBuilder<?>)http, "/error")).and()).exceptionHandling().authenticationEntryPoint(this.mainEntryPoint()).and()).authorizeRequests().antMatchers(this.gatherIgnoringAuthUrlPatterns())).permitAll().antMatchers(new String[]{"/administration", "/administration/milestones", "/administration/milestones/**", "/milestone/**", "/administration/info-lists", "/administration/info-lists/**", "/administration/projects", "/administration/projects/**", "/administration/scm-repositories"})).access("hasRole('ROLE_ADMIN') or hasRole('ROLE_TM_PROJECT_MANAGER')").antMatchers(new String[]{"/admin", "/admin/**", "/administration/**", "/configuration", "/configuration/**", "/platform/**"})).access("hasRole('ROLE_ADMIN')").antMatchers(new String[]{"/accessDenied"})).permitAll().antMatchers(new String[]{"/management/**"})).denyAll().anyRequest()).authenticated().and()).formLogin().permitAll()).loginPage(WebSecurityConfig.LOGIN).failureUrl("/login?error")).successHandler((AuthenticationSuccessHandler)this.successHandler)).and()).logout().permitAll().invalidateHttpSession(true).logoutSuccessUrl("/logged-out").and()).addFilterAfter((Filter)new HttpPutFormContentFilter(), SecurityContextPersistenceFilter.class);
        }

        @Bean
        public AuthenticationEntryPoint mainEntryPoint() {
            MainEntryPoint entryPoint = new MainEntryPoint(this.entryPointUrl);
            return entryPoint;
        }

        private String[] gatherIgnoringCsrfUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>();
            result.add(WebSecurityConfig.ALTERNATE_AUTH_PATH);
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreCsrfUrlPatterns());
            }
            return result.toArray(new String[result.size()]);
        }

        private String[] gatherIgnoringAuthUrlPatterns() {
            ArrayList<String> result = new ArrayList<String>();
            result.addAll(DEFAULT_IGNORE_AUTH_URLS);
            for (SecurityExemptionEndPoint endPoint : this.securityExemptionEndPoints) {
                result.addAll(endPoint.getIgnoreAuthUrlPatterns());
            }
            return result.toArray(new String[result.size()]);
        }
    }
}

