/*
 * Decompiled with CFR 0.152.
 */
package org.squashtest.tm.web.config;

import java.time.Duration;
import javax.inject.Inject;
import javax.persistence.EntityManagerFactory;
import javax.persistence.PersistenceUnit;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.web.ResourceProperties;
import org.springframework.context.annotation.Configuration;
import org.springframework.orm.jpa.support.OpenEntityManagerInViewInterceptor;
import org.springframework.web.context.request.WebRequestInterceptor;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.ViewControllerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.springframework.web.servlet.resource.CssLinkResourceTransformer;
import org.springframework.web.servlet.resource.GzipResourceResolver;
import org.springframework.web.servlet.resource.ResourceResolver;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.VersionResourceResolver;
import org.squashtest.tm.web.config.ResourceResolverProperties;
import org.squashtest.tm.web.internal.interceptor.ActiveMilestoneInterceptor;
import org.squashtest.tm.web.internal.interceptor.LoggingInterceptor;
import org.squashtest.tm.web.internal.interceptor.SecurityExpressionResolverExposerInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.CampaignViewInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.ExecutionViewInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.IterationViewInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.RequirementViewInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.TestCaseViewInterceptor;
import org.squashtest.tm.web.internal.interceptor.openedentity.TestSuiteViewInterceptor;

@Configuration
public class WebMvcConfig
implements WebMvcConfigurer {
    @Value(value="${info.app.version}")
    private String appVersion;
    @PersistenceUnit
    private EntityManagerFactory emf;
    @Inject
    private ResourceProperties resourceProperties;
    @Inject
    private ResourceResolverProperties resourceResolverProperties;
    @Inject
    private SecurityExpressionResolverExposerInterceptor securityExpressionResolverExposerInterceptor;
    @Inject
    private CampaignViewInterceptor campaignViewInterceptor;
    @Inject
    private ExecutionViewInterceptor executionViewInterceptor;
    @Inject
    private TestCaseViewInterceptor testCaseViewInterceptor;
    @Inject
    private RequirementViewInterceptor requirementViewInterceptor;
    @Inject
    private IterationViewInterceptor iterationViewInterceptor;
    @Inject
    private TestSuiteViewInterceptor testSuiteViewInterceptor;
    @Inject
    private ActiveMilestoneInterceptor milestoneInterceptor;

    public void addInterceptors(InterceptorRegistry registry) {
        LoggingInterceptor loggingInterceptor = new LoggingInterceptor();
        registry.addWebRequestInterceptor((WebRequestInterceptor)loggingInterceptor);
        OpenEntityManagerInViewInterceptor osiv = new OpenEntityManagerInViewInterceptor();
        osiv.setEntityManagerFactory(this.emf);
        registry.addWebRequestInterceptor((WebRequestInterceptor)osiv);
        registry.addInterceptor((HandlerInterceptor)this.milestoneInterceptor);
        registry.addInterceptor((HandlerInterceptor)this.securityExpressionResolverExposerInterceptor).excludePathPatterns(new String[]{"/", "/login"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.testCaseViewInterceptor).addPathPatterns(new String[]{"/test-cases/*", "/test-cases/*/info", "/test-cases/*/verified-requirement-versions/manager"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.requirementViewInterceptor).addPathPatterns(new String[]{"/requirement-versions/*", "/requirement-versions/*/info", "/requirement-versions/*/verifying-test-cases/manager", "/requirement-versions/*/linked-requirement-versions/manager"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.campaignViewInterceptor).addPathPatterns(new String[]{"/campaigns/*", "/campaigns/*/info", "/campaigns/*/test-plan/manager"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.iterationViewInterceptor).addPathPatterns(new String[]{"/iterations/*", "/iterations/*/info", "/iterations/*/test-plan/manager"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.testSuiteViewInterceptor).addPathPatterns(new String[]{"/test-suites/*", "/test-suites/*/info", "/test-suites/*/test-plan/manager"});
        registry.addWebRequestInterceptor((WebRequestInterceptor)this.executionViewInterceptor).addPathPatterns(new String[]{"/executions/*", "/executions/*/info"});
    }

    public void addViewControllers(ViewControllerRegistry registry) {
        registry.addRedirectViewController("/", "/home-workspace");
    }

    public void addResourceHandlers(ResourceHandlerRegistry registry) {
        VersionResourceResolver versionResolver = new VersionResourceResolver().addContentVersionStrategy(new String[]{this.appVersion, "/**/*.png", "/**/*.gif", "/**/*.jpg", "/**/*.css"}).addFixedVersionStrategy(this.appVersion, new String[]{"/**/*.js"});
        GzipResourceResolver gzipResolver = new GzipResourceResolver();
        CssLinkResourceTransformer transformer = new CssLinkResourceTransformer();
        Duration cacheDuration = this.resourceProperties.getCache().getPeriod();
        Integer cacheSeconds = Math.toIntExact(cacheDuration.getSeconds());
        boolean isCache = this.resourceResolverProperties.isCache();
        registry.addResourceHandler(new String[]{"/images/**"}).addResourceLocations(new String[]{"/images/", "classpath:/images/"}).setCachePeriod(cacheSeconds).resourceChain(isCache).addResolver((ResourceResolver)versionResolver).addTransformer((ResourceTransformer)transformer);
        registry.addResourceHandler(new String[]{"/styles/**"}).addResourceLocations(new String[]{"/styles/", "classpath:/styles/"}).setCachePeriod(cacheSeconds).resourceChain(isCache).addResolver((ResourceResolver)gzipResolver).addResolver((ResourceResolver)versionResolver).addTransformer((ResourceTransformer)transformer);
        registry.addResourceHandler(new String[]{"/scripts/**"}).addResourceLocations(new String[]{"/scripts/", "classpath:/scripts/"}).setCachePeriod(cacheSeconds).resourceChain(isCache).addResolver((ResourceResolver)gzipResolver).addResolver((ResourceResolver)versionResolver);
    }
}

